/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.core.Member;
import com.hazelcast.core.MigrationEvent;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.PartitionEventManager;
import com.hazelcast.internal.partition.impl.PartitionStateManager;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.partition.MigrationEndpoint;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

public final class PromoteFromBackupOperation
extends AbstractOperation
implements PartitionAwareOperation,
MigrationCycleOperation {
    private final int currentReplicaIndex;
    private ILogger logger;

    public PromoteFromBackupOperation(int currentReplicaIndex) {
        this.currentReplicaIndex = currentReplicaIndex;
    }

    void initLogger() {
        this.logger = this.getLogger();
    }

    @Override
    public void beforeRun() throws Exception {
        this.initLogger();
        this.sendMigrationEvent(MigrationEvent.MigrationStatus.STARTED);
    }

    @Override
    public void run() throws Exception {
        this.shiftUpReplicaVersions();
        this.migrateServices();
    }

    @Override
    public void afterRun() throws Exception {
        this.sendMigrationEvent(MigrationEvent.MigrationStatus.COMPLETED);
    }

    private void sendMigrationEvent(MigrationEvent.MigrationStatus status) {
        int partitionId = this.getPartitionId();
        NodeEngine nodeEngine = this.getNodeEngine();
        Member localMember = nodeEngine.getLocalMember();
        MigrationEvent event = new MigrationEvent(partitionId, null, localMember, status);
        EventService eventService = nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:core:partitionService", ".migration");
        eventService.publishEvent("hz:core:partitionService", registrations, (Object)event, partitionId);
    }

    private void shiftUpReplicaVersions() {
        int partitionId = this.getPartitionId();
        try {
            InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
            long[] versions = partitionService.getPartitionReplicaVersions(partitionId);
            int lostReplicaIndex = this.currentReplicaIndex - 1;
            if (this.currentReplicaIndex > 1) {
                long[] versionsCopy = Arrays.copyOf(versions, versions.length);
                long version = versions[lostReplicaIndex];
                Arrays.fill(versions, 0, lostReplicaIndex, version);
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Partition replica is lost! partitionId=" + partitionId + " lost replicaIndex=" + lostReplicaIndex + " replica versions before shift up=" + Arrays.toString(versionsCopy) + " replica versions after shift up=" + Arrays.toString(versions));
                }
            } else if (this.logger.isFinestEnabled()) {
                this.logger.finest("PROMOTE partitionId=" + this.getPartitionId() + " from currentReplicaIndex=" + this.currentReplicaIndex);
            }
            PartitionEventManager partitionEventManager = partitionService.getPartitionEventManager();
            partitionEventManager.sendPartitionLostEvent(partitionId, lostReplicaIndex);
        }
        catch (Throwable e) {
            this.logger.warning("Promotion failed. partitionId=" + partitionId + " replicaIndex=" + this.currentReplicaIndex, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateServices() {
        try {
            this.sendToAllMigrationAwareServices(new PartitionMigrationEvent(MigrationEndpoint.DESTINATION, this.getPartitionId(), this.currentReplicaIndex, 0));
        }
        finally {
            this.clearPartitionMigratingFlag();
        }
    }

    private void sendToAllMigrationAwareServices(PartitionMigrationEvent event) {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        for (MigrationAwareService service : nodeEngine.getServices(MigrationAwareService.class)) {
            try {
                service.beforeMigration(event);
                service.commitMigration(event);
            }
            catch (Throwable e) {
                this.getLogger().warning("While promoting partitionId=" + this.getPartitionId(), e);
            }
        }
    }

    private void clearPartitionMigratingFlag() {
        InternalPartitionServiceImpl service = (InternalPartitionServiceImpl)this.getService();
        PartitionStateManager partitionStateManager = service.getPartitionStateManager();
        InternalPartitionImpl partition = partitionStateManager.getPartitionImpl(this.getPartitionId());
        partition.setMigrating(false);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }
}

