/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.plugin.multicast;

import com.hazelcast.internal.plugin.multicast.MulticastMemberInfo;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.MulticastSocket;

public class MulticastDiscoveryReceiver {
    private static final int DATAGRAM_BUFFER_SIZE = 65536;
    MulticastSocket multicastSocket;
    DatagramPacket datagramPacketReceive = new DatagramPacket(new byte[65536], 65536);
    ILogger logger;

    public MulticastDiscoveryReceiver(MulticastSocket multicastSocket, ILogger logger) {
        this.multicastSocket = multicastSocket;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MulticastMemberInfo receive() {
        MulticastMemberInfo multicastMemberInfo;
        ObjectInputStream in = null;
        ByteArrayInputStream bis = null;
        try {
            MulticastMemberInfo multicastMemberInfo2;
            this.multicastSocket.receive(this.datagramPacketReceive);
            byte[] data = this.datagramPacketReceive.getData();
            bis = new ByteArrayInputStream(data);
            in = new ObjectInputStream(bis);
            Object o = in.readObject();
            multicastMemberInfo = multicastMemberInfo2 = (MulticastMemberInfo)o;
        }
        catch (Exception e) {
            try {
                this.logger.finest("Couldn't get member info from multicast channel " + e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(bis);
                IOUtil.closeResource(in);
                throw throwable;
            }
            IOUtil.closeResource(bis);
            IOUtil.closeResource(in);
            return null;
        }
        IOUtil.closeResource(bis);
        IOUtil.closeResource(in);
        return multicastMemberInfo;
    }
}

