/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.plugin.multicast;

import com.hazelcast.internal.plugin.multicast.MulticastMemberInfo;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.DiscoveryNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.MulticastSocket;

public class MulticastDiscoverySender
implements Runnable {
    private static final int SLEEP_DURATION = 2000;
    MulticastSocket multicastSocket;
    MulticastMemberInfo multicastMemberInfo;
    DatagramPacket datagramPacket;
    ILogger logger;
    private boolean stop;

    public MulticastDiscoverySender(DiscoveryNode discoveryNode, MulticastSocket multicastSocket, ILogger logger) throws IOException {
        this.multicastSocket = multicastSocket;
        this.logger = logger;
        if (discoveryNode != null) {
            Address address = discoveryNode.getPublicAddress();
            this.multicastMemberInfo = new MulticastMemberInfo(address.getHost(), address.getPort());
        }
        this.initDatagramPacket();
    }

    private void initDatagramPacket() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(this.multicastMemberInfo);
        byte[] yourBytes = bos.toByteArray();
        this.datagramPacket = new DatagramPacket(yourBytes, yourBytes.length, this.multicastSocket.getInetAddress(), this.multicastSocket.getPort());
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this.logger.finest("Thread sleeping interrupted. This may due to graceful shutdown.");
            }
            try {
                this.send();
            }
            catch (IOException e) {
                this.logger.finest(e.getMessage());
            }
        }
    }

    void send() throws IOException {
        this.multicastSocket.send(this.datagramPacket);
    }

    void stop() {
        this.stop = true;
    }
}

