/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.plugin.multicast;

import com.hazelcast.internal.plugin.multicast.MulticastDiscoveryReceiver;
import com.hazelcast.internal.plugin.multicast.MulticastDiscoverySender;
import com.hazelcast.internal.plugin.multicast.MulticastMemberInfo;
import com.hazelcast.internal.plugin.multicast.MulticastProperties;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.hazelcast.spi.partitiongroup.PartitionGroupStrategy;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MulticastDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final int DATA_OUTPUT_BUFFER_SIZE = 65536;
    private static final int DEFAULT_MULTICAST_PORT = 3476928;
    private static final int SOCKET_TIME_TO_LIVE = 255;
    private static final int SOCKET_TIMEOUT = 3000;
    private static final String DEFAULT_MULTICAST_GROUP = "224.2.2.3";
    private DiscoveryNode discoveryNode;
    private MulticastSocket multicastSocket;
    private Thread thread;
    private MulticastDiscoveryReceiver multicastDiscoveryReceiver;
    private MulticastDiscoverySender multicastDiscoverySender;
    private ILogger logger;
    private boolean isClient;

    public MulticastDiscoveryStrategy(DiscoveryNode discoveryNode, ILogger logger, Map<String, Comparable> properties) {
        super(logger, properties);
        this.discoveryNode = discoveryNode;
        this.logger = logger;
    }

    private void initializeMulticastSocket() {
        try {
            int port = this.getOrDefault(MulticastProperties.PORT, 3476928);
            String group = this.getOrDefault(MulticastProperties.GROUP, DEFAULT_MULTICAST_GROUP);
            this.multicastSocket = new MulticastSocket(port);
            this.multicastSocket.setReuseAddress(true);
            this.multicastSocket.setTimeToLive(255);
            this.multicastSocket.setReceiveBufferSize(65536);
            this.multicastSocket.setSendBufferSize(65536);
            this.multicastSocket.setSoTimeout(3000);
            this.multicastSocket.joinGroup(InetAddress.getByName(group));
            this.multicastDiscoverySender = new MulticastDiscoverySender(this.discoveryNode, this.multicastSocket, this.logger);
            this.multicastDiscoveryReceiver = new MulticastDiscoveryReceiver(this.multicastSocket, this.logger);
            if (this.discoveryNode != null) {
                this.isClient = false;
            }
        }
        catch (Exception e) {
            this.logger.finest(e.getMessage());
        }
    }

    @Override
    public void start() {
        this.initializeMulticastSocket();
        if (!this.isClient) {
            this.thread = new Thread(this.multicastDiscoverySender);
            this.thread.start();
        }
    }

    @Override
    public Iterable<DiscoveryNode> discoverNodes() {
        MulticastMemberInfo multicastMemberInfo = this.multicastDiscoveryReceiver.receive();
        if (multicastMemberInfo == null) {
            return null;
        }
        ArrayList<DiscoveryNode> arrayList = new ArrayList<DiscoveryNode>();
        try {
            SimpleDiscoveryNode discoveryNode = new SimpleDiscoveryNode(new Address(multicastMemberInfo.getHost(), multicastMemberInfo.getPort()));
            arrayList.add(discoveryNode);
        }
        catch (UnknownHostException e) {
            this.logger.finest(e.getMessage());
        }
        return arrayList;
    }

    @Override
    public void destroy() {
        this.multicastDiscoverySender.stop();
        this.thread.interrupt();
    }

    @Override
    public PartitionGroupStrategy getPartitionGroupStrategy() {
        return null;
    }

    @Override
    public Map<String, Object> discoverLocalMetadata() {
        return new HashMap<String, Object>();
    }
}

