/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.plugin.multicast;

import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.config.properties.PropertyTypeConverter;
import com.hazelcast.config.properties.SimplePropertyDefinition;
import com.hazelcast.config.properties.ValidationException;
import com.hazelcast.config.properties.ValueValidator;

public final class MulticastProperties {
    public static final PropertyDefinition PORT = MulticastProperties.property("port", PropertyTypeConverter.STRING);
    public static final PropertyDefinition GROUP = MulticastProperties.property("group", PropertyTypeConverter.STRING);
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 65535;

    private MulticastProperties() {
    }

    private static PropertyDefinition property(String key, PropertyTypeConverter typeConverter) {
        return MulticastProperties.property(key, typeConverter, null);
    }

    private static PropertyDefinition property(String key, PropertyTypeConverter typeConverter, ValueValidator valueValidator) {
        return new SimplePropertyDefinition(key, true, typeConverter, valueValidator);
    }

    protected static class PortValueValidator
    implements ValueValidator<Integer> {
        protected PortValueValidator() {
        }

        @Override
        public void validate(Integer value) throws ValidationException {
            if (value < 0) {
                throw new ValidationException("hz-port number must be greater 0");
            }
            if (value > 65535) {
                throw new ValidationException("hz-port number must be less or equal to 65535");
            }
        }
    }
}

