/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.MapConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.core.IFunction;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.map.eviction.MapEvictionPolicy;
import com.hazelcast.map.impl.InterceptorRegistry;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitioningStrategyFactory;
import com.hazelcast.map.impl.SizeEstimator;
import com.hazelcast.map.impl.SizeEstimators;
import com.hazelcast.map.impl.eviction.EvictionChecker;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.eviction.EvictorImpl;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.mapstore.MapStoreContextFactory;
import com.hazelcast.map.impl.query.QueryEntryFactory;
import com.hazelcast.map.impl.record.DataRecordFactory;
import com.hazelcast.map.impl.record.ObjectRecordFactory;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.RuntimeMemoryInfoAccessor;
import com.hazelcast.wan.WanReplicationPublisher;
import com.hazelcast.wan.WanReplicationService;
import java.util.concurrent.atomic.AtomicInteger;

public class MapContainer {
    protected final String name;
    protected final String quorumName;
    protected final MapServiceContext mapServiceContext;
    protected final Indexes indexes;
    protected final Extractors extractors;
    protected final SizeEstimator nearCacheSizeEstimator;
    protected final PartitioningStrategy partitioningStrategy;
    protected final MapStoreContext mapStoreContext;
    protected final SerializationService serializationService;
    protected final QueryEntryFactory queryEntryFactory;
    protected final InterceptorRegistry interceptorRegistry = new InterceptorRegistry();
    protected final IFunction<Object, Data> toDataFunction = new IFunction<Object, Data>(){

        @Override
        public Data apply(Object input) {
            SerializationService ss = MapContainer.this.mapStoreContext.getSerializationService();
            return ss.toData(input, MapContainer.this.partitioningStrategy);
        }
    };
    protected final ConstructorFunction<Void, RecordFactory> recordFactoryConstructor;
    protected final boolean memberNearCacheInvalidationEnabled;
    protected final AtomicInteger invalidationListenerCount = new AtomicInteger();
    protected WanReplicationPublisher wanReplicationPublisher;
    protected MapMergePolicy wanMergePolicy;
    protected volatile Evictor evictor;
    protected volatile MapConfig mapConfig;

    public MapContainer(String name, MapConfig mapConfig, MapServiceContext mapServiceContext) {
        this.name = name;
        this.mapConfig = mapConfig;
        this.mapServiceContext = mapServiceContext;
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        this.partitioningStrategy = this.createPartitioningStrategy();
        this.quorumName = mapConfig.getQuorumName();
        this.serializationService = nodeEngine.getSerializationService();
        this.recordFactoryConstructor = this.createRecordFactoryConstructor(this.serializationService);
        this.queryEntryFactory = new QueryEntryFactory(mapConfig.getCacheDeserializedValues());
        this.initWanReplication(nodeEngine);
        this.nearCacheSizeEstimator = SizeEstimators.createNearCacheSizeEstimator(mapConfig.getNearCacheConfig());
        this.extractors = new Extractors(mapConfig.getMapAttributeConfigs());
        this.indexes = new Indexes((InternalSerializationService)this.serializationService, this.extractors);
        this.memberNearCacheInvalidationEnabled = this.hasMemberNearCache() && mapConfig.getNearCacheConfig().isInvalidateOnChange();
        this.mapStoreContext = MapStoreContextFactory.createMapStoreContext(this);
        this.mapStoreContext.start();
        this.initEvictor();
    }

    public void initEvictor() {
        MapEvictionPolicy mapEvictionPolicy = this.mapConfig.getMapEvictionPolicy();
        if (mapEvictionPolicy == null) {
            this.evictor = Evictor.NULL_EVICTOR;
        } else {
            EvictionChecker evictionChecker = new EvictionChecker(new RuntimeMemoryInfoAccessor(), this.mapServiceContext);
            IPartitionService partitionService = this.mapServiceContext.getNodeEngine().getPartitionService();
            this.evictor = new EvictorImpl(mapEvictionPolicy, evictionChecker, partitionService);
        }
    }

    ConstructorFunction<Void, RecordFactory> createRecordFactoryConstructor(final SerializationService serializationService) {
        return new ConstructorFunction<Void, RecordFactory>(){

            @Override
            public RecordFactory createNew(Void notUsedArg) {
                switch (MapContainer.this.mapConfig.getInMemoryFormat()) {
                    case BINARY: {
                        return new DataRecordFactory(MapContainer.this.mapConfig, serializationService, MapContainer.this.partitioningStrategy);
                    }
                    case OBJECT: {
                        return new ObjectRecordFactory(MapContainer.this.mapConfig, serializationService);
                    }
                }
                throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)MapContainer.this.mapConfig.getInMemoryFormat()));
            }
        };
    }

    public void initWanReplication(NodeEngine nodeEngine) {
        WanReplicationRef wanReplicationRef = this.mapConfig.getWanReplicationRef();
        if (wanReplicationRef == null) {
            return;
        }
        String wanReplicationRefName = wanReplicationRef.getName();
        WanReplicationService wanReplicationService = nodeEngine.getWanReplicationService();
        this.wanReplicationPublisher = wanReplicationService.getWanReplicationPublisher(wanReplicationRefName);
        this.wanMergePolicy = this.mapServiceContext.getMergePolicyProvider().getMergePolicy(wanReplicationRef.getMergePolicy());
    }

    private PartitioningStrategy createPartitioningStrategy() {
        return PartitioningStrategyFactory.getPartitioningStrategy(this.mapServiceContext.getNodeEngine(), this.mapConfig.getName(), this.mapConfig.getPartitioningStrategyConfig());
    }

    public Indexes getIndexes() {
        return this.indexes;
    }

    public WanReplicationPublisher getWanReplicationPublisher() {
        return this.wanReplicationPublisher;
    }

    public MapMergePolicy getWanMergePolicy() {
        return this.wanMergePolicy;
    }

    public boolean isWanReplicationEnabled() {
        return this.wanReplicationPublisher != null && this.wanMergePolicy != null;
    }

    public void checkWanReplicationQueues() {
        if (this.isWanReplicationEnabled()) {
            this.wanReplicationPublisher.checkWanReplicationQueues();
        }
    }

    public boolean hasMemberNearCache() {
        return this.mapConfig.isNearCacheEnabled();
    }

    public int getTotalBackupCount() {
        return this.getBackupCount() + this.getAsyncBackupCount();
    }

    public int getBackupCount() {
        return this.mapConfig.getBackupCount();
    }

    public int getAsyncBackupCount() {
        return this.mapConfig.getAsyncBackupCount();
    }

    public PartitioningStrategy getPartitioningStrategy() {
        return this.partitioningStrategy;
    }

    public SizeEstimator getNearCacheSizeEstimator() {
        return this.nearCacheSizeEstimator;
    }

    public MapServiceContext getMapServiceContext() {
        return this.mapServiceContext;
    }

    public MapStoreContext getMapStoreContext() {
        return this.mapStoreContext;
    }

    public MapConfig getMapConfig() {
        return this.mapConfig;
    }

    public void setMapConfig(MapConfig mapConfig) {
        this.mapConfig = mapConfig;
    }

    public String getName() {
        return this.name;
    }

    public String getQuorumName() {
        return this.quorumName;
    }

    public IFunction<Object, Data> toData() {
        return this.toDataFunction;
    }

    public ConstructorFunction<Void, RecordFactory> getRecordFactoryConstructor() {
        return this.recordFactoryConstructor;
    }

    public QueryableEntry newQueryEntry(Data key, Object value) {
        return this.queryEntryFactory.newEntry((InternalSerializationService)this.serializationService, key, value, this.extractors);
    }

    public Evictor getEvictor() {
        return this.evictor;
    }

    public void setEvictor(Evictor evictor) {
        this.evictor = evictor;
    }

    public Extractors getExtractors() {
        return this.extractors;
    }

    public boolean isMemberNearCacheInvalidationEnabled() {
        return this.memberNearCacheInvalidationEnabled;
    }

    public boolean hasInvalidationListener() {
        return this.invalidationListenerCount.get() > 0;
    }

    public void increaseInvalidationListenerCount() {
        this.invalidationListenerCount.incrementAndGet();
    }

    public void decreaseInvalidationListenerCount() {
        this.invalidationListenerCount.decrementAndGet();
    }

    public boolean isInvalidationEnabled() {
        return this.isMemberNearCacheInvalidationEnabled() || this.hasInvalidationListener();
    }

    public InterceptorRegistry getInterceptorRegistry() {
        return this.interceptorRegistry;
    }
}

