/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.eviction;

import com.hazelcast.core.EntryView;
import com.hazelcast.map.eviction.MapEvictionPolicy;
import com.hazelcast.map.impl.eviction.EvictionChecker;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.LazyEntryViewFromRecord;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.partition.IPartition;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.Preconditions;

public class EvictorImpl
implements Evictor {
    protected final EvictionChecker evictionChecker;
    protected final IPartitionService partitionService;
    protected final MapEvictionPolicy mapEvictionPolicy;

    public EvictorImpl(MapEvictionPolicy mapEvictionPolicy, EvictionChecker evictionChecker, IPartitionService partitionService) {
        this.evictionChecker = Preconditions.checkNotNull(evictionChecker);
        this.partitionService = Preconditions.checkNotNull(partitionService);
        this.mapEvictionPolicy = Preconditions.checkNotNull(mapEvictionPolicy);
    }

    @Override
    public void evict(RecordStore recordStore) {
        EntryView evictableEntry = this.selectEvictableEntry(recordStore);
        if (evictableEntry == null) {
            return;
        }
        this.evictEntry(evictableEntry, recordStore);
    }

    private EntryView selectEvictableEntry(RecordStore recordStore) {
        Iterable<EntryView> samples = this.getSamples(recordStore);
        EntryView selected = null;
        for (EntryView candidate : samples) {
            if (selected == null) {
                selected = candidate;
                continue;
            }
            if (this.mapEvictionPolicy.compare(candidate, selected) >= 0) continue;
            selected = candidate;
        }
        return selected;
    }

    private void evictEntry(EntryView selectedEntry, RecordStore recordStore) {
        Record record = this.getRecordFromEntryView(selectedEntry);
        Data key = record.getKey();
        if (recordStore.isLocked(record.getKey())) {
            return;
        }
        boolean backup = this.isBackup(recordStore);
        recordStore.evict(key, backup);
        if (!backup) {
            recordStore.doPostEvictionOperations(record, backup);
        }
    }

    @Override
    public boolean checkEvictable(RecordStore recordStore) {
        return this.evictionChecker.checkEvictable(recordStore);
    }

    protected Record getRecordFromEntryView(EntryView selectedEntry) {
        return ((LazyEntryViewFromRecord)selectedEntry).getRecord();
    }

    protected boolean isBackup(RecordStore recordStore) {
        int partitionId = recordStore.getPartitionId();
        IPartition partition = this.partitionService.getPartition(partitionId, false);
        return !partition.isLocal();
    }

    protected Iterable<EntryView> getSamples(RecordStore recordStore) {
        Storage storage = recordStore.getStorage();
        return storage.getRandomSamples(SAMPLE_COUNT);
    }

    protected static long getNow() {
        return Clock.currentTimeMillis();
    }
}

