/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.map.impl.operation.LockAwareOperation;
import com.hazelcast.map.impl.operation.RemoveBackupOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.Clock;

public abstract class BaseRemoveOperation
extends LockAwareOperation
implements BackupAwareOperation {
    protected transient Data dataOldValue;
    protected transient boolean disableWanReplicationEvent;

    public BaseRemoveOperation(String name, Data dataKey, boolean disableWanReplicationEvent) {
        super(name, dataKey);
        this.disableWanReplicationEvent = disableWanReplicationEvent;
    }

    public BaseRemoveOperation(String name, Data dataKey) {
        this(name, dataKey, false);
    }

    public BaseRemoveOperation() {
    }

    @Override
    public void afterRun() {
        this.mapServiceContext.interceptAfterRemove(this.name, this.dataValue);
        this.mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, EntryEventType.REMOVED, this.dataKey, this.dataOldValue, null);
        this.invalidateNearCache(this.dataKey);
        if (this.mapContainer.isWanReplicationEnabled() && !this.disableWanReplicationEvent) {
            this.mapEventPublisher.publishWanReplicationRemove(this.name, this.dataKey, Clock.currentTimeMillis());
        }
        this.evict();
    }

    @Override
    public Object getResponse() {
        return this.dataOldValue;
    }

    @Override
    public Operation getBackupOperation() {
        return new RemoveBackupOperation(this.name, this.dataKey, false, this.disableWanReplicationEvent);
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(null);
    }
}

