/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.MultipleEntryWithPredicateOperation;
import com.hazelcast.map.impl.operation.PartitionWideEntryWithPredicateOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.predicates.QueryOptimizer;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionAwareOperationFactory;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.collection.InflatableSet;
import com.hazelcast.util.collection.Int2ObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PartitionWideEntryWithPredicateOperationFactory
implements PartitionAwareOperationFactory {
    private String name;
    private EntryProcessor entryProcessor;
    private Predicate predicate;
    private transient Set<Data> keySet;
    private transient NodeEngine nodeEngine;
    private transient boolean hasIndex;
    private transient Map<Integer, List<Data>> partitionIdToKeys;

    public PartitionWideEntryWithPredicateOperationFactory() {
    }

    public PartitionWideEntryWithPredicateOperationFactory(String name, EntryProcessor entryProcessor, Predicate predicate) {
        this.name = name;
        this.entryProcessor = entryProcessor;
        this.predicate = predicate;
    }

    @Override
    public void init(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.queryIndex();
    }

    private void queryIndex() {
        if (this.predicate == TruePredicate.INSTANCE) {
            return;
        }
        MapService mapService = (MapService)this.nodeEngine.getService("hz:impl:mapService");
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        Indexes indexes = mapServiceContext.getMapContainer(this.name).getIndexes();
        QueryOptimizer queryOptimizer = mapServiceContext.getQueryOptimizer();
        this.predicate = queryOptimizer.optimize(this.predicate, indexes);
        Set<QueryableEntry> querySet = indexes.query(this.predicate);
        if (querySet == null) {
            return;
        }
        ArrayList<Data> keys = null;
        for (QueryableEntry e : querySet) {
            if (keys == null) {
                keys = new ArrayList<Data>(querySet.size());
            }
            keys.add(e.getKeyData());
        }
        this.hasIndex = true;
        this.keySet = keys == null ? Collections.emptySet() : InflatableSet.newBuilder(keys).build();
    }

    @Override
    public Operation createPartitionOperation(int partition) {
        if (this.hasIndex) {
            List<Data> keys = this.partitionIdToKeys.get(partition);
            InflatableSet<Data> keySet = InflatableSet.newBuilder(keys).build();
            return new MultipleEntryWithPredicateOperation(this.name, keySet, this.entryProcessor, this.predicate);
        }
        return this.createOperation();
    }

    @Override
    public int[] getPartitions() {
        if (!this.hasIndex) {
            return null;
        }
        this.partitionIdToKeys = this.getPartitionIdToKeysMap();
        return CollectionUtil.toIntArray(this.partitionIdToKeys.keySet());
    }

    private Map<Integer, List<Data>> getPartitionIdToKeysMap() {
        if (CollectionUtil.isEmpty(this.keySet)) {
            return Collections.emptyMap();
        }
        Int2ObjectHashMap<List<Data>> partitionToKeys = new Int2ObjectHashMap<List<Data>>();
        for (Data key : this.keySet) {
            int partitionId = this.nodeEngine.getPartitionService().getPartitionId(key);
            ArrayList<Data> keyList = (ArrayList<Data>)partitionToKeys.get((Object)partitionId);
            if (keyList == null) {
                keyList = new ArrayList<Data>();
                partitionToKeys.put(Integer.valueOf(partitionId), (List<Data>)keyList);
            }
            keyList.add(key);
        }
        return partitionToKeys;
    }

    @Override
    public Operation createOperation() {
        return new PartitionWideEntryWithPredicateOperation(this.name, this.entryProcessor, this.predicate);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeObject(this.entryProcessor);
        out.writeObject(this.predicate);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.entryProcessor = (EntryProcessor)in.readObject();
        this.predicate = (Predicate)in.readObject();
    }
}

