/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.PutAllOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationAccessor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.concurrent.Future;

public class PutAllPerMemberOperation
extends MapOperation
implements IdentifiedDataSerializable {
    private int[] partitions;
    private MapEntries[] mapEntries;

    public PutAllPerMemberOperation() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public PutAllPerMemberOperation(String name, int[] partitions, MapEntries[] mapEntries) {
        super(name);
        this.partitions = partitions;
        this.mapEntries = mapEntries;
    }

    @Override
    public void run() throws Exception {
        NodeEngine nodeEngine = this.getNodeEngine();
        Future[] futures = new Future[this.partitions.length];
        for (int i = 0; i < this.partitions.length; ++i) {
            PutAllOperation op = new PutAllOperation(this.name, this.mapEntries[i]);
            op.setNodeEngine(nodeEngine).setPartitionId(this.partitions[i]).setReplicaIndex(this.getReplicaIndex()).setService(this.getService()).setCallerUuid(this.getCallerUuid());
            OperationAccessor.setCallerAddress(op, this.getCallerAddress());
            futures[i] = nodeEngine.getOperationService().invokeOnPartition(op);
        }
        for (Future future : futures) {
            future.get();
        }
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public Object getResponse() {
        return null;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeIntArray(this.partitions);
        for (MapEntries entry : this.mapEntries) {
            entry.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.partitions = in.readIntArray();
        this.mapEntries = new MapEntries[this.partitions.length];
        for (int i = 0; i < this.partitions.length; ++i) {
            MapEntries entry = new MapEntries();
            entry.readData(in);
            this.mapEntries[i] = entry;
        }
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 13;
    }
}

