/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.proxy;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.SimpleEntryView;
import com.hazelcast.map.impl.proxy.MapProxySupport;
import com.hazelcast.map.impl.query.MapQueryEngine;
import com.hazelcast.map.impl.query.QueryResult;
import com.hazelcast.map.impl.query.QueryResultCollection;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.MappingJob;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.mapreduce.ReducingSubmittableJob;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.spi.InitializingObject;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class MapProxyImpl<K, V>
extends MapProxySupport
implements IMap<K, V>,
InitializingObject {
    public MapProxyImpl(String name, MapService mapService, NodeEngine nodeEngine, MapConfig mapConfig) {
        super(name, mapService, nodeEngine, mapConfig);
    }

    @Override
    public V get(Object k) {
        Preconditions.checkNotNull(k, "Null key is not allowed!");
        Data key = this.toData(k, this.partitionStrategy);
        return (V)this.toObject(this.getInternal(key));
    }

    @Override
    public V put(K k, V v) {
        return this.put(k, v, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public V put(K k, V v, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(k, "Null key is not allowed!");
        Preconditions.checkNotNull(v, "Null value is not allowed!");
        Data key = this.toData(k, this.partitionStrategy);
        Data value = this.toData(v);
        Data result = this.putInternal(key, value, ttl, timeunit);
        return (V)this.toObject(result);
    }

    @Override
    public boolean tryPut(K k, V v, long timeout, TimeUnit timeunit) {
        Preconditions.checkNotNull(k, "Null key is not allowed!");
        Preconditions.checkNotNull(v, "Null value is not allowed!");
        Data key = this.toData(k, this.partitionStrategy);
        Data value = this.toData(v);
        return this.tryPutInternal(key, value, timeout, timeunit);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        return this.putIfAbsent(k, v, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public V putIfAbsent(K k, V v, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(k, "Null key is not allowed!");
        Preconditions.checkNotNull(v, "Null value is not allowed!");
        Data key = this.toData(k, this.partitionStrategy);
        Data value = this.toData(v);
        Data result = this.putIfAbsentInternal(key, value, ttl, timeunit);
        return (V)this.toObject(result);
    }

    @Override
    public void putTransient(K k, V v, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(k, "Null key is not allowed!");
        Preconditions.checkNotNull(v, "Null value is not allowed!");
        Data key = this.toData(k, this.partitionStrategy);
        Data value = this.toData(v);
        this.putTransientInternal(key, value, ttl, timeunit);
    }

    @Override
    public boolean replace(K k, V o, V v) {
        Preconditions.checkNotNull(k, "Null key is not allowed!");
        Preconditions.checkNotNull(o, "Null value is not allowed!");
        Preconditions.checkNotNull(v, "Null value is not allowed!");
        Data key = this.toData(k, this.partitionStrategy);
        Data oldValue = this.toData(o);
        Data value = this.toData(v);
        return this.replaceInternal(key, oldValue, value);
    }

    @Override
    public V replace(K k, V v) {
        Preconditions.checkNotNull(k, "Null key is not allowed!");
        Preconditions.checkNotNull(v, "Null value is not allowed!");
        Data key = this.toData(k, this.partitionStrategy);
        Data value = this.toData(v);
        return (V)this.toObject(this.replaceInternal(key, value));
    }

    @Override
    public void set(K key, V value) {
        this.set(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void set(K k, V v, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(k, "Null key is not allowed!");
        Preconditions.checkNotNull(v, "Null value is not allowed!");
        Data key = this.toData(k, this.partitionStrategy);
        Data value = this.toData(v);
        this.setInternal(key, value, ttl, timeunit);
    }

    @Override
    public V remove(Object k) {
        Preconditions.checkNotNull(k, "Null key is not allowed!");
        Data key = this.toData(k, this.partitionStrategy);
        Data result = this.removeInternal(key);
        return (V)this.toObject(result);
    }

    @Override
    public boolean remove(Object k, Object v) {
        Preconditions.checkNotNull(k, "Null key is not allowed!");
        Preconditions.checkNotNull(v, "Null value is not allowed!");
        Data key = this.toData(k, this.partitionStrategy);
        Data value = this.toData(v);
        return this.removeInternal(key, value);
    }

    @Override
    public void delete(Object k) {
        Preconditions.checkNotNull(k, "Null key is not allowed!");
        Data key = this.toData(k, this.partitionStrategy);
        this.deleteInternal(key);
    }

    @Override
    public boolean containsKey(Object k) {
        Preconditions.checkNotNull(k, "Null key is not allowed!");
        Data key = this.toData(k, this.partitionStrategy);
        return this.containsKeyInternal(key);
    }

    @Override
    public boolean containsValue(Object v) {
        Preconditions.checkNotNull(v, "Null value is not allowed!");
        Data value = this.toData(v);
        return this.containsValueInternal(value);
    }

    @Override
    public void lock(K key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = this.toData(key, this.partitionStrategy);
        this.lockSupport.lock(nodeEngine, dataKey);
    }

    @Override
    public void lock(Object key, long leaseTime, TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkPositive(leaseTime, "leaseTime should be positive");
        Data dataKey = this.toData(key, this.partitionStrategy);
        this.lockSupport.lock(this.getNodeEngine(), dataKey, timeUnit.toMillis(leaseTime));
    }

    @Override
    public void unlock(K key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = this.toData(key, this.partitionStrategy);
        this.lockSupport.unlock(nodeEngine, dataKey);
    }

    @Override
    public boolean tryRemove(K key, long timeout, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Data dataKey = this.toData(key, this.partitionStrategy);
        return this.tryRemoveInternal(dataKey, timeout, timeunit);
    }

    @Override
    public ICompletableFuture<V> getAsync(K k) {
        Preconditions.checkNotNull(k, "Null key is not allowed!");
        Data key = this.toData(k, this.partitionStrategy);
        NodeEngine nodeEngine = this.getNodeEngine();
        return new DelegatingFuture(this.getAsyncInternal(key), nodeEngine.getSerializationService());
    }

    @Override
    public boolean isLocked(K k) {
        Preconditions.checkNotNull(k, "Null key is not allowed!");
        Data key = this.toData(k, this.partitionStrategy);
        NodeEngine nodeEngine = this.getNodeEngine();
        return this.lockSupport.isLocked(nodeEngine, key);
    }

    @Override
    public ICompletableFuture<V> putAsync(K key, V value) {
        return this.putAsync((Object)key, (Object)value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ICompletableFuture<V> putAsync(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(value, "Null value is not allowed!");
        Data dataKey = this.toData(key, this.partitionStrategy);
        Data dataValue = this.toData(value);
        return new DelegatingFuture(this.putAsyncInternal(dataKey, dataValue, ttl, timeunit), this.getNodeEngine().getSerializationService());
    }

    @Override
    public ICompletableFuture<Void> setAsync(K key, V value) {
        return this.setAsync((Object)key, (Object)value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ICompletableFuture<Void> setAsync(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(value, "Null value is not allowed!");
        Data dataKey = this.toData(key, this.partitionStrategy);
        Data dataValue = this.toData(value);
        return new DelegatingFuture<Void>(this.setAsyncInternal(dataKey, dataValue, ttl, timeunit), this.getNodeEngine().getSerializationService());
    }

    @Override
    public ICompletableFuture<V> removeAsync(K key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Data dataKey = this.toData(key, this.partitionStrategy);
        return new DelegatingFuture(this.removeAsyncInternal(dataKey), this.getNodeEngine().getSerializationService());
    }

    @Override
    public Map<K, V> getAll(Set<K> keys) {
        if (CollectionUtil.isEmpty(keys)) {
            return Collections.emptyMap();
        }
        ArrayList<Data> requestedKeys = new ArrayList<Data>(keys.size());
        for (K key : keys) {
            Preconditions.checkNotNull(key, "Null key is not allowed!");
            Data dataKey = this.toData(key, this.partitionStrategy);
            requestedKeys.add(dataKey);
        }
        ArrayList<Object> resultingKeyValuePairs = new ArrayList<Object>(keys.size());
        this.getAllObjectInternal(requestedKeys, resultingKeyValuePairs);
        Map result = MapUtil.createHashMap(keys.size());
        int i = 0;
        while (i < resultingKeyValuePairs.size()) {
            Object key = this.toObject(resultingKeyValuePairs.get(i++));
            Object value = this.toObject(resultingKeyValuePairs.get(i++));
            result.put(key, value);
        }
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAllInternal(map);
    }

    @Override
    public boolean tryLock(K key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Data dataKey = this.toData(key, this.partitionStrategy);
        return this.lockSupport.tryLock(this.getNodeEngine(), dataKey);
    }

    @Override
    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Data dataKey = this.toData(key, this.partitionStrategy);
        return this.lockSupport.tryLock(this.getNodeEngine(), dataKey, time, timeunit);
    }

    @Override
    public boolean tryLock(K key, long time, TimeUnit timeunit, long leaseTime, TimeUnit leaseTimeUnit) throws InterruptedException {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Data dataKey = this.toData(key, this.partitionStrategy);
        return this.lockSupport.tryLock(this.getNodeEngine(), dataKey, time, timeunit, leaseTime, leaseTimeUnit);
    }

    @Override
    public void forceUnlock(K key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Data dataKey = this.toData(key, this.partitionStrategy);
        this.lockSupport.forceUnlock(this.getNodeEngine(), dataKey);
    }

    @Override
    public String addInterceptor(MapInterceptor interceptor) {
        Preconditions.checkNotNull(interceptor, "Interceptor should not be null!");
        return this.addMapInterceptorInternal(interceptor);
    }

    @Override
    public void removeInterceptor(String id) {
        Preconditions.checkNotNull(id, "Interceptor id should not be null!");
        this.removeMapInterceptorInternal(id);
    }

    @Override
    public String addLocalEntryListener(MapListener listener) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        return this.addLocalEntryListenerInternal(listener);
    }

    @Override
    public String addLocalEntryListener(EntryListener listener) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        return this.addLocalEntryListenerInternal(listener);
    }

    @Override
    public String addLocalEntryListener(MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        return this.addLocalEntryListenerInternal(listener, predicate, null, includeValue);
    }

    @Override
    public String addLocalEntryListener(EntryListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        return this.addLocalEntryListenerInternal(listener, predicate, null, includeValue);
    }

    @Override
    public String addLocalEntryListener(MapListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        Data keyData = this.toData(key, this.partitionStrategy);
        return this.addLocalEntryListenerInternal(listener, predicate, keyData, includeValue);
    }

    @Override
    public String addLocalEntryListener(EntryListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        Data keyData = this.toData(key, this.partitionStrategy);
        return this.addLocalEntryListenerInternal(listener, predicate, keyData, includeValue);
    }

    @Override
    public String addEntryListener(MapListener listener, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        return this.addEntryListenerInternal(listener, null, includeValue);
    }

    @Override
    public String addEntryListener(EntryListener listener, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        return this.addEntryListenerInternal(listener, null, includeValue);
    }

    @Override
    public String addEntryListener(MapListener listener, K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        return this.addEntryListenerInternal(listener, this.toData(key, this.partitionStrategy), includeValue);
    }

    @Override
    public String addEntryListener(EntryListener listener, K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        return this.addEntryListenerInternal(listener, this.toData(key, this.partitionStrategy), includeValue);
    }

    @Override
    public String addEntryListener(MapListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        return this.addEntryListenerInternal(listener, predicate, this.toData(key, this.partitionStrategy), includeValue);
    }

    @Override
    public String addEntryListener(EntryListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        return this.addEntryListenerInternal(listener, predicate, this.toData(key, this.partitionStrategy), includeValue);
    }

    @Override
    public String addEntryListener(MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        return this.addEntryListenerInternal(listener, predicate, null, includeValue);
    }

    @Override
    public String addEntryListener(EntryListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        return this.addEntryListenerInternal(listener, predicate, null, includeValue);
    }

    @Override
    public boolean removeEntryListener(String id) {
        Preconditions.checkNotNull(id, "Listener id should not be null!");
        return this.removeEntryListenerInternal(id);
    }

    @Override
    public String addPartitionLostListener(MapPartitionLostListener listener) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        return this.addPartitionLostListenerInternal(listener);
    }

    @Override
    public boolean removePartitionLostListener(String id) {
        Preconditions.checkNotNull(id, "Listener id should not be null!");
        return this.removePartitionLostListenerInternal(id);
    }

    @Override
    public EntryView<K, V> getEntryView(K key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        SimpleEntryView entryViewInternal = (SimpleEntryView)this.getEntryViewInternal(this.toData(key, this.partitionStrategy));
        if (entryViewInternal == null) {
            return null;
        }
        Data value = (Data)entryViewInternal.getValue();
        entryViewInternal.setKey(key);
        entryViewInternal.setValue(this.toObject(value));
        return entryViewInternal;
    }

    @Override
    public boolean evict(Object key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        return this.evictInternal(this.toData(key, this.partitionStrategy));
    }

    @Override
    public void evictAll() {
        this.evictAllInternal();
    }

    @Override
    public void loadAll(boolean replaceExistingValues) {
        Preconditions.checkTrue(this.isMapStoreEnabled(), "First you should configure a map store");
        this.loadAllInternal(replaceExistingValues);
    }

    @Override
    public void loadAll(Set<K> keys, boolean replaceExistingValues) {
        Preconditions.checkTrue(this.isMapStoreEnabled(), "First you should configure a map store");
        Preconditions.checkNotNull(keys, "Parameter keys should not be null.");
        Iterable<Data> dataKeys = this.convertToData(keys);
        this.loadInternal(dataKeys, replaceExistingValues);
    }

    @Override
    public void clear() {
        this.clearInternal();
    }

    public void clearMapOnly() {
        this.clearInternal();
    }

    @Override
    public Set<K> keySet() {
        return this.keySet(TruePredicate.INSTANCE);
    }

    @Override
    public Set<K> keySet(Predicate predicate) {
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        MapQueryEngine queryEngine = this.getMapQueryEngine();
        if (predicate instanceof PagingPredicate) {
            return queryEngine.queryAllPartitionsWithPagingPredicate(this.name, (PagingPredicate)predicate, IterationType.KEY);
        }
        QueryResult result = queryEngine.invokeQueryAllPartitions(this.name, predicate, IterationType.KEY);
        return new QueryResultCollection(this.getNodeEngine().getSerializationService(), IterationType.KEY, false, true, result);
    }

    @Override
    public Set entrySet() {
        return this.entrySet(TruePredicate.INSTANCE);
    }

    @Override
    public Set entrySet(Predicate predicate) {
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        MapQueryEngine queryEngine = this.getMapQueryEngine();
        if (predicate instanceof PagingPredicate) {
            return queryEngine.queryAllPartitionsWithPagingPredicate(this.name, (PagingPredicate)predicate, IterationType.ENTRY);
        }
        QueryResult result = queryEngine.invokeQueryAllPartitions(this.name, predicate, IterationType.ENTRY);
        return new QueryResultCollection(this.getNodeEngine().getSerializationService(), IterationType.ENTRY, false, true, result);
    }

    @Override
    public Collection<V> values() {
        return this.values(TruePredicate.INSTANCE);
    }

    @Override
    public Collection<V> values(Predicate predicate) {
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        MapQueryEngine queryEngine = this.getMapQueryEngine();
        if (predicate instanceof PagingPredicate) {
            return queryEngine.queryAllPartitionsWithPagingPredicate(this.name, (PagingPredicate)predicate, IterationType.VALUE);
        }
        QueryResult result = queryEngine.invokeQueryAllPartitions(this.name, predicate, IterationType.VALUE);
        return new QueryResultCollection(this.getNodeEngine().getSerializationService(), IterationType.VALUE, false, false, result);
    }

    @Override
    public Set<K> localKeySet() {
        return this.localKeySet(TruePredicate.INSTANCE);
    }

    @Override
    public Set<K> localKeySet(Predicate predicate) {
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        MapQueryEngine queryEngine = this.getMapQueryEngine();
        if (predicate instanceof PagingPredicate) {
            return queryEngine.queryLocalPartitionsWithPagingPredicate(this.name, (PagingPredicate)predicate, IterationType.KEY);
        }
        QueryResult result = queryEngine.invokeQueryLocalPartitions(this.name, predicate, IterationType.KEY);
        return new QueryResultCollection(this.getNodeEngine().getSerializationService(), IterationType.KEY, false, true, result);
    }

    @Override
    public Object executeOnKey(K key, EntryProcessor entryProcessor) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Data result = this.executeOnKeyInternal(this.toData(key, this.partitionStrategy), entryProcessor);
        return this.toObject(result);
    }

    @Override
    public Map<K, Object> executeOnKeys(Set<K> keys, EntryProcessor entryProcessor) {
        if (keys == null || keys.contains(null)) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet<Data> dataKeys = new HashSet<Data>(keys.size());
        for (K key : keys) {
            dataKeys.add(this.toData(key, this.partitionStrategy));
        }
        return this.executeOnKeysInternal(dataKeys, entryProcessor);
    }

    @Override
    public void submitToKey(K key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Data keyData = this.toData(key, this.partitionStrategy);
        this.executeOnKeyInternal(keyData, entryProcessor, callback);
    }

    @Override
    public ICompletableFuture submitToKey(K key, EntryProcessor entryProcessor) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        MapService service = (MapService)this.getService();
        Data keyData = this.toData(key, this.partitionStrategy);
        ICompletableFuture f = this.executeOnKeyInternal(keyData, entryProcessor, (ExecutionCallback)null);
        return new DelegatingFuture(f, service.getMapServiceContext().getNodeEngine().getSerializationService());
    }

    @Override
    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor) {
        return this.executeOnEntries(entryProcessor, TruePredicate.INSTANCE);
    }

    @Override
    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor, Predicate predicate) {
        ArrayList result = new ArrayList();
        this.executeOnEntriesInternal(entryProcessor, predicate, (List)result);
        if (result.isEmpty()) {
            return Collections.emptyMap();
        }
        Map resultingMap = MapUtil.createHashMap(result.size() / 2);
        int i = 0;
        while (i < result.size()) {
            Data key = (Data)result.get(i++);
            Data value = (Data)result.get(i++);
            resultingMap.put(this.toObject(key), this.toObject(value));
        }
        return resultingMap;
    }

    @Override
    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation) {
        HazelcastInstance hazelcastInstance = this.getNodeEngine().getHazelcastInstance();
        JobTracker jobTracker = hazelcastInstance.getJobTracker("hz::aggregation-map-" + this.getName());
        return this.aggregate(supplier, aggregation, jobTracker);
    }

    @Override
    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
        try {
            Preconditions.isNotNull(jobTracker, "jobTracker");
            KeyValueSource keyValueSource = KeyValueSource.fromMap(this);
            Job job = jobTracker.newJob(keyValueSource);
            Mapper mapper = aggregation.getMapper(supplier);
            CombinerFactory combinerFactory = aggregation.getCombinerFactory();
            ReducerFactory reducerFactory = aggregation.getReducerFactory();
            Collator<Map.Entry, Result> collator = aggregation.getCollator();
            MappingJob mappingJob = job.mapper(mapper);
            ReducingSubmittableJob reducingJob = combinerFactory == null ? mappingJob.reducer(reducerFactory) : mappingJob.combiner(combinerFactory).reducer(reducerFactory);
            JobCompletableFuture<Result> future = reducingJob.submit(collator);
            return (Result)future.get();
        }
        catch (Exception e) {
            throw new HazelcastException(e);
        }
    }

    protected Object invoke(Operation operation, int partitionId) throws Throwable {
        NodeEngine nodeEngine = this.getNodeEngine();
        InternalCompletableFuture f = nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
        Object response = f.get();
        Object returnObj = this.toObject(response);
        if (returnObj instanceof Throwable) {
            throw (Throwable)returnObj;
        }
        return returnObj;
    }

    @Override
    public String toString() {
        return "IMap{name='" + this.name + '\'' + '}';
    }
}

