/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeState;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.MemberSocketInterceptor;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.tcp.ReadHandler;
import com.hazelcast.nio.tcp.SocketChannelWrapperFactory;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.WriteHandler;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.packetdispatcher.PacketDispatcher;
import com.hazelcast.spi.properties.GroupProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@PrivateApi
public class NodeIOService
implements IOService {
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final PacketDispatcher packetDispatcher;

    public NodeIOService(Node node, NodeEngineImpl nodeEngine) {
        this.node = node;
        this.nodeEngine = nodeEngine;
        this.packetDispatcher = nodeEngine.getPacketDispatcher();
    }

    @Override
    public boolean isActive() {
        return this.node.getState() != NodeState.SHUT_DOWN;
    }

    @Override
    public ILogger getLogger(String name) {
        return this.node.getLogger(name);
    }

    @Override
    public void onOutOfMemory(OutOfMemoryError oom) {
        OutOfMemoryErrorDispatcher.onOutOfMemory(oom);
    }

    @Override
    public Address getThisAddress() {
        return this.node.getThisAddress();
    }

    @Override
    public void onFatalError(Exception e) {
        HazelcastThreadGroup threadGroup = this.node.getHazelcastThreadGroup();
        Thread thread = new Thread(threadGroup.getInternalThreadGroup(), threadGroup.getThreadNamePrefix("io.error.shutdown")){

            @Override
            public void run() {
                NodeIOService.this.node.shutdown(false);
            }
        };
        thread.start();
    }

    @Override
    public SocketInterceptorConfig getSocketInterceptorConfig() {
        return this.node.getConfig().getNetworkConfig().getSocketInterceptorConfig();
    }

    @Override
    public SymmetricEncryptionConfig getSymmetricEncryptionConfig() {
        return this.node.getConfig().getNetworkConfig().getSymmetricEncryptionConfig();
    }

    @Override
    public SSLConfig getSSLConfig() {
        return this.node.getConfig().getNetworkConfig().getSSLConfig();
    }

    @Override
    public void handleClientMessage(ClientMessage cm, Connection connection) {
        this.node.clientEngine.handleClientMessage(cm, connection);
    }

    @Override
    public TextCommandService getTextCommandService() {
        return this.node.getTextCommandService();
    }

    @Override
    public boolean isMemcacheEnabled() {
        return this.node.getProperties().getBoolean(GroupProperty.MEMCACHE_ENABLED);
    }

    @Override
    public boolean isRestEnabled() {
        return this.node.getProperties().getBoolean(GroupProperty.REST_ENABLED);
    }

    @Override
    public String getThreadPrefix() {
        HazelcastThreadGroup threadGroup = this.node.getHazelcastThreadGroup();
        return threadGroup.getThreadPoolNamePrefix("IO");
    }

    @Override
    public ThreadGroup getThreadGroup() {
        HazelcastThreadGroup threadGroup = this.node.getHazelcastThreadGroup();
        return threadGroup.getInternalThreadGroup();
    }

    @Override
    public void removeEndpoint(final Address endPoint) {
        this.nodeEngine.getExecutionService().execute("hz:io", new Runnable(){

            @Override
            public void run() {
                ((NodeIOService)NodeIOService.this).node.clusterService.removeAddress(endPoint, null);
            }
        });
    }

    @Override
    public void onDisconnect(Address endpoint) {
        if (this.node.clusterService.getMember(endpoint) != null) {
            this.nodeEngine.getExecutionService().execute("hz:io", new ReconnectionTask(endpoint));
        }
    }

    @Override
    public void onSuccessfulConnection(Address address) {
        if (!this.node.joined()) {
            this.node.getJoiner().unblacklist(address);
        }
    }

    @Override
    public void onFailedConnection(Address address) {
        if (!this.node.joined()) {
            this.node.getJoiner().blacklist(address, false);
        } else if (this.node.clusterService.getMember(address) != null) {
            this.nodeEngine.getExecutionService().schedule("hz:io", new ReconnectionTask(address), this.getConnectionMonitorInterval(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void shouldConnectTo(Address address) {
        if (this.node.getThisAddress().equals(address)) {
            throw new RuntimeException("Connecting to self! " + address);
        }
    }

    @Override
    public boolean isSocketBind() {
        return this.node.getProperties().getBoolean(GroupProperty.SOCKET_CLIENT_BIND);
    }

    @Override
    public boolean isSocketBindAny() {
        return this.node.getProperties().getBoolean(GroupProperty.SOCKET_CLIENT_BIND_ANY);
    }

    @Override
    public int getSocketReceiveBufferSize() {
        return this.node.getProperties().getInteger(GroupProperty.SOCKET_RECEIVE_BUFFER_SIZE);
    }

    @Override
    public int getSocketSendBufferSize() {
        return this.node.getProperties().getInteger(GroupProperty.SOCKET_SEND_BUFFER_SIZE);
    }

    @Override
    public boolean isSocketBufferDirect() {
        return this.node.getProperties().getBoolean(GroupProperty.SOCKET_BUFFER_DIRECT);
    }

    @Override
    public int getSocketClientReceiveBufferSize() {
        int clientSendBuffer = this.node.getProperties().getInteger(GroupProperty.SOCKET_CLIENT_RECEIVE_BUFFER_SIZE);
        return clientSendBuffer != -1 ? clientSendBuffer : this.getSocketReceiveBufferSize();
    }

    @Override
    public int getSocketClientSendBufferSize() {
        int clientReceiveBuffer = this.node.getProperties().getInteger(GroupProperty.SOCKET_CLIENT_SEND_BUFFER_SIZE);
        return clientReceiveBuffer != -1 ? clientReceiveBuffer : this.getSocketReceiveBufferSize();
    }

    @Override
    public int getSocketLingerSeconds() {
        return this.node.getProperties().getSeconds(GroupProperty.SOCKET_LINGER_SECONDS);
    }

    @Override
    public int getSocketConnectTimeoutSeconds() {
        return this.node.getProperties().getSeconds(GroupProperty.SOCKET_CONNECT_TIMEOUT_SECONDS);
    }

    @Override
    public boolean getSocketKeepAlive() {
        return this.node.getProperties().getBoolean(GroupProperty.SOCKET_KEEP_ALIVE);
    }

    @Override
    public boolean getSocketNoDelay() {
        return this.node.getProperties().getBoolean(GroupProperty.SOCKET_NO_DELAY);
    }

    @Override
    public int getInputSelectorThreadCount() {
        return this.node.getProperties().getInteger(GroupProperty.IO_INPUT_THREAD_COUNT);
    }

    @Override
    public int getOutputSelectorThreadCount() {
        return this.node.getProperties().getInteger(GroupProperty.IO_OUTPUT_THREAD_COUNT);
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public long getConnectionMonitorInterval() {
        return this.node.getProperties().getMillis(GroupProperty.CONNECTION_MONITOR_INTERVAL);
    }

    @Override
    public int getConnectionMonitorMaxFaults() {
        return this.node.getProperties().getInteger(GroupProperty.CONNECTION_MONITOR_MAX_FAULTS);
    }

    @Override
    public int getBalancerIntervalSeconds() {
        return this.node.getProperties().getSeconds(GroupProperty.IO_BALANCER_INTERVAL_SECONDS);
    }

    @Override
    public void executeAsync(Runnable runnable) {
        this.nodeEngine.getExecutionService().execute("hz:io", runnable);
    }

    @Override
    public EventService getEventService() {
        return this.nodeEngine.getEventService();
    }

    @Override
    public Data toData(Object obj) {
        return this.nodeEngine.toData(obj);
    }

    @Override
    public Object toObject(Data data) {
        return this.nodeEngine.toObject(data);
    }

    @Override
    public InternalSerializationService getSerializationService() {
        return this.node.getSerializationService();
    }

    @Override
    public SocketChannelWrapperFactory getSocketChannelWrapperFactory() {
        return this.node.getNodeExtension().getSocketChannelWrapperFactory();
    }

    @Override
    public MemberSocketInterceptor getMemberSocketInterceptor() {
        return this.node.getNodeExtension().getMemberSocketInterceptor();
    }

    @Override
    public ReadHandler createReadHandler(TcpIpConnection connection) {
        return this.node.getNodeExtension().createReadHandler(connection, this);
    }

    @Override
    public WriteHandler createWriteHandler(TcpIpConnection connection) {
        return this.node.getNodeExtension().createWriteHandler(connection, this);
    }

    @Override
    public Collection<Integer> getOutboundPorts() {
        NetworkConfig networkConfig = this.node.getConfig().getNetworkConfig();
        Collection<String> portDefinitions = this.getPortDefinitions(networkConfig);
        Set<Integer> ports = this.getPorts(networkConfig);
        if (portDefinitions.isEmpty() && ports.isEmpty()) {
            return Collections.emptySet();
        }
        if (portDefinitions.contains("*") || portDefinitions.contains("0")) {
            return Collections.emptySet();
        }
        this.transformPortDefinitionsToPorts(portDefinitions, ports);
        if (ports.contains(0)) {
            return Collections.emptySet();
        }
        return ports;
    }

    private void transformPortDefinitionsToPorts(Collection<String> portDefinitions, Set<Integer> ports) {
        for (String portDef : portDefinitions) {
            String[] portDefs;
            for (String def : portDefs = portDef.split("[,; ]")) {
                if ((def = def.trim()).isEmpty()) continue;
                int dashPos = def.indexOf(45);
                if (dashPos > 0) {
                    int start = Integer.parseInt(def.substring(0, dashPos));
                    int end = Integer.parseInt(def.substring(dashPos + 1));
                    for (int port = start; port <= end; ++port) {
                        ports.add(port);
                    }
                    continue;
                }
                ports.add(Integer.parseInt(def));
            }
        }
    }

    private Set<Integer> getPorts(NetworkConfig networkConfig) {
        return networkConfig.getOutboundPorts() == null ? new HashSet<Integer>() : new HashSet<Integer>(networkConfig.getOutboundPorts());
    }

    private Collection<String> getPortDefinitions(NetworkConfig networkConfig) {
        return networkConfig.getOutboundPortDefinitions() == null ? Collections.emptySet() : networkConfig.getOutboundPortDefinitions();
    }

    private class ReconnectionTask
    implements Runnable {
        private final Address endpoint;

        ReconnectionTask(Address endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public void run() {
            ClusterServiceImpl clusterService = ((NodeIOService)NodeIOService.this).node.clusterService;
            if (clusterService.getMember(this.endpoint) != null) {
                ((NodeIOService)NodeIOService.this).node.connectionManager.getOrConnect(this.endpoint);
            }
        }
    }
}

