/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.hazelcast.nio.tcp.nonblocking.SelectorMode;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class SocketAcceptorThread
extends Thread {
    private static final long SHUTDOWN_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private static final long SELECT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    private static final int SELECT_IDLE_COUNT_THRESHOLD = 10;
    private final ServerSocketChannel serverSocketChannel;
    private final TcpIpConnectionManager connectionManager;
    private final ILogger logger;
    private final IOService ioService;
    @Probe
    private final SwCounter eventCount = SwCounter.newSwCounter();
    @Probe
    private final SwCounter exceptionCount = SwCounter.newSwCounter();
    @Probe
    private final SwCounter selectorRecreateCount = SwCounter.newSwCounter();
    private volatile long lastSelectTimeMs;
    private final boolean selectorWorkaround = SelectorMode.getConfiguredValue() == SelectorMode.SELECT_WITH_FIX;
    private Selector selector;
    private SelectionKey selectionKey;

    public SocketAcceptorThread(ThreadGroup threadGroup, String name, ServerSocketChannel serverSocketChannel, TcpIpConnectionManager connectionManager) {
        super(threadGroup, name);
        this.serverSocketChannel = serverSocketChannel;
        this.connectionManager = connectionManager;
        this.ioService = connectionManager.getIoService();
        this.logger = this.ioService.getLogger(this.getClass().getName());
    }

    @Probe
    private long idleTimeMs() {
        return Math.max(System.currentTimeMillis() - this.lastSelectTimeMs, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Starting SocketAcceptor on " + this.serverSocketChannel);
        }
        try {
            this.selector = Selector.open();
            this.serverSocketChannel.configureBlocking(false);
            this.selectionKey = this.serverSocketChannel.register(this.selector, 16);
            if (this.selectorWorkaround) {
                this.acceptLoopWithSelectorFix();
            } else {
                this.acceptLoop();
            }
        }
        catch (OutOfMemoryError e) {
            OutOfMemoryErrorDispatcher.onOutOfMemory(e);
        }
        catch (IOException e) {
            this.logger.severe(e.getClass().getName() + ": " + e.getMessage(), e);
        }
        finally {
            this.closeSelector();
        }
    }

    private void acceptLoop() throws IOException {
        while (this.connectionManager.isLive()) {
            int keyCount = this.selector.select();
            if (this.isInterrupted()) break;
            if (keyCount == 0) continue;
            Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
            this.handleSelectionKeys(it);
        }
    }

    private void acceptLoopWithSelectorFix() throws IOException {
        int idleCount = 0;
        while (this.connectionManager.isLive()) {
            long before = System.currentTimeMillis();
            int keyCount = this.selector.select(SELECT_TIMEOUT_MILLIS);
            if (this.isInterrupted()) break;
            if (keyCount == 0) {
                long selectTimeTaken = System.currentTimeMillis() - before;
                idleCount = selectTimeTaken < SELECT_TIMEOUT_MILLIS ? idleCount + 1 : 0;
                if (idleCount <= 10) continue;
                this.rebuildSelector();
                idleCount = 0;
                continue;
            }
            idleCount = 0;
            Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
            this.handleSelectionKeys(it);
        }
    }

    private void rebuildSelector() throws IOException {
        Selector newSelector;
        this.selectorRecreateCount.inc();
        this.selectionKey.cancel();
        this.closeSelector();
        this.selector = newSelector = Selector.open();
        this.selectionKey = this.serverSocketChannel.register(newSelector, 16);
    }

    private void handleSelectionKeys(Iterator<SelectionKey> it) {
        this.lastSelectTimeMs = System.currentTimeMillis();
        while (it.hasNext()) {
            SelectionKey sk = it.next();
            it.remove();
            if (!sk.isValid() || !sk.isAcceptable()) continue;
            this.eventCount.inc();
            this.acceptSocket();
        }
    }

    private void closeSelector() {
        if (this.selector == null) {
            return;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Closing selector " + Thread.currentThread().getName());
        }
        try {
            this.selector.close();
        }
        catch (Exception e) {
            this.logger.finest("Exception while closing selector", e);
        }
    }

    private void acceptSocket() {
        SocketChannel socketChannel;
        if (!this.connectionManager.isLive()) {
            return;
        }
        SocketChannelWrapper socketChannelWrapper = null;
        try {
            socketChannel = this.serverSocketChannel.accept();
            if (socketChannel != null) {
                socketChannelWrapper = this.connectionManager.wrapSocketChannel(socketChannel, false);
            }
        }
        catch (Exception e) {
            this.exceptionCount.inc();
            if (e instanceof ClosedChannelException && !this.connectionManager.isLive()) {
                this.logger.finest("Terminating socket acceptor thread...", e);
            }
            this.logger.warning("Unexpected error while accepting connection! " + e.getClass().getName() + ": " + e.getMessage());
            try {
                this.serverSocketChannel.close();
            }
            catch (Exception ex) {
                this.logger.finest("Closing server socket failed", ex);
            }
            this.ioService.onFatalError(e);
        }
        if (socketChannelWrapper != null) {
            socketChannel = socketChannelWrapper;
            this.logger.info("Accepting socket connection from " + socketChannel.socket().getRemoteSocketAddress());
            if (this.connectionManager.isSocketInterceptorEnabled()) {
                this.configureAndAssignSocket((SocketChannelWrapper)((Object)socketChannel));
            } else {
                this.ioService.executeAsync(new Runnable((SocketChannelWrapper)((Object)socketChannel)){
                    final /* synthetic */ SocketChannelWrapper val$socketChannel;
                    {
                        this.val$socketChannel = socketChannelWrapper;
                    }

                    @Override
                    public void run() {
                        SocketAcceptorThread.this.configureAndAssignSocket(this.val$socketChannel);
                    }
                });
            }
        }
    }

    private void configureAndAssignSocket(SocketChannelWrapper socketChannel) {
        try {
            this.connectionManager.initSocket(socketChannel.socket());
            this.connectionManager.interceptSocket(socketChannel.socket(), true);
            socketChannel.configureBlocking(this.connectionManager.getIoThreadingModel().isBlocking());
            this.connectionManager.newConnection(socketChannel, null);
        }
        catch (Exception e) {
            this.exceptionCount.inc();
            this.logger.warning(e.getClass().getName() + ": " + e.getMessage(), e);
            IOUtil.closeResource(socketChannel);
        }
    }

    public void shutdown() {
        this.logger.finest("Shutting down SocketAcceptor thread.");
        this.interrupt();
        try {
            this.join(SHUTDOWN_TIMEOUT_MILLIS);
        }
        catch (InterruptedException e) {
            this.logger.finest(e);
        }
    }
}

