/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.IndexAwarePredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.VisitablePredicate;
import com.hazelcast.query.impl.AndResultSet;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.QueryContext;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.predicates.NegatablePredicate;
import com.hazelcast.query.impl.predicates.NotPredicate;
import com.hazelcast.query.impl.predicates.OrPredicate;
import com.hazelcast.query.impl.predicates.Visitor;
import com.hazelcast.query.impl.predicates.VisitorUtils;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public final class AndPredicate
implements IndexAwarePredicate,
IdentifiedDataSerializable,
VisitablePredicate,
NegatablePredicate {
    protected Predicate[] predicates;

    public AndPredicate() {
    }

    public AndPredicate(Predicate ... predicates) {
        this.predicates = predicates;
    }

    @Override
    public Predicate accept(Visitor visitor, Indexes indexes) {
        Predicate[] result = VisitorUtils.acceptVisitor(this.predicates, visitor, indexes);
        if (result != this.predicates) {
            AndPredicate newPredicate = new AndPredicate(result);
            return visitor.visit(newPredicate, indexes);
        }
        return visitor.visit(this, indexes);
    }

    public Set<QueryableEntry> filter(QueryContext queryContext) {
        Set smallestIndexedResult = null;
        LinkedList<Set<QueryableEntry>> otherIndexedResults = new LinkedList<Set<QueryableEntry>>();
        LinkedList<Predicate> lsNoIndexPredicates = null;
        for (Predicate predicate : this.predicates) {
            IndexAwarePredicate iap;
            boolean indexed = false;
            if (predicate instanceof IndexAwarePredicate && (iap = (IndexAwarePredicate)predicate).isIndexed(queryContext)) {
                indexed = true;
                Set s = iap.filter(queryContext);
                if (smallestIndexedResult == null) {
                    smallestIndexedResult = s;
                } else if (s.size() < smallestIndexedResult.size()) {
                    otherIndexedResults.add(smallestIndexedResult);
                    smallestIndexedResult = s;
                } else {
                    otherIndexedResults.add(s);
                }
            }
            if (indexed) continue;
            if (lsNoIndexPredicates == null) {
                lsNoIndexPredicates = new LinkedList<Predicate>();
            }
            lsNoIndexPredicates.add(predicate);
        }
        if (smallestIndexedResult == null) {
            return null;
        }
        return new AndResultSet(smallestIndexedResult, otherIndexedResults, lsNoIndexPredicates);
    }

    @Override
    public boolean isIndexed(QueryContext queryContext) {
        for (Predicate predicate : this.predicates) {
            IndexAwarePredicate iap;
            if (!(predicate instanceof IndexAwarePredicate) || !(iap = (IndexAwarePredicate)predicate).isIndexed(queryContext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean apply(Map.Entry mapEntry) {
        for (Predicate predicate : this.predicates) {
            if (predicate.apply(mapEntry)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        int size = this.predicates.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(" AND ");
            }
            sb.append(this.predicates[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.predicates.length);
        for (Predicate predicate : this.predicates) {
            out.writeObject(predicate);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.predicates = new Predicate[size];
        for (int i = 0; i < size; ++i) {
            this.predicates[i] = (Predicate)in.readObject();
        }
    }

    @Override
    public Predicate negate() {
        int size = this.predicates.length;
        Predicate[] inners = new Predicate[size];
        for (int i = 0; i < size; ++i) {
            Predicate original = this.predicates[i];
            Predicate negated = original instanceof NegatablePredicate ? ((NegatablePredicate)((Object)original)).negate() : new NotPredicate(original);
            inners[i] = negated;
        }
        OrPredicate orPredicate = new OrPredicate(inners);
        return orPredicate;
    }

    @Override
    public int getFactoryId() {
        return -32;
    }

    @Override
    public int getId() {
        return 1;
    }
}

