/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.exception;

import com.hazelcast.core.Member;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.util.StringUtil;

public class TargetDisconnectedException
extends RetryableHazelcastException {
    public TargetDisconnectedException() {
    }

    public TargetDisconnectedException(Address address) {
        super("Target[" + address + "] disconnected.");
    }

    public TargetDisconnectedException(String message) {
        super(message);
    }

    public TargetDisconnectedException(String message, Throwable cause) {
        super(message, cause);
    }

    public static Exception newTargetDisconnectedExceptionCausedByHeartBeat(Address memberAddress, long lastHeartbeatMillis, Throwable cause) {
        return new TargetDisconnectedException(String.format("Disconnecting from member %s due to heartbeat problems. Current time: %s. Last heartbeat: %s", memberAddress, StringUtil.timeToString(System.currentTimeMillis()), lastHeartbeatMillis == 0L ? "never" : StringUtil.timeToString(lastHeartbeatMillis)), cause);
    }

    public static Exception newTargetDisconnectedExceptionCausedByMemberLeftEvent(Member member) {
        return new TargetDisconnectedException(String.format("Closing connection to member %s. The client has closed the connection to this member, after receiving a member left event from the cluster.", member.getAddress()));
    }
}

