/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationexecutor.impl;

import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.instance.NodeExtension;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.metrics.MetricsProvider;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Packet;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.operationexecutor.OperationRunner;
import com.hazelcast.spi.impl.operationexecutor.impl.OperationQueue;
import com.hazelcast.util.executor.HazelcastManagedThread;
import java.util.concurrent.TimeUnit;

public abstract class OperationThread
extends HazelcastManagedThread
implements MetricsProvider {
    final int threadId;
    final OperationQueue queue;
    OperationRunner currentRunner;
    @Probe
    private final SwCounter completedTotalCount = SwCounter.newSwCounter();
    @Probe
    private final SwCounter completedPacketCount = SwCounter.newSwCounter();
    @Probe
    private final SwCounter completedOperationCount = SwCounter.newSwCounter();
    @Probe
    private final SwCounter completedPartitionSpecificRunnableCount = SwCounter.newSwCounter();
    @Probe
    private final SwCounter completedRunnableCount = SwCounter.newSwCounter();
    @Probe
    private final SwCounter errorCount = SwCounter.newSwCounter();
    private final boolean priority;
    private final NodeExtension nodeExtension;
    private final ILogger logger;
    private volatile boolean shutdown;

    public OperationThread(String name, int threadId, OperationQueue queue, ILogger logger, HazelcastThreadGroup threadGroup, NodeExtension nodeExtension, boolean priority) {
        super(threadGroup.getInternalThreadGroup(), name);
        this.setContextClassLoader(threadGroup.getClassLoader());
        this.queue = queue;
        this.threadId = threadId;
        this.logger = logger;
        this.nodeExtension = nodeExtension;
        this.priority = priority;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public abstract OperationRunner getOperationRunner(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.nodeExtension.onThreadStart(this);
        try {
            while (!this.shutdown) {
                Object task;
                try {
                    task = this.queue.take(this.priority);
                }
                catch (InterruptedException e) {
                    continue;
                }
                this.process(task);
            }
        }
        catch (Throwable t) {
            OutOfMemoryErrorDispatcher.inspectOutputMemoryError(t);
            this.logger.severe(t);
        }
        finally {
            this.nodeExtension.onThreadStop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Object task) {
        try {
            if (task.getClass() == Packet.class) {
                Packet packet = (Packet)task;
                this.currentRunner = this.getOperationRunner(packet.getPartitionId());
                this.currentRunner.run(packet);
                this.completedPacketCount.inc();
            } else if (task instanceof Operation) {
                Operation operation = (Operation)task;
                this.currentRunner = this.getOperationRunner(operation.getPartitionId());
                this.currentRunner.run(operation);
                this.completedOperationCount.inc();
            } else if (task instanceof PartitionSpecificRunnable) {
                PartitionSpecificRunnable runnable = (PartitionSpecificRunnable)task;
                this.currentRunner = this.getOperationRunner(runnable.getPartitionId());
                this.currentRunner.run(runnable);
                this.completedPartitionSpecificRunnableCount.inc();
            } else if (task instanceof Runnable) {
                Runnable runnable = (Runnable)task;
                runnable.run();
                this.completedRunnableCount.inc();
            } else {
                throw new IllegalStateException("Unhandled task type for task:" + task);
            }
            this.completedTotalCount.inc();
        }
        catch (Throwable t) {
            this.errorCount.inc();
            OutOfMemoryErrorDispatcher.inspectOutputMemoryError(t);
            this.logger.severe("Failed to process packet: " + task + " on " + this.getName(), t);
        }
        finally {
            this.currentRunner = null;
        }
    }

    @Override
    public void provideMetrics(MetricsRegistry metricsRegistry) {
        metricsRegistry.scanAndRegister(this, "operation." + this.getName());
    }

    public final void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }

    public final void awaitTermination(int timeout, TimeUnit unit) throws InterruptedException {
        long timeoutMs = unit.toMillis(timeout);
        this.join(timeoutMs);
    }
}

