/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.core.HazelcastOverloadException;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.impl.Invocation;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public abstract class CallIdSequence {
    abstract long getLastCallId();

    public abstract int getMaxConcurrentInvocations();

    public abstract long next(Invocation var1);

    public abstract void complete(Invocation var1);

    boolean skipRegistration(Invocation invocation) {
        if (invocation.remote) {
            return false;
        }
        return !(invocation.op instanceof BackupAwareOperation);
    }

    static final class CallIdSequenceWithBackpressure
    extends CallIdSequence {
        static final int MAX_DELAY_MS = 500;
        private static final int INDEX_HEAD = 7;
        private static final int INDEX_TAIL = 15;
        private final AtomicLongArray longs = new AtomicLongArray(24);
        private final int maxConcurrentInvocations;
        private final long backoffTimeoutMs;

        CallIdSequenceWithBackpressure(int maxConcurrentInvocations, long backoffTimeoutMs) {
            this.maxConcurrentInvocations = maxConcurrentInvocations;
            this.backoffTimeoutMs = backoffTimeoutMs;
        }

        @Override
        public long getLastCallId() {
            return this.longs.get(7);
        }

        long getTail() {
            return this.longs.get(15);
        }

        @Override
        public int getMaxConcurrentInvocations() {
            return this.maxConcurrentInvocations;
        }

        @Override
        public long next(Invocation invocation) {
            assert (invocation.op.getCallId() == 0L) : "callId should be null:" + invocation;
            if (!invocation.op.isUrgent() && !this.hasSpace()) {
                this.waitForSpace(invocation);
            }
            long callId = this.next();
            if (this.skipRegistration(invocation)) {
                return Long.MAX_VALUE;
            }
            return callId;
        }

        private long next() {
            return this.longs.incrementAndGet(7);
        }

        private boolean hasSpace() {
            return this.longs.get(7) - this.longs.get(15) < (long)this.maxConcurrentInvocations;
        }

        private void waitForSpace(Invocation invocation) {
            long remainingTimeoutMs = this.backoffTimeoutMs;
            boolean restoreInterrupt = false;
            try {
                long delayMs = 1L;
                while (true) {
                    long startMs = System.currentTimeMillis();
                    restoreInterrupt = CallIdSequenceWithBackpressure.sleep(delayMs);
                    long durationMs = System.currentTimeMillis() - startMs;
                    remainingTimeoutMs -= durationMs;
                    if (this.hasSpace()) {
                        return;
                    }
                    if (remainingTimeoutMs <= 0L) {
                        throw new HazelcastOverloadException("Failed to get a callId for invocation: " + invocation);
                    }
                    delayMs = CallIdSequenceWithBackpressure.nextDelay(remainingTimeoutMs, delayMs);
                    remainingTimeoutMs -= delayMs;
                }
            }
            finally {
                if (restoreInterrupt) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        static boolean sleep(long delayMs) {
            try {
                Thread.sleep(delayMs);
                return false;
            }
            catch (InterruptedException e) {
                return true;
            }
        }

        static long nextDelay(long remainingTimeoutMs, long delayMs) {
            if ((delayMs *= 2L) > 500L) {
                delayMs = 500L;
            }
            if (delayMs > remainingTimeoutMs) {
                delayMs = remainingTimeoutMs;
            }
            return delayMs;
        }

        @Override
        public void complete(Invocation invocation) {
            if (invocation.op.getCallId() == 0L) {
                return;
            }
            long newTail = this.longs.incrementAndGet(15);
            assert (newTail <= this.longs.get(7));
        }
    }

    static final class CallIdSequenceWithoutBackpressure
    extends CallIdSequence {
        private static final AtomicLongFieldUpdater<CallIdSequenceWithoutBackpressure> HEAD = AtomicLongFieldUpdater.newUpdater(CallIdSequenceWithoutBackpressure.class, "head");
        private volatile long head;

        CallIdSequenceWithoutBackpressure() {
        }

        @Override
        public long getLastCallId() {
            return this.head;
        }

        @Override
        public int getMaxConcurrentInvocations() {
            return Integer.MAX_VALUE;
        }

        @Override
        public long next(Invocation invocation) {
            assert (invocation.op.getCallId() == 0L) : "callId should be null:" + invocation;
            if (this.skipRegistration(invocation)) {
                return Long.MAX_VALUE;
            }
            return HEAD.incrementAndGet(this);
        }

        @Override
        public void complete(Invocation invocation) {
        }
    }
}

