/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.waitnotifyservice.impl;

import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.BlockingOperation;
import com.hazelcast.spi.LiveOperations;
import com.hazelcast.spi.LiveOperationsTracker;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationResponseHandler;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.spi.exception.PartitionMigratingException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.waitnotifyservice.WaitNotifyService;
import com.hazelcast.spi.impl.waitnotifyservice.impl.WaitingOperation;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.executor.SingleExecutorThreadFactory;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class WaitNotifyServiceImpl
implements WaitNotifyService,
LiveOperationsTracker {
    private static final long FIRST_WAIT_TIME = 1000L;
    private static final long TIMEOUT_UPPER_BOUND = 1500L;
    private final ConcurrentMap<WaitNotifyKey, Queue<WaitingOperation>> mapWaitingOps = new ConcurrentHashMap<WaitNotifyKey, Queue<WaitingOperation>>(100);
    private final DelayQueue delayQueue = new DelayQueue();
    private final ExecutorService expirationService;
    private final Future expirationTask;
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final ConstructorFunction<WaitNotifyKey, Queue<WaitingOperation>> waitQueueConstructor = new ConstructorFunction<WaitNotifyKey, Queue<WaitingOperation>>(){

        @Override
        public Queue<WaitingOperation> createNew(WaitNotifyKey key) {
            return new ConcurrentLinkedQueue<WaitingOperation>();
        }
    };

    public WaitNotifyServiceImpl(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        Node node = nodeEngine.getNode();
        this.logger = node.getLogger(WaitNotifyService.class.getName());
        HazelcastThreadGroup threadGroup = node.getHazelcastThreadGroup();
        this.expirationService = Executors.newSingleThreadExecutor(new SingleExecutorThreadFactory(threadGroup.getInternalThreadGroup(), threadGroup.getClassLoader(), threadGroup.getThreadNamePrefix("wait-notify")));
        this.expirationTask = this.expirationService.submit(new ExpirationTask());
    }

    @Override
    public void populate(LiveOperations liveOperations) {
        for (Queue queue : this.mapWaitingOps.values()) {
            for (WaitingOperation op : queue) {
                liveOperations.add(op.getCallerAddress(), op.getCallId());
            }
        }
    }

    private void invalidate(WaitingOperation waitingOp) throws Exception {
        this.nodeEngine.getOperationService().executeOperation(waitingOp);
    }

    @Override
    public void await(BlockingOperation blockingOperation) {
        WaitNotifyKey key = blockingOperation.getWaitKey();
        Queue<WaitingOperation> q = ConcurrencyUtil.getOrPutIfAbsent(this.mapWaitingOps, key, this.waitQueueConstructor);
        long timeout = blockingOperation.getWaitTimeout();
        WaitingOperation waitingOp = new WaitingOperation(q, blockingOperation);
        waitingOp.setNodeEngine(this.nodeEngine);
        q.offer(waitingOp);
        if (timeout > -1L && timeout < 1500L) {
            this.delayQueue.offer(waitingOp);
        }
    }

    @Override
    public void notify(Notifier notifier) {
        WaitNotifyKey key = notifier.getNotifiedKey();
        Queue q = (Queue)this.mapWaitingOps.get(key);
        if (q == null) {
            return;
        }
        WaitingOperation waitingOp = (WaitingOperation)q.peek();
        while (waitingOp != null) {
            Operation op = waitingOp.getOperation();
            if (notifier == op) {
                throw new IllegalStateException("Found cyclic wait-notify! -> " + notifier);
            }
            if (waitingOp.isValid()) {
                if (waitingOp.isExpired()) {
                    waitingOp.onExpire();
                } else {
                    if (waitingOp.shouldWait()) {
                        return;
                    }
                    this.nodeEngine.getOperationService().runOperationOnCallingThread(op);
                }
                waitingOp.setValid(false);
            }
            q.poll();
            waitingOp = (WaitingOperation)q.peek();
            if (waitingOp != null) continue;
            this.mapWaitingOps.remove(key);
        }
    }

    public int getAwaitQueueCount() {
        return this.mapWaitingOps.size();
    }

    public int getTotalWaitingOperationCount() {
        int count = 0;
        for (Queue queue : this.mapWaitingOps.values()) {
            count += queue.size();
        }
        return count;
    }

    public void onMemberLeft(MemberImpl leftMember) {
        this.invalidateWaitingOps(leftMember.getUuid());
    }

    public void onClientDisconnected(String clientUuid) {
        this.invalidateWaitingOps(clientUuid);
    }

    private void invalidateWaitingOps(String callerUuid) {
        for (Queue q : this.mapWaitingOps.values()) {
            for (WaitingOperation waitingOp : q) {
                Operation op;
                if (!waitingOp.isValid() || !callerUuid.equals((op = waitingOp.getOperation()).getCallerUuid())) continue;
                waitingOp.setValid(false);
            }
        }
    }

    public void onPartitionMigrate(Address thisAddress, MigrationInfo migrationInfo) {
        if (!thisAddress.equals(migrationInfo.getSource())) {
            return;
        }
        int partitionId = migrationInfo.getPartitionId();
        for (Queue q : this.mapWaitingOps.values()) {
            Iterator it = q.iterator();
            while (it.hasNext()) {
                Operation op;
                if (Thread.interrupted()) {
                    return;
                }
                WaitingOperation waitingOp = (WaitingOperation)it.next();
                if (!waitingOp.isValid() || partitionId != (op = waitingOp.getOperation()).getPartitionId()) continue;
                waitingOp.setValid(false);
                PartitionMigratingException pme = new PartitionMigratingException(thisAddress, partitionId, op.getClass().getName(), op.getServiceName());
                OperationResponseHandler responseHandler = op.getOperationResponseHandler();
                responseHandler.sendResponse(op, pme);
                it.remove();
            }
        }
    }

    @Override
    public void cancelWaitingOps(String serviceName, Object objectId, Throwable cause) {
        for (Queue q : this.mapWaitingOps.values()) {
            for (WaitingOperation waitingOp : q) {
                WaitNotifyKey wnk;
                if (!waitingOp.isValid() || !serviceName.equals((wnk = waitingOp.blockingOperation.getWaitKey()).getServiceName()) || !objectId.equals(wnk.getObjectName())) continue;
                waitingOp.cancel(cause);
            }
        }
    }

    public void reset() {
        this.delayQueue.clear();
        this.mapWaitingOps.clear();
    }

    public void shutdown() {
        this.logger.finest("Stopping tasks...");
        this.expirationTask.cancel(true);
        this.expirationService.shutdown();
        HazelcastInstanceNotActiveException response = new HazelcastInstanceNotActiveException();
        Address thisAddress = this.nodeEngine.getThisAddress();
        for (Queue q : this.mapWaitingOps.values()) {
            for (WaitingOperation waitingOp : q) {
                Operation op;
                if (!waitingOp.isValid() || !thisAddress.equals((op = waitingOp.getOperation()).getCallerAddress())) continue;
                try {
                    OperationResponseHandler responseHandler = op.getOperationResponseHandler();
                    responseHandler.sendResponse(op, response);
                }
                catch (Exception e) {
                    this.logger.finest("While sending HazelcastInstanceNotActiveException response...", e);
                }
            }
            q.clear();
        }
        this.mapWaitingOps.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WaitNotifyService{");
        sb.append("delayQueue=");
        sb.append(this.delayQueue.size());
        sb.append(" \n[");
        for (Queue scheduledOps : this.mapWaitingOps.values()) {
            sb.append("\t");
            sb.append(scheduledOps.size());
            sb.append(", ");
        }
        sb.append("]\n}");
        return sb.toString();
    }

    private class ExpirationTask
    implements Runnable {
        private ExpirationTask() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    if (!this.doRun()) continue;
                    return;
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Throwable t) {
                    WaitNotifyServiceImpl.this.logger.warning(t);
                    continue;
                }
                break;
            }
            return;
        }

        private boolean doRun() throws Exception {
            long waitTime = 1000L;
            while (waitTime > 0L) {
                long end;
                long begin = System.currentTimeMillis();
                WaitingOperation waitingOp = (WaitingOperation)WaitNotifyServiceImpl.this.delayQueue.poll(waitTime, TimeUnit.MILLISECONDS);
                if (waitingOp != null && waitingOp.isValid()) {
                    WaitNotifyServiceImpl.this.invalidate(waitingOp);
                }
                if ((waitTime -= (end = System.currentTimeMillis()) - begin) <= 1000L) continue;
                waitTime = 1000L;
            }
            for (Queue q : WaitNotifyServiceImpl.this.mapWaitingOps.values()) {
                for (WaitingOperation waitingOp : q) {
                    if (Thread.interrupted()) {
                        return true;
                    }
                    if (!waitingOp.isValid() || !waitingOp.needsInvalidation()) continue;
                    WaitNotifyServiceImpl.this.invalidate(waitingOp);
                }
            }
            return false;
        }
    }
}

