/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.nearcache.NearCacheProvider;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.AbstractNamedOperation;
import com.hazelcast.util.CollectionUtil;
import java.util.List;

public abstract class MapOperation
extends AbstractNamedOperation {
    protected transient MapService mapService;
    protected transient MapContainer mapContainer;
    protected transient MapServiceContext mapServiceContext;
    protected transient MapEventPublisher mapEventPublisher;
    protected transient RecordStore recordStore;
    protected transient boolean createRecordStoreOnDemand = true;

    public MapOperation() {
    }

    public MapOperation(String name) {
        this.name = name;
    }

    public void setMapService(MapService mapService) {
        this.mapService = mapService;
    }

    public void setMapContainer(MapContainer mapContainer) {
        this.mapContainer = mapContainer;
    }

    @Override
    public void beforeRun() throws Exception {
        super.beforeRun();
        this.mapService = (MapService)this.getService();
        this.mapServiceContext = this.mapService.getMapServiceContext();
        this.mapEventPublisher = this.mapServiceContext.getMapEventPublisher();
        this.innerBeforeRun();
    }

    public void innerBeforeRun() throws Exception {
        this.recordStore = this.getRecordStoreOrNull();
        this.mapContainer = this.recordStore == null ? this.mapServiceContext.getMapContainer(this.name) : this.recordStore.getMapContainer();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void afterRun() throws Exception {
    }

    protected boolean isPostProcessing(RecordStore recordStore) {
        MapDataStore<Data, Object> mapDataStore = recordStore.getMapDataStore();
        return mapDataStore.isPostProcessingMapStore() || this.mapServiceContext.hasInterceptor(this.name);
    }

    public void setThreadId(long threadId) {
        throw new UnsupportedOperationException();
    }

    public long getThreadId() {
        throw new UnsupportedOperationException();
    }

    protected final void invalidateNearCache(List<Data> keys) {
        if (!this.mapContainer.isInvalidationEnabled() || CollectionUtil.isEmpty(keys)) {
            return;
        }
        NearCacheProvider nearCacheProvider = this.mapServiceContext.getNearCacheProvider();
        nearCacheProvider.getNearCacheInvalidator().invalidate(this.name, keys, this.getCallerUuid());
    }

    protected final void invalidateNearCache(Data key) {
        if (!this.mapContainer.isInvalidationEnabled() || key == null) {
            return;
        }
        NearCacheProvider nearCacheProvider = this.mapServiceContext.getNearCacheProvider();
        nearCacheProvider.getNearCacheInvalidator().invalidate(this.name, key, this.getCallerUuid());
    }

    protected final void clearLocalNearCache() {
        if (!this.mapContainer.isInvalidationEnabled()) {
            return;
        }
        NearCacheProvider nearCacheProvider = this.mapServiceContext.getNearCacheProvider();
        nearCacheProvider.getNearCacheInvalidator().clearLocalNearCache(this.name);
    }

    protected void evict(Data excludedKey) {
        assert (this.recordStore != null) : "Record-store cannot be null";
        this.recordStore.evictEntries(excludedKey);
    }

    private RecordStore getRecordStoreOrNull() {
        int partitionId = this.getPartitionId();
        if (partitionId == -1) {
            return null;
        }
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        if (this.createRecordStoreOnDemand) {
            return partitionContainer.getRecordStore(this.name);
        }
        return partitionContainer.getExistingRecordStore(this.name);
    }
}

