/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.UrlXmlConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.DuplicateInstanceNameException;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.web.ClusteredSessionService;
import com.hazelcast.web.listener.ClientLifecycleListener;
import com.hazelcast.web.listener.ServerLifecycleListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;

final class HazelcastInstanceLoader {
    public static final String INSTANCE_NAME = "instance-name";
    public static final String CONFIG_LOCATION = "config-location";
    public static final String USE_CLIENT = "use-client";
    public static final String CLIENT_CONFIG_LOCATION = "client-config-location";
    public static final String STICKY_SESSION_CONFIG = "sticky-session";
    public static final String SESSION_TTL_CONFIG = "session-ttl-seconds";
    public static final String MAP_NAME = "map-name";
    private static final String SESSION_TTL_DEFAULT_SECONDS = "1800";
    private static final ILogger LOGGER = Logger.getLogger(HazelcastInstanceLoader.class);

    private HazelcastInstanceLoader() {
    }

    public static HazelcastInstance createInstance(ClusteredSessionService sessionService) throws ServletException {
        Properties properties = sessionService.getProperties();
        String instanceName = properties.getProperty(INSTANCE_NAME);
        String configLocation = properties.getProperty(CONFIG_LOCATION);
        String useClientProp = properties.getProperty(USE_CLIENT);
        String clientConfigLocation = properties.getProperty(CLIENT_CONFIG_LOCATION);
        boolean useClient = !HazelcastInstanceLoader.isEmpty(useClientProp) && Boolean.parseBoolean(useClientProp);
        URL configUrl = null;
        if (useClient && !HazelcastInstanceLoader.isEmpty(clientConfigLocation)) {
            configUrl = HazelcastInstanceLoader.getConfigURL(sessionService.getFilterConfig(), clientConfigLocation);
        } else if (!HazelcastInstanceLoader.isEmpty(configLocation)) {
            configUrl = HazelcastInstanceLoader.getConfigURL(sessionService.getFilterConfig(), configLocation);
        }
        String sessionTTLConfig = properties.getProperty(SESSION_TTL_CONFIG);
        if (useClient) {
            if (sessionTTLConfig != null) {
                throw new InvalidConfigurationException("session-ttl-seconds cannot be used with client/server mode.");
            }
            boolean isSticky = Boolean.valueOf(properties.getProperty(STICKY_SESSION_CONFIG));
            return HazelcastInstanceLoader.createClientInstance(sessionService, configUrl, instanceName, isSticky);
        }
        Config config = HazelcastInstanceLoader.getServerConfig(properties.getProperty(MAP_NAME), configUrl, sessionTTLConfig);
        return HazelcastInstanceLoader.createHazelcastInstance(sessionService, instanceName, config);
    }

    private static Config getServerConfig(String mapName, URL configUrl, String sessionTTLConfig) throws ServletException {
        Config config;
        if (configUrl == null) {
            config = new XmlConfigBuilder().build();
        } else {
            try {
                config = new UrlXmlConfig(configUrl);
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (sessionTTLConfig == null) {
            sessionTTLConfig = SESSION_TTL_DEFAULT_SECONDS;
        }
        MapConfig mapConfig = config.getMapConfig(mapName);
        try {
            mapConfig.setMaxIdleSeconds(Integer.parseInt(sessionTTLConfig));
        }
        catch (NumberFormatException e) {
            ExceptionUtil.rethrow(new InvalidConfigurationException("session-ttl-seconds must be a numeric value"));
        }
        return config;
    }

    private static HazelcastInstance createHazelcastInstance(ClusteredSessionService sessionService, String instanceName, Config config) {
        ListenerConfig listenerConfig = new ListenerConfig(new ServerLifecycleListener(sessionService));
        config.addListenerConfig(listenerConfig);
        if (!HazelcastInstanceLoader.isEmpty(instanceName)) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(String.format("getOrCreateHazelcastInstance for session replication, using name '%s'", instanceName));
            }
            config.setInstanceName(instanceName);
            return Hazelcast.getOrCreateHazelcastInstance(config);
        }
        LOGGER.info("Creating a new HazelcastInstance for session replication");
        return Hazelcast.newHazelcastInstance(config);
    }

    private static HazelcastInstance createClientInstance(ClusteredSessionService sessionService, URL configUrl, String instanceName, boolean isSticky) throws ServletException {
        ClientConfig clientConfig;
        LOGGER.warning("Creating HazelcastClient for session replication...");
        LOGGER.warning("make sure this client has access to an already running cluster...");
        if (configUrl == null) {
            clientConfig = new ClientConfig();
        } else {
            try {
                clientConfig = new XmlClientConfigBuilder(configUrl).build();
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (isSticky) {
            clientConfig.getNetworkConfig().setConnectionAttemptLimit(1);
        }
        ListenerConfig listenerConfig = new ListenerConfig(new ClientLifecycleListener(sessionService));
        clientConfig.addListenerConfig(listenerConfig);
        if (!HazelcastInstanceLoader.isEmpty(instanceName)) {
            HazelcastInstance instance = HazelcastClient.getHazelcastClientByName(instanceName);
            if (instance != null) {
                return instance;
            }
            clientConfig.setInstanceName(instanceName);
            try {
                return HazelcastClient.newHazelcastClient(clientConfig);
            }
            catch (DuplicateInstanceNameException e) {
                return HazelcastClient.getHazelcastClientByName(instanceName);
            }
        }
        return HazelcastClient.newHazelcastClient(clientConfig);
    }

    private static URL getConfigURL(FilterConfig filterConfig, String configLocation) throws ServletException {
        URL configUrl = null;
        try {
            configUrl = filterConfig.getServletContext().getResource(configLocation);
        }
        catch (MalformedURLException ignore) {
            LOGGER.info("ignored MalformedURLException");
        }
        if (configUrl == null) {
            configUrl = ConfigLoader.locateConfig(configLocation);
        }
        if (configUrl == null) {
            throw new ServletException("Could not load configuration '" + configLocation + "'");
        }
        return configUrl;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }
}

