/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class MapTryLockCodec {
    public static final MapMessageType REQUEST_TYPE = MapMessageType.MAP_TRYLOCK;
    public static final int RESPONSE_TYPE = 101;
    public static final boolean RETRYABLE = true;

    public static ClientMessage encodeRequest(String name, Data key, long threadId, long lease, long timeout, long referenceId) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, key, threadId, lease, timeout, referenceId);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(true);
        clientMessage.set(name);
        clientMessage.set(key);
        clientMessage.set(threadId);
        clientMessage.set(lease);
        clientMessage.set(timeout);
        clientMessage.set(referenceId);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        long referenceId;
        long timeout;
        long lease;
        long threadId;
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        Data key = null;
        parameters.key = key = clientMessage.getData();
        parameters.threadId = threadId = clientMessage.getLong();
        parameters.lease = lease = clientMessage.getLong();
        parameters.timeout = timeout = clientMessage.getLong();
        if (clientMessage.isComplete()) {
            return parameters;
        }
        parameters.referenceId = referenceId = clientMessage.getLong();
        parameters.referenceIdExist = true;
        return parameters;
    }

    public static ClientMessage encodeResponse(boolean response) {
        int requiredDataSize = ResponseParameters.calculateDataSize(response);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(101);
        clientMessage.set(response);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        boolean response;
        ResponseParameters parameters = new ResponseParameters();
        parameters.response = response = clientMessage.getBoolean();
        return parameters;
    }

    public static class ResponseParameters {
        public boolean response;

        public static int calculateDataSize(boolean response) {
            int dataSize = ClientMessage.HEADER_SIZE;
            return ++dataSize;
        }
    }

    public static class RequestParameters {
        public static final MapMessageType TYPE = REQUEST_TYPE;
        public String name;
        public Data key;
        public long threadId;
        public long lease;
        public long timeout;
        public long referenceId;
        public boolean referenceIdExist = false;

        public static int calculateDataSize(String name, Data key, long threadId, long lease, long timeout, long referenceId) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize(name);
            dataSize += ParameterUtil.calculateDataSize(key);
            dataSize += 8;
            dataSize += 8;
            dataSize += 8;
            return dataSize += 8;
        }
    }
}

