/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.map.impl.LocalMapStatsProvider;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.spi.StatisticsAwareService;
import com.hazelcast.util.MapUtil;
import java.util.Collection;
import java.util.Map;

class MapStatisticsAwareService
implements StatisticsAwareService {
    private final MapServiceContext mapServiceContext;
    private final ProxyService proxyService;

    MapStatisticsAwareService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.proxyService = mapServiceContext.getNodeEngine().getProxyService();
    }

    public Map<String, LocalMapStats> getStats() {
        MapServiceContext mapServiceContext = this.mapServiceContext;
        Collection<DistributedObject> mapProxies = this.proxyService.getDistributedObjects("hz:impl:mapService");
        Map<String, LocalMapStats> mapStats = MapUtil.createHashMap(mapProxies.size());
        for (DistributedObject mapProxy : mapProxies) {
            LocalMapStatsProvider localMapStatsProvider = mapServiceContext.getLocalMapStatsProvider();
            mapStats.put(mapProxy.getName(), localMapStatsProvider.createLocalMapStats(mapProxy.getName()));
        }
        return mapStats;
    }
}

