/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ClientMessageBuilder;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.tcp.ReadHandler;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ClientReadHandler
implements ReadHandler,
ClientMessageBuilder.MessageHandler {
    private final ClientMessageBuilder builder;
    private final Connection connection;
    private final IOService ioService;

    public ClientReadHandler(Connection connection, IOService ioService) throws IOException {
        this.connection = connection;
        this.ioService = ioService;
        this.builder = new ClientMessageBuilder(this);
    }

    @Override
    public void onRead(ByteBuffer src) throws Exception {
        this.builder.onData(src);
    }

    @Override
    public void handleMessage(ClientMessage message) {
        this.ioService.handleClientMessage(message, this.connection);
    }
}

