/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aggregation.impl;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.aggregation.impl.AbstractAggregator;
import java.math.BigDecimal;

public class BigDecimalAverageAggregator<I>
extends AbstractAggregator<I, BigDecimal> {
    private BigDecimal sum = BigDecimal.ZERO;
    private long count;

    public BigDecimalAverageAggregator() {
    }

    public BigDecimalAverageAggregator(String attributePath) {
        super(attributePath);
    }

    @Override
    public void accumulate(I input) {
        ++this.count;
        BigDecimal extractedValue = (BigDecimal)this.extract(input);
        this.sum = this.sum.add(extractedValue);
    }

    @Override
    public void combine(Aggregator aggregator) {
        BigDecimalAverageAggregator doubleAverageAggregator = (BigDecimalAverageAggregator)aggregator;
        this.sum = this.sum.add(doubleAverageAggregator.sum);
        this.count += doubleAverageAggregator.count;
    }

    @Override
    public BigDecimal aggregate() {
        if (this.count == 0L) {
            return null;
        }
        return this.sum.divide(BigDecimal.valueOf(this.count));
    }
}

