/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aggregation.impl;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.aggregation.impl.AbstractAggregator;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigIntegerAverageAggregator<I>
extends AbstractAggregator<I, BigDecimal> {
    private BigInteger sum = BigInteger.ZERO;
    private long count;

    public BigIntegerAverageAggregator() {
    }

    public BigIntegerAverageAggregator(String attributePath) {
        super(attributePath);
    }

    @Override
    public void accumulate(I entry) {
        ++this.count;
        BigInteger extractedValue = (BigInteger)this.extract(entry);
        this.sum = this.sum.add(extractedValue);
    }

    @Override
    public void combine(Aggregator aggregator) {
        BigIntegerAverageAggregator typedAggregator = (BigIntegerAverageAggregator)aggregator;
        this.sum = this.sum.add(typedAggregator.sum);
        this.count += typedAggregator.count;
    }

    @Override
    public BigDecimal aggregate() {
        if (this.count == 0L) {
            return null;
        }
        return new BigDecimal(this.sum).divide(BigDecimal.valueOf(this.count));
    }
}

