/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aggregation.impl;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.aggregation.impl.AbstractAggregator;

public class IntegerAverageAggregator<I>
extends AbstractAggregator<I, Double> {
    private long sum;
    private long count;

    public IntegerAverageAggregator() {
    }

    public IntegerAverageAggregator(String attributePath) {
        super(attributePath);
    }

    @Override
    public void accumulate(I entry) {
        ++this.count;
        Integer extractedValue = (Integer)this.extract(entry);
        this.sum += (long)extractedValue.intValue();
    }

    @Override
    public void combine(Aggregator aggregator) {
        IntegerAverageAggregator integerAverageAggregator = (IntegerAverageAggregator)aggregator;
        this.sum += integerAverageAggregator.sum;
        this.count += integerAverageAggregator.count;
    }

    @Override
    public Double aggregate() {
        if (this.count == 0L) {
            return null;
        }
        return (double)this.sum / (double)this.count;
    }
}

