/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aggregation.impl;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.aggregation.impl.AbstractAggregator;

public class LongAverageAggregator<I>
extends AbstractAggregator<I, Double> {
    private long sum;
    private long count;

    public LongAverageAggregator() {
    }

    public LongAverageAggregator(String attributePath) {
        super(attributePath);
    }

    @Override
    public void accumulate(I entry) {
        ++this.count;
        Long extractedValue = (Long)this.extract(entry);
        this.sum += extractedValue.longValue();
    }

    @Override
    public void combine(Aggregator aggregator) {
        LongAverageAggregator longAverageAggregator = (LongAverageAggregator)aggregator;
        this.sum += longAverageAggregator.sum;
        this.count += longAverageAggregator.count;
    }

    @Override
    public Double aggregate() {
        if (this.count == 0L) {
            return null;
        }
        return (double)this.sum / (double)this.count;
    }
}

