/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.client.CacheInvalidationMessage;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import java.io.IOException;
import java.util.UUID;

public class CacheSingleInvalidationMessage
extends CacheInvalidationMessage {
    private Data key;
    private String sourceUuid;
    private UUID partitionUuid;
    private long sequence;

    public CacheSingleInvalidationMessage() {
    }

    public CacheSingleInvalidationMessage(String name, Data key, String sourceUuid, UUID partitionUuid, long sequence) {
        super(name);
        this.key = key;
        this.sourceUuid = sourceUuid;
        this.partitionUuid = partitionUuid;
        this.sequence = sequence;
    }

    @Override
    public Data getKey() {
        return this.key;
    }

    public long getSequence() {
        return this.sequence;
    }

    @Override
    public String getSourceUuid() {
        return this.sourceUuid;
    }

    public UUID getPartitionUuid() {
        return this.partitionUuid;
    }

    @Override
    public int getId() {
        return 39;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeUTF(this.sourceUuid);
        boolean hasKey = this.key != null;
        out.writeBoolean(hasKey);
        if (hasKey) {
            out.writeData(this.key);
        }
        out.writeLong(this.sequence);
        out.writeLong(this.partitionUuid.getMostSignificantBits());
        out.writeLong(this.partitionUuid.getLeastSignificantBits());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.sourceUuid = in.readUTF();
        if (in.readBoolean()) {
            this.key = in.readData();
        }
        this.sequence = in.readLong();
        this.partitionUuid = new UUID(in.readLong(), in.readLong());
    }

    public String toString() {
        return "CacheSingleInvalidationMessage{name='" + this.name + '\'' + ", key=" + this.key + ", sourceUuid='" + this.sourceUuid + '\'' + ", partitionUuid='" + this.partitionUuid + '\'' + ", sequence=" + this.sequence + '}';
    }
}

