/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.operations;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.client.impl.client.ClientPrincipal;
import com.hazelcast.client.impl.operations.AbstractClientOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.UrgentSystemOperation;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import java.io.IOException;
import java.util.Set;

public class ClientReAuthOperation
extends AbstractClientOperation
implements UrgentSystemOperation,
AllowedDuringPassiveState {
    private String clientUuid;
    private boolean clientDisconnectOperationRun;

    public ClientReAuthOperation() {
    }

    public ClientReAuthOperation(String clientUuid) {
        this.clientUuid = clientUuid;
    }

    @Override
    public void run() throws Exception {
        String memberUuid = this.getCallerUuid();
        ClientEngineImpl engine = (ClientEngineImpl)this.getService();
        Set<ClientEndpoint> endpoints = engine.getEndpointManager().getEndpoints(this.clientUuid);
        for (ClientEndpoint endpoint : endpoints) {
            ClientPrincipal principal = new ClientPrincipal(this.clientUuid, memberUuid);
            endpoint.authenticated(principal);
        }
        String previousMemberUuid = engine.addOwnershipMapping(this.clientUuid, memberUuid);
        this.clientDisconnectOperationRun = previousMemberUuid == null;
    }

    @Override
    public boolean returnsResponse() {
        return Boolean.TRUE;
    }

    @Override
    public Object getResponse() {
        return this.clientDisconnectOperationRun;
    }

    @Override
    public String getServiceName() {
        return "hz:core:clientEngine";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.clientUuid);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.clientUuid = in.readUTF();
    }

    @Override
    public int getId() {
        return 1;
    }
}

