/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.EnterpriseMapMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class EnterpriseMapPublisherCreateCodec {
    public static final EnterpriseMapMessageType REQUEST_TYPE = EnterpriseMapMessageType.ENTERPRISEMAP_PUBLISHERCREATE;
    public static final int RESPONSE_TYPE = 106;
    public static final boolean RETRYABLE = true;

    public static ClientMessage encodeRequest(String mapName, String cacheName, Data predicate, int batchSize, int bufferSize, long delaySeconds, boolean populate, boolean coalesce) {
        int requiredDataSize = RequestParameters.calculateDataSize(mapName, cacheName, predicate, batchSize, bufferSize, delaySeconds, populate, coalesce);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(true);
        clientMessage.set(mapName);
        clientMessage.set(cacheName);
        clientMessage.set(predicate);
        clientMessage.set(batchSize);
        clientMessage.set(bufferSize);
        clientMessage.set(delaySeconds);
        clientMessage.set(populate);
        clientMessage.set(coalesce);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        String mapName = null;
        parameters.mapName = mapName = clientMessage.getStringUtf8();
        String cacheName = null;
        parameters.cacheName = cacheName = clientMessage.getStringUtf8();
        Data predicate = null;
        parameters.predicate = predicate = clientMessage.getData();
        int batchSize = 0;
        parameters.batchSize = batchSize = clientMessage.getInt();
        int bufferSize = 0;
        parameters.bufferSize = bufferSize = clientMessage.getInt();
        long delaySeconds = 0L;
        parameters.delaySeconds = delaySeconds = clientMessage.getLong();
        boolean populate = false;
        parameters.populate = populate = clientMessage.getBoolean();
        boolean coalesce = false;
        parameters.coalesce = coalesce = clientMessage.getBoolean();
        return parameters;
    }

    public static ClientMessage encodeResponse(Collection<Data> response) {
        int requiredDataSize = ResponseParameters.calculateDataSize(response);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(106);
        clientMessage.set(response.size());
        for (Data response_item : response) {
            clientMessage.set(response_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        ArrayList<Data> response = null;
        int response_size = clientMessage.getInt();
        response = new ArrayList<Data>(response_size);
        for (int response_index = 0; response_index < response_size; ++response_index) {
            Data response_item = null;
            response_item = clientMessage.getData();
            response.add(response_item);
        }
        parameters.response = response;
        return parameters;
    }

    public static class ResponseParameters {
        public List<Data> response;

        public static int calculateDataSize(Collection<Data> response) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += 4;
            for (Data response_item : response) {
                dataSize += ParameterUtil.calculateDataSize(response_item);
            }
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final EnterpriseMapMessageType TYPE = REQUEST_TYPE;
        public String mapName;
        public String cacheName;
        public Data predicate;
        public int batchSize;
        public int bufferSize;
        public long delaySeconds;
        public boolean populate;
        public boolean coalesce;

        public static int calculateDataSize(String mapName, String cacheName, Data predicate, int batchSize, int bufferSize, long delaySeconds, boolean populate, boolean coalesce) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize(mapName);
            dataSize += ParameterUtil.calculateDataSize(cacheName);
            dataSize += ParameterUtil.calculateDataSize(predicate);
            dataSize += 4;
            dataSize += 4;
            dataSize += 8;
            ++dataSize;
            return ++dataSize;
        }
    }
}

