/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class ScheduledExecutorGetStatsCodec {
    public static final ScheduledExecutorMessageType REQUEST_TYPE = ScheduledExecutorMessageType.SCHEDULEDEXECUTOR_GETSTATS;
    public static final int RESPONSE_TYPE = 120;
    public static final boolean RETRYABLE = true;

    public static ClientMessage encodeRequest(String handlerUrn) {
        int requiredDataSize = RequestParameters.calculateDataSize(handlerUrn);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(true);
        clientMessage.set(handlerUrn);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        if (clientMessage.isComplete()) {
            return parameters;
        }
        String handlerUrn = null;
        parameters.handlerUrn = handlerUrn = clientMessage.getStringUtf8();
        return parameters;
    }

    public static ClientMessage encodeResponse(long createdAt, long firstRunStartNanos, long lastIdleTimeNanos, long lastRunEndNanos, long lastRunStartNanos, long totalIdleTimeNanos, long totalRuns, long totalRunTimeNanos) {
        int requiredDataSize = ResponseParameters.calculateDataSize(createdAt, firstRunStartNanos, lastIdleTimeNanos, lastRunEndNanos, lastRunStartNanos, totalIdleTimeNanos, totalRuns, totalRunTimeNanos);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(120);
        clientMessage.set(createdAt);
        clientMessage.set(firstRunStartNanos);
        clientMessage.set(lastIdleTimeNanos);
        clientMessage.set(lastRunEndNanos);
        clientMessage.set(lastRunStartNanos);
        clientMessage.set(totalIdleTimeNanos);
        clientMessage.set(totalRuns);
        clientMessage.set(totalRunTimeNanos);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        if (clientMessage.isComplete()) {
            return parameters;
        }
        long createdAt = 0L;
        parameters.createdAt = createdAt = clientMessage.getLong();
        long firstRunStartNanos = 0L;
        parameters.firstRunStartNanos = firstRunStartNanos = clientMessage.getLong();
        long lastIdleTimeNanos = 0L;
        parameters.lastIdleTimeNanos = lastIdleTimeNanos = clientMessage.getLong();
        long lastRunEndNanos = 0L;
        parameters.lastRunEndNanos = lastRunEndNanos = clientMessage.getLong();
        long lastRunStartNanos = 0L;
        parameters.lastRunStartNanos = lastRunStartNanos = clientMessage.getLong();
        long totalIdleTimeNanos = 0L;
        parameters.totalIdleTimeNanos = totalIdleTimeNanos = clientMessage.getLong();
        long totalRuns = 0L;
        parameters.totalRuns = totalRuns = clientMessage.getLong();
        long totalRunTimeNanos = 0L;
        parameters.totalRunTimeNanos = totalRunTimeNanos = clientMessage.getLong();
        return parameters;
    }

    public static class ResponseParameters {
        public long createdAt;
        public long firstRunStartNanos;
        public long lastIdleTimeNanos;
        public long lastRunEndNanos;
        public long lastRunStartNanos;
        public long totalIdleTimeNanos;
        public long totalRuns;
        public long totalRunTimeNanos;

        public static int calculateDataSize(long createdAt, long firstRunStartNanos, long lastIdleTimeNanos, long lastRunEndNanos, long lastRunStartNanos, long totalIdleTimeNanos, long totalRuns, long totalRunTimeNanos) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += 8;
            dataSize += 8;
            dataSize += 8;
            dataSize += 8;
            dataSize += 8;
            dataSize += 8;
            dataSize += 8;
            return dataSize += 8;
        }
    }

    public static class RequestParameters {
        public static final ScheduledExecutorMessageType TYPE = REQUEST_TYPE;
        public String handlerUrn;

        public static int calculateDataSize(String handlerUrn) {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize += ParameterUtil.calculateDataSize(handlerUrn);
        }
    }
}

