/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.cache;

import com.hazelcast.cache.impl.CacheContext;
import com.hazelcast.cache.impl.CacheEventListener;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.client.CacheBatchInvalidationMessage;
import com.hazelcast.cache.impl.client.CacheInvalidationMessage;
import com.hazelcast.cache.impl.client.CacheSingleInvalidationMessage;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.nearcache.impl.invalidation.InvalidationUtils;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.NotifiableEventListener;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class CacheAddInvalidationListenerTask
extends AbstractCallableMessageTask<CacheAddInvalidationListenerCodec.RequestParameters> {
    public CacheAddInvalidationListenerTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() {
        ClientEndpoint endpoint = this.getEndpoint();
        CacheService cacheService = (CacheService)this.getService("hz:impl:cacheService");
        CacheContext cacheContext = cacheService.getOrCreateCacheContext(((CacheAddInvalidationListenerCodec.RequestParameters)this.parameters).name);
        CacheInvalidationEventListener listener = new CacheInvalidationEventListener(endpoint, cacheContext);
        String registrationId = cacheService.addInvalidationListener(((CacheAddInvalidationListenerCodec.RequestParameters)this.parameters).name, listener, ((CacheAddInvalidationListenerCodec.RequestParameters)this.parameters).localOnly);
        endpoint.addListenerDestroyAction("hz:impl:cacheService", ((CacheAddInvalidationListenerCodec.RequestParameters)this.parameters).name, registrationId);
        return registrationId;
    }

    @Override
    protected CacheAddInvalidationListenerCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return CacheAddInvalidationListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return CacheAddInvalidationListenerCodec.encodeResponse((String)response);
    }

    @Override
    public String getDistributedObjectName() {
        return ((CacheAddInvalidationListenerCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    private final class CacheInvalidationEventListener
    implements CacheEventListener,
    NotifiableEventListener<CacheService> {
        private final ClientEndpoint endpoint;
        private final CacheContext cacheContext;

        private CacheInvalidationEventListener(ClientEndpoint endpoint, CacheContext cacheContext) {
            this.endpoint = endpoint;
            this.cacheContext = cacheContext;
        }

        @Override
        public void handleEvent(Object eventObject) {
            if (!this.endpoint.isAlive() || !(eventObject instanceof CacheInvalidationMessage)) {
                return;
            }
            CacheInvalidationMessage invalidationMessage = (CacheInvalidationMessage)eventObject;
            ClientMessage message = this.getClientMessage(invalidationMessage);
            if (message != null) {
                CacheAddInvalidationListenerTask.this.sendClientMessage(invalidationMessage.getName(), message);
            }
        }

        private ClientMessage getClientMessage(Object eventObject) {
            if (eventObject instanceof CacheSingleInvalidationMessage) {
                CacheSingleInvalidationMessage message = (CacheSingleInvalidationMessage)eventObject;
                Data messageKey = message.getKey();
                Data key = messageKey == null ? InvalidationUtils.NULL_KEY : message.getKey();
                return CacheAddInvalidationListenerCodec.encodeCacheInvalidationEvent(message.getName(), key, message.getSourceUuid(), message.getPartitionUuid(), message.getSequence());
            }
            if (eventObject instanceof CacheBatchInvalidationMessage) {
                CacheBatchInvalidationMessage message = (CacheBatchInvalidationMessage)eventObject;
                List<CacheSingleInvalidationMessage> invalidationMessages = message.getInvalidationMessages();
                int size = invalidationMessages.size();
                ArrayList<Data> filteredKeys = new ArrayList<Data>(size);
                ArrayList<String> sourceUuids = new ArrayList<String>(invalidationMessages.size());
                ArrayList<UUID> partitionUuids = new ArrayList<UUID>(invalidationMessages.size());
                ArrayList<Long> sequences = new ArrayList<Long>(invalidationMessages.size());
                for (CacheSingleInvalidationMessage invalidationMessage : invalidationMessages) {
                    filteredKeys.add(invalidationMessage.getKey());
                    sourceUuids.add(invalidationMessage.getSourceUuid());
                    partitionUuids.add(invalidationMessage.getPartitionUuid());
                    sequences.add(invalidationMessage.getSequence());
                }
                return CacheAddInvalidationListenerCodec.encodeCacheBatchInvalidationEvent(message.getName(), filteredKeys, sourceUuids, partitionUuids, sequences);
            }
            throw new IllegalArgumentException("Unknown cache invalidation message type " + eventObject);
        }

        @Override
        public void onRegister(CacheService cacheService, String serviceName, String topic, EventRegistration registration) {
            this.cacheContext.increaseInvalidationListenerCount();
        }

        @Override
        public void onDeregister(CacheService cacheService, String serviceName, String topic, EventRegistration registration) {
            this.cacheContext.decreaseInvalidationListenerCount();
        }
    }
}

