/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapAddNearCacheInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.task.map.AbstractMapAddEntryListenerMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.map.impl.EventListenerFilter;
import com.hazelcast.map.impl.nearcache.invalidation.BatchNearCacheInvalidation;
import com.hazelcast.map.impl.nearcache.invalidation.Invalidation;
import com.hazelcast.map.impl.nearcache.invalidation.InvalidationListener;
import com.hazelcast.map.impl.nearcache.invalidation.UuidFilter;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class MapAddNearCacheInvalidationListenerMessageTask
extends AbstractMapAddEntryListenerMessageTask<MapAddNearCacheInvalidationListenerCodec.RequestParameters> {
    public MapAddNearCacheInvalidationListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected boolean isLocalOnly() {
        return ((MapAddNearCacheInvalidationListenerCodec.RequestParameters)this.parameters).localOnly;
    }

    @Override
    protected ClientMessage encodeEvent(Data keyData, Data newValueData, Data oldValueData, Data meringValueData, int type, String uuid, int numberOfAffectedEntries) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapAddNearCacheInvalidationListenerCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    protected MapAddNearCacheInvalidationListenerCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapAddNearCacheInvalidationListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapAddNearCacheInvalidationListenerCodec.encodeResponse((String)response);
    }

    @Override
    protected Object newMapListener() {
        return new ClientNearCacheInvalidationListenerImpl();
    }

    @Override
    protected EventFilter getEventFilter() {
        return new EventListenerFilter(((MapAddNearCacheInvalidationListenerCodec.RequestParameters)this.parameters).listenerFlags, new UuidFilter(this.endpoint.getUuid()));
    }

    private final class ClientNearCacheInvalidationListenerImpl
    implements InvalidationListener {
        private ClientNearCacheInvalidationListenerImpl() {
        }

        @Override
        public void onInvalidate(Invalidation invalidation) {
            ClientMessage message;
            if (!MapAddNearCacheInvalidationListenerMessageTask.this.endpoint.isAlive()) {
                return;
            }
            String mapName = invalidation.getName();
            Object orderKey = mapName;
            if (invalidation instanceof BatchNearCacheInvalidation) {
                ExtractedParams params = this.extractParams((BatchNearCacheInvalidation)invalidation);
                message = MapAddNearCacheInvalidationListenerCodec.encodeIMapBatchInvalidationEvent(params.keys, params.sourceUuids, params.partitionUuids, params.sequences);
            } else {
                Data key = invalidation.getKey();
                message = MapAddNearCacheInvalidationListenerCodec.encodeIMapInvalidationEvent(key, invalidation.getSourceUuid(), invalidation.getPartitionUuid(), invalidation.getSequence());
                orderKey = key;
            }
            MapAddNearCacheInvalidationListenerMessageTask.this.sendClientMessage(orderKey, message);
        }

        private ExtractedParams extractParams(BatchNearCacheInvalidation batch) {
            List<Invalidation> invalidations = batch.getInvalidations();
            int size = invalidations.size();
            ArrayList<Data> keys = new ArrayList<Data>(size);
            ArrayList<String> sourceUuids = new ArrayList<String>(size);
            ArrayList<UUID> partitionUuids = new ArrayList<UUID>(size);
            ArrayList<Long> sequences = new ArrayList<Long>(size);
            for (Invalidation invalidation : invalidations) {
                keys.add(invalidation.getKey());
                sourceUuids.add(invalidation.getSourceUuid());
                partitionUuids.add(invalidation.getPartitionUuid());
                sequences.add(invalidation.getSequence());
            }
            return new ExtractedParams(keys, sourceUuids, partitionUuids, sequences);
        }

        private final class ExtractedParams {
            private final List<Data> keys;
            private final List<String> sourceUuids;
            private final List<UUID> partitionUuids;
            private final List<Long> sequences;

            public ExtractedParams(List<Data> keys, List<String> sourceUuids, List<UUID> partitionUuids, List<Long> sequences) {
                this.keys = keys;
                this.sourceUuids = sourceUuids;
                this.partitionUuids = partitionUuids;
                this.sequences = sequences;
            }
        }
    }
}

