/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.querycache.subscriber;

import com.hazelcast.client.impl.querycache.subscriber.ListenerInfo;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.UuidUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class QueryCacheToListenerMapper {
    private static final ConstructorFunction<String, Collection<ListenerInfo>> LISTENER_SET_CONSTRUCTOR = new ConstructorFunction<String, Collection<ListenerInfo>>(){

        @Override
        public Collection<ListenerInfo> createNew(String arg) {
            return Collections.newSetFromMap(new ConcurrentHashMap());
        }
    };
    private final ConcurrentMap<String, Collection<ListenerInfo>> registrations = new ConcurrentHashMap<String, Collection<ListenerInfo>>();

    public String addListener(String cacheName, ListenerAdapter listenerAdapter, EventFilter filter) {
        Collection<ListenerInfo> adapters = ConcurrencyUtil.getOrPutIfAbsent(this.registrations, cacheName, LISTENER_SET_CONSTRUCTOR);
        String id = UuidUtil.newUnsecureUuidString();
        ListenerInfo info = new ListenerInfo(filter, listenerAdapter, id);
        adapters.add(info);
        return id;
    }

    public boolean removeListener(String cacheName, String id) {
        Collection<ListenerInfo> adapters = ConcurrencyUtil.getOrPutIfAbsent(this.registrations, cacheName, LISTENER_SET_CONSTRUCTOR);
        Iterator<ListenerInfo> iterator = adapters.iterator();
        while (iterator.hasNext()) {
            ListenerInfo listenerInfo = iterator.next();
            String listenerInfoId = listenerInfo.getId();
            if (!listenerInfoId.equals(id)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public Collection<ListenerInfo> getListenerInfos(String cacheName) {
        Collection infos = (Collection)this.registrations.get(cacheName);
        return CollectionUtil.isEmpty(infos) ? Collections.EMPTY_SET : infos;
    }
}

