/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorCancelCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorDisposeCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetDelayCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetResultCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetStatsCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorIsCancelledCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorIsDoneCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.scheduledexecutor.IScheduledFuture;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.ScheduledTaskStatistics;
import com.hazelcast.scheduledexecutor.StaleTaskException;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskStatisticsImpl;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClientScheduledFutureProxy<V>
extends ClientProxy
implements IScheduledFuture<V> {
    private static final ClientMessageDecoder IS_DONE_DECODER = new ClientMessageDecoder(){

        public Boolean decodeClientMessage(ClientMessage clientMessage) {
            return ScheduledExecutorIsDoneCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder IS_CANCELLED_DECODER = new ClientMessageDecoder(){

        public Boolean decodeClientMessage(ClientMessage clientMessage) {
            return ScheduledExecutorIsCancelledCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder CANCEL_DECODER = new ClientMessageDecoder(){

        public Boolean decodeClientMessage(ClientMessage clientMessage) {
            return ScheduledExecutorCancelCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder GET_STATS_DECODER = new ClientMessageDecoder(){

        public ScheduledTaskStatistics decodeClientMessage(ClientMessage clientMessage) {
            ScheduledExecutorGetStatsCodec.ResponseParameters responseParameters = ScheduledExecutorGetStatsCodec.decodeResponse(clientMessage);
            return new ScheduledTaskStatisticsImpl(responseParameters.totalRuns, responseParameters.firstRunStartNanos, responseParameters.lastRunStartNanos, responseParameters.lastRunEndNanos, responseParameters.lastIdleTimeNanos, responseParameters.totalRunTimeNanos, responseParameters.totalIdleTimeNanos);
        }
    };
    private static final ClientMessageDecoder GET_DELAY_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return ScheduledExecutorGetDelayCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder GET_RESULT_DECODER = new ClientMessageDecoder(){

        public Object decodeClientMessage(ClientMessage clientMessage) {
            return ScheduledExecutorGetResultCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder DISPOSE_DECODER = new ClientMessageDecoder(){

        public Void decodeClientMessage(ClientMessage clientMessage) {
            return null;
        }
    };
    private ScheduledTaskHandler handler;

    public ClientScheduledFutureProxy(ScheduledTaskHandler handler, ClientContext context) {
        super("hz:impl:scheduledExecutorService", handler.getSchedulerName());
        this.setContext(context);
        this.handler = handler;
    }

    @Override
    public ScheduledTaskHandler getHandler() {
        return this.handler;
    }

    @Override
    public ScheduledTaskStatistics getStats() {
        this.checkAccessibleHandler();
        ClientMessage request = ScheduledExecutorGetStatsCodec.encodeRequest(this.handler.toUrn());
        return (ScheduledTaskStatistics)this.submitAsync(request, GET_STATS_DECODER).join();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        Preconditions.checkNotNull(unit, "Unit is null");
        this.checkAccessibleHandler();
        ClientMessage request = ScheduledExecutorGetDelayCodec.encodeRequest(this.handler.toUrn(), unit.name());
        return (Long)this.submitAsync(request, GET_DELAY_DECODER).join();
    }

    @Override
    public int compareTo(Delayed o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (mayInterruptIfRunning) {
            throw new UnsupportedOperationException("mayInterruptIfRunning flag is not supported.");
        }
        this.checkAccessibleHandler();
        ClientMessage request = ScheduledExecutorCancelCodec.encodeRequest(this.handler.toUrn(), mayInterruptIfRunning);
        return (Boolean)this.submitAsync(request, CANCEL_DECODER).join();
    }

    @Override
    public boolean isCancelled() {
        this.checkAccessibleHandler();
        ClientMessage request = ScheduledExecutorIsCancelledCodec.encodeRequest(this.handler.toUrn());
        return (Boolean)this.submitAsync(request, IS_CANCELLED_DECODER).join();
    }

    @Override
    public boolean isDone() {
        this.checkAccessibleHandler();
        ClientMessage request = ScheduledExecutorIsDoneCodec.encodeRequest(this.handler.toUrn());
        return (Boolean)this.submitAsync(request, IS_DONE_DECODER).join();
    }

    private InternalCompletableFuture<V> get0() {
        this.checkAccessibleHandler();
        ClientMessage request = ScheduledExecutorGetResultCodec.encodeRequest(this.handler.toUrn());
        return this.submitAsync(request, GET_RESULT_DECODER);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.get0().join();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Preconditions.checkNotNull(unit, "Unit is null");
        return this.get0().get(timeout, unit);
    }

    @Override
    public void dispose() {
        this.checkAccessibleHandler();
        ClientMessage request = ScheduledExecutorDisposeCodec.encodeRequest(this.handler.toUrn());
        ClientDelegatingFuture future = this.submitAsync(request, DISPOSE_DECODER);
        this.handler = null;
        future.join();
    }

    private void checkAccessibleHandler() {
        if (this.handler == null) {
            throw new StaleTaskException("Scheduled task was previously disposed.");
        }
    }

    private <T> ClientDelegatingFuture<T> submitAsync(ClientMessage clientMessage, ClientMessageDecoder clientMessageDecoder) {
        return this.invokeOnPartitionAsync(clientMessage, clientMessageDecoder, this.handler.getPartitionId());
    }

    private <T> ClientDelegatingFuture<T> invokeOnPartitionAsync(ClientMessage clientMessage, ClientMessageDecoder clientMessageDecoder, int partitionId) {
        SerializationService serializationService = this.getContext().getSerializationService();
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, partitionId).invoke();
            return new ClientDelegatingFuture(future, serializationService, clientMessageDecoder);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }
}

