/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapAddNearCacheInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapGetAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveEntryListenerCodec;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.internal.adapter.IMapDataStructureAdapter;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.nearcache.InvalidationAwareWrapper;
import com.hazelcast.map.impl.nearcache.KeyStateMarker;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class NearCachedClientMapProxy<K, V>
extends ClientMapProxy<K, V> {
    private boolean invalidateOnChange;
    private NearCache<Object, Object> nearCache;
    private RepairingHandler repairingHandler;
    private KeyStateMarker keyStateMarker;
    private volatile String invalidationListenerId;

    public NearCachedClientMapProxy(String serviceName, String name) {
        super(serviceName, name);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        ClientContext context = this.getContext();
        NearCacheConfig nearCacheConfig = context.getClientConfig().getNearCacheConfig(this.name);
        NearCacheManager nearCacheManager = context.getNearCacheManager();
        IMapDataStructureAdapter adapter = new IMapDataStructureAdapter(this);
        int partitionCount = context.getPartitionService().getPartitionCount();
        this.nearCache = InvalidationAwareWrapper.asInvalidationAware(nearCacheManager.getOrCreateNearCache(this.name, nearCacheConfig, adapter), partitionCount);
        this.keyStateMarker = this.getKeyStateMarker();
        this.invalidateOnChange = this.nearCache.isInvalidatedOnChange();
        if (this.invalidateOnChange) {
            this.repairingHandler = context.getRepairingTask("hz:impl:mapService").registerAndGetHandler(this.name, this.nearCache);
            this.addNearCacheInvalidationListener(new ClientMapAddNearCacheEventHandler());
        }
    }

    @Override
    protected boolean containsKeyInternal(Data keyData) {
        Object cached = this.nearCache.get(keyData);
        if (cached != null) {
            return NearCache.NULL_OBJECT != cached;
        }
        return super.containsKeyInternal(keyData);
    }

    @Override
    protected V getInternal(Data key) {
        Object cached = this.nearCache.get(key);
        if (cached != null) {
            if (NearCache.NULL_OBJECT == cached) {
                return null;
            }
            return (V)cached;
        }
        boolean marked = this.keyStateMarker.tryMark(key);
        Object value = super.getInternal(key);
        if (marked) {
            this.tryToPutNearCache(key, value);
        }
        return value;
    }

    @Override
    protected MapRemoveCodec.ResponseParameters removeInternal(Data keyData) {
        MapRemoveCodec.ResponseParameters responseParameters = super.removeInternal(keyData);
        this.invalidateNearCache(keyData);
        return responseParameters;
    }

    @Override
    protected boolean removeInternal(Data keyData, Data valueData) {
        boolean removed = super.removeInternal(keyData, valueData);
        this.invalidateNearCache(keyData);
        return removed;
    }

    @Override
    protected void removeAllInternal(Predicate predicate) {
        super.removeAllInternal(predicate);
        this.nearCache.clear();
    }

    @Override
    protected void deleteInternal(Data keyData) {
        super.deleteInternal(keyData);
        this.invalidateNearCache(keyData);
    }

    @Override
    public ICompletableFuture<V> getAsyncInternal(final Data key) {
        Object cached = this.nearCache.get(key);
        if (cached != null && NearCache.NULL_OBJECT != cached) {
            return new CompletedFuture(this.getContext().getSerializationService(), cached, this.getContext().getExecutionService().getAsyncExecutor());
        }
        final boolean marked = this.keyStateMarker.tryMark(key);
        ICompletableFuture future = super.getAsyncInternal(key);
        ((ClientDelegatingFuture)future).andThenInternal(new ExecutionCallback<Data>(){

            @Override
            public void onResponse(Data value) {
                if (marked) {
                    NearCachedClientMapProxy.this.tryToPutNearCache(key, value);
                }
            }

            @Override
            public void onFailure(Throwable t) {
            }
        });
        return future;
    }

    @Override
    protected ICompletableFuture<V> putAsyncInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        ICompletableFuture future = super.putAsyncInternal(ttl, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
        return future;
    }

    @Override
    protected ICompletableFuture<Void> setAsyncInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        ICompletableFuture<Void> future = super.setAsyncInternal(ttl, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
        return future;
    }

    @Override
    protected ICompletableFuture<V> removeAsyncInternal(Data keyData) {
        ICompletableFuture future = super.removeAsyncInternal(keyData);
        this.invalidateNearCache(keyData);
        return future;
    }

    @Override
    protected boolean tryRemoveInternal(long timeout, TimeUnit timeunit, Data keyData) {
        boolean removed = super.tryRemoveInternal(timeout, timeunit, keyData);
        this.invalidateNearCache(keyData);
        return removed;
    }

    @Override
    protected boolean tryPutInternal(long timeout, TimeUnit timeunit, Data keyData, Data valueData) {
        boolean putInternal = super.tryPutInternal(timeout, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
        return putInternal;
    }

    @Override
    protected V putInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        Object previousValue = super.putInternal(ttl, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
        return previousValue;
    }

    @Override
    protected void putTransientInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        super.putTransientInternal(ttl, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
    }

    @Override
    protected V putIfAbsentInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        Object previousValue = super.putIfAbsentInternal(ttl, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
        return previousValue;
    }

    @Override
    protected boolean replaceIfSameInternal(Data keyData, Data oldValueData, Data newValueData) {
        boolean replaceIfSame = super.replaceIfSameInternal(keyData, oldValueData, newValueData);
        this.invalidateNearCache(keyData);
        return replaceIfSame;
    }

    @Override
    protected V replaceInternal(Data keyData, Data valueData) {
        Object v = super.replaceInternal(keyData, valueData);
        this.invalidateNearCache(keyData);
        return v;
    }

    @Override
    protected void setInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        super.setInternal(ttl, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
    }

    @Override
    protected boolean evictInternal(Data keyData) {
        boolean evicted = super.evictInternal(keyData);
        this.invalidateNearCache(keyData);
        return evicted;
    }

    @Override
    public void evictAll() {
        super.evictAll();
        this.nearCache.clear();
    }

    @Override
    public void loadAll(boolean replaceExistingValues) {
        super.loadAll(replaceExistingValues);
        if (replaceExistingValues) {
            this.nearCache.clear();
        }
    }

    @Override
    protected void loadAllInternal(boolean replaceExistingValues, Collection<Data> dataKeys) {
        super.loadAllInternal(replaceExistingValues, dataKeys);
        this.invalidateNearCache(dataKeys);
    }

    @Override
    protected List<MapGetAllCodec.ResponseParameters> getAllInternal(Map<Integer, List<Data>> pIdToKeyData, Map<K, V> result) {
        HashMap<Data, Boolean> markers = Collections.EMPTY_MAP;
        for (Map.Entry<Integer, List<Data>> partitionKeyEntry : pIdToKeyData.entrySet()) {
            List<Data> keyList = partitionKeyEntry.getValue();
            Iterator<Data> iterator = keyList.iterator();
            while (iterator.hasNext()) {
                Data key = iterator.next();
                Object cached = this.nearCache.get(key);
                if (cached != null && NearCache.NULL_OBJECT != cached) {
                    result.put(this.toObject(key), cached);
                    iterator.remove();
                    continue;
                }
                if (!this.invalidateOnChange) continue;
                if (markers == Collections.EMPTY_MAP) {
                    markers = new HashMap<Data, Boolean>();
                }
                markers.put(key, this.keyStateMarker.tryMark(key));
            }
        }
        List<MapGetAllCodec.ResponseParameters> responses = super.getAllInternal(pIdToKeyData, result);
        for (MapGetAllCodec.ResponseParameters resultParameters : responses) {
            for (Map.Entry<Data, Data> entry : resultParameters.response) {
                Data key = entry.getKey();
                Data value = entry.getValue();
                Boolean marked = (Boolean)markers.get(key);
                if (marked != null && marked.booleanValue()) {
                    this.tryToPutNearCache(key, value);
                    continue;
                }
                this.nearCache.put(key, value);
            }
        }
        return responses;
    }

    @Override
    public LocalMapStats getLocalMapStats() {
        LocalMapStats localMapStats = super.getLocalMapStats();
        NearCacheStats nearCacheStats = this.nearCache.getNearCacheStats();
        ((LocalMapStatsImpl)localMapStats).setNearCacheStats(nearCacheStats);
        return localMapStats;
    }

    @Override
    public Object executeOnKeyInternal(Data keyData, EntryProcessor entryProcessor) {
        Object response = super.executeOnKeyInternal(keyData, entryProcessor);
        this.invalidateNearCache(keyData);
        return response;
    }

    @Override
    public ICompletableFuture submitToKeyInternal(Data keyData, EntryProcessor entryProcessor) {
        ICompletableFuture future = super.submitToKeyInternal(keyData, entryProcessor);
        this.invalidateNearCache(keyData);
        return future;
    }

    @Override
    public void submitToKeyInternal(Data keyData, EntryProcessor entryProcessor, ExecutionCallback callback) {
        super.submitToKeyInternal(keyData, entryProcessor, callback);
        this.invalidateNearCache(keyData);
    }

    @Override
    protected Map<K, Object> prepareResult(Collection<Map.Entry<Data, Data>> entrySet) {
        if (CollectionUtil.isEmpty(entrySet)) {
            return Collections.emptyMap();
        }
        Map result = MapUtil.createHashMap(entrySet.size());
        for (Map.Entry<Data, Data> entry : entrySet) {
            Data dataKey = entry.getKey();
            this.invalidateNearCache(dataKey);
            Object key = this.toObject(dataKey);
            Object value = this.toObject(entry.getValue());
            result.put(key, value);
        }
        return result;
    }

    @Override
    protected void putAllInternal(Map<Integer, List<Map.Entry<Data, Data>>> entryMap) {
        super.putAllInternal(entryMap);
        for (List<Map.Entry<Data, Data>> entries : entryMap.values()) {
            for (Map.Entry<Data, Data> entry : entries) {
                this.invalidateNearCache(entry.getKey());
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.nearCache.clear();
    }

    @Override
    protected void onDestroy() {
        this.removeNearCacheInvalidationListener();
        this.getContext().getNearCacheManager().destroyNearCache(this.name);
        super.onDestroy();
    }

    @Override
    protected void onShutdown() {
        this.removeNearCacheInvalidationListener();
        this.getContext().getNearCacheManager().destroyNearCache(this.name);
        super.onShutdown();
    }

    public NearCache<Object, Object> getNearCache() {
        return this.nearCache;
    }

    private void invalidateNearCache(Data key) {
        this.nearCache.remove(key);
    }

    private void invalidateNearCache(Collection<Data> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        for (Data key : keys) {
            this.nearCache.remove(key);
        }
    }

    public void addNearCacheInvalidationListener(EventHandler handler) {
        try {
            this.invalidationListenerId = this.registerListener(this.createNearCacheEntryListenerCodec(), handler);
        }
        catch (Exception e) {
            ILogger logger = this.getContext().getLoggingService().getLogger(this.getClass());
            logger.severe("-----------------\n Near Cache is not initialized!!! \n-----------------", e);
        }
    }

    private ListenerMessageCodec createNearCacheEntryListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddNearCacheInvalidationListenerCodec.encodeRequest(NearCachedClientMapProxy.this.name, EntryEventType.INVALIDATION.getType(), localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return MapAddNearCacheInvalidationListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest(NearCachedClientMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    private void tryToPutNearCache(Data key, Object response) {
        try {
            this.nearCache.put(key, response);
        }
        finally {
            if (!this.keyStateMarker.tryUnmark(key)) {
                this.invalidateNearCache(key);
                this.keyStateMarker.forceUnmark(key);
            }
        }
    }

    private KeyStateMarker getKeyStateMarker() {
        return ((InvalidationAwareWrapper)this.nearCache).getKeyStateMarker();
    }

    private void removeNearCacheInvalidationListener() {
        String invalidationListenerId = this.invalidationListenerId;
        if (invalidationListenerId == null) {
            return;
        }
        this.getContext().getRepairingTask("hz:impl:mapService").deregisterHandler(this.name);
        this.deregisterListener(invalidationListenerId);
    }

    private final class ClientMapAddNearCacheEventHandler
    extends MapAddNearCacheInvalidationListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private ClientMapAddNearCacheEventHandler() {
        }

        @Override
        public void beforeListenerRegister() {
            NearCachedClientMapProxy.this.nearCache.clear();
        }

        @Override
        public void onListenerRegister() {
            NearCachedClientMapProxy.this.nearCache.clear();
        }

        @Override
        public void handle(Data key, String sourceUuid, UUID partitionUuid, long sequence) {
            NearCachedClientMapProxy.this.repairingHandler.handle(key, sourceUuid, partitionUuid, sequence);
        }

        @Override
        public void handle(Collection<Data> keys, Collection<String> sourceUuids, Collection<UUID> partitionUuids, Collection<Long> sequences) {
            NearCachedClientMapProxy.this.repairingHandler.handle(keys, sourceUuids, partitionUuids, sequences);
        }
    }
}

