/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.ConfigPatternMatcher;
import com.hazelcast.config.DistributedClassloadingConfig;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.config.JobTrackerConfig;
import com.hazelcast.config.ListConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.LockConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfigAccessor;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.QuorumConfig;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SemaphoreConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.ServicesConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.matcher.MatchingPointConfigPatternMatcher;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.util.Preconditions;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Config {
    private static final ILogger LOGGER = Logger.getLogger(Config.class);
    private URL configurationUrl;
    private File configurationFile;
    private ClassLoader classLoader;
    private Properties properties = new Properties();
    private String instanceName;
    private GroupConfig groupConfig = new GroupConfig();
    private NetworkConfig networkConfig = new NetworkConfig();
    private ConfigPatternMatcher configPatternMatcher = new MatchingPointConfigPatternMatcher();
    private final Map<String, MapConfig> mapConfigs = new ConcurrentHashMap<String, MapConfig>();
    private final Map<String, CacheSimpleConfig> cacheConfigs = new ConcurrentHashMap<String, CacheSimpleConfig>();
    private final Map<String, TopicConfig> topicConfigs = new ConcurrentHashMap<String, TopicConfig>();
    private final Map<String, ReliableTopicConfig> reliableTopicConfigs = new ConcurrentHashMap<String, ReliableTopicConfig>();
    private final Map<String, QueueConfig> queueConfigs = new ConcurrentHashMap<String, QueueConfig>();
    private final Map<String, LockConfig> lockConfigs = new ConcurrentHashMap<String, LockConfig>();
    private final Map<String, MultiMapConfig> multiMapConfigs = new ConcurrentHashMap<String, MultiMapConfig>();
    private final Map<String, ListConfig> listConfigs = new ConcurrentHashMap<String, ListConfig>();
    private final Map<String, SetConfig> setConfigs = new ConcurrentHashMap<String, SetConfig>();
    private final Map<String, ExecutorConfig> executorConfigs = new ConcurrentHashMap<String, ExecutorConfig>();
    private final Map<String, DurableExecutorConfig> durableExecutorConfigs = new ConcurrentHashMap<String, DurableExecutorConfig>();
    private final Map<String, ScheduledExecutorConfig> scheduledExecutorConfigs = new ConcurrentHashMap<String, ScheduledExecutorConfig>();
    private final Map<String, SemaphoreConfig> semaphoreConfigs = new ConcurrentHashMap<String, SemaphoreConfig>();
    private final Map<String, ReplicatedMapConfig> replicatedMapConfigs = new ConcurrentHashMap<String, ReplicatedMapConfig>();
    private final Map<String, WanReplicationConfig> wanReplicationConfigs = new ConcurrentHashMap<String, WanReplicationConfig>();
    private final Map<String, JobTrackerConfig> jobTrackerConfigs = new ConcurrentHashMap<String, JobTrackerConfig>();
    private final Map<String, QuorumConfig> quorumConfigs = new ConcurrentHashMap<String, QuorumConfig>();
    private final Map<String, RingbufferConfig> ringbufferConfigs = new ConcurrentHashMap<String, RingbufferConfig>();
    private ServicesConfig servicesConfig = new ServicesConfig();
    private SecurityConfig securityConfig = new SecurityConfig();
    private final List<ListenerConfig> listenerConfigs = new LinkedList<ListenerConfig>();
    private PartitionGroupConfig partitionGroupConfig = new PartitionGroupConfig();
    private ManagementCenterConfig managementCenterConfig = new ManagementCenterConfig();
    private SerializationConfig serializationConfig = new SerializationConfig();
    private ManagedContext managedContext;
    private ConcurrentMap<String, Object> userContext = new ConcurrentHashMap<String, Object>();
    private MemberAttributeConfig memberAttributeConfig = new MemberAttributeConfig();
    private NativeMemoryConfig nativeMemoryConfig = new NativeMemoryConfig();
    private HotRestartPersistenceConfig hotRestartPersistenceConfig = new HotRestartPersistenceConfig();
    private DistributedClassloadingConfig distributedClassloadingConfig = new DistributedClassloadingConfig();
    private String licenseKey;
    private boolean liteMember;

    public Config() {
    }

    public Config(String instanceName) {
        this.instanceName = instanceName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Config setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ConfigPatternMatcher getConfigPatternMatcher() {
        return this.configPatternMatcher;
    }

    public void setConfigPatternMatcher(ConfigPatternMatcher configPatternMatcher) {
        if (configPatternMatcher == null) {
            throw new IllegalArgumentException("ConfigPatternMatcher is not allowed to be null!");
        }
        this.configPatternMatcher = configPatternMatcher;
    }

    public String getProperty(String name) {
        String value = this.properties.getProperty(name);
        return value != null ? value : System.getProperty(name);
    }

    public Config setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public MemberAttributeConfig getMemberAttributeConfig() {
        return this.memberAttributeConfig;
    }

    public void setMemberAttributeConfig(MemberAttributeConfig memberAttributeConfig) {
        this.memberAttributeConfig = memberAttributeConfig;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Config setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public Config setInstanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    public GroupConfig getGroupConfig() {
        return this.groupConfig;
    }

    public Config setGroupConfig(GroupConfig groupConfig) {
        this.groupConfig = groupConfig;
        return this;
    }

    public NetworkConfig getNetworkConfig() {
        return this.networkConfig;
    }

    public Config setNetworkConfig(NetworkConfig networkConfig) {
        this.networkConfig = networkConfig;
        return this;
    }

    public MapConfig findMapConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        MapConfig config = this.lookupByPattern(this.mapConfigs, baseName);
        if (config != null) {
            NearCacheConfigAccessor.initDefaultMaxSizeForOnHeapMaps(config.getNearCacheConfig());
            return config.getAsReadOnly();
        }
        return this.getMapConfig("default").getAsReadOnly();
    }

    public MapConfig getMapConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        MapConfig config = this.lookupByPattern(this.mapConfigs, baseName);
        if (config != null) {
            return config;
        }
        MapConfig defConfig = this.mapConfigs.get("default");
        if (defConfig == null) {
            defConfig = new MapConfig();
            defConfig.setName("default");
            NearCacheConfigAccessor.initDefaultMaxSizeForOnHeapMaps(defConfig.getNearCacheConfig());
            this.addMapConfig(defConfig);
        }
        config = new MapConfig(defConfig);
        config.setName(name);
        this.addMapConfig(config);
        return config;
    }

    public Config addMapConfig(MapConfig mapConfig) {
        this.mapConfigs.put(mapConfig.getName(), mapConfig);
        return this;
    }

    public Map<String, MapConfig> getMapConfigs() {
        return this.mapConfigs;
    }

    public Config setMapConfigs(Map<String, MapConfig> mapConfigs) {
        this.mapConfigs.clear();
        this.mapConfigs.putAll(mapConfigs);
        for (Map.Entry<String, MapConfig> entry : this.mapConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public CacheSimpleConfig findCacheConfig(String name) {
        name = StringPartitioningStrategy.getBaseName(name);
        return this.lookupByPattern(this.cacheConfigs, name);
    }

    public CacheSimpleConfig getCacheConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        CacheSimpleConfig config = this.lookupByPattern(this.cacheConfigs, baseName);
        if (config != null) {
            return config;
        }
        CacheSimpleConfig defConfig = this.cacheConfigs.get("default");
        if (defConfig == null) {
            defConfig = new CacheSimpleConfig();
            defConfig.setName("default");
            this.addCacheConfig(defConfig);
        }
        config = new CacheSimpleConfig(defConfig);
        config.setName(name);
        this.addCacheConfig(config);
        return config;
    }

    public Config addCacheConfig(CacheSimpleConfig cacheConfig) {
        this.cacheConfigs.put(cacheConfig.getName(), cacheConfig);
        return this;
    }

    public Map<String, CacheSimpleConfig> getCacheConfigs() {
        return this.cacheConfigs;
    }

    public Config setCacheConfigs(Map<String, CacheSimpleConfig> cacheConfigs) {
        this.cacheConfigs.clear();
        this.cacheConfigs.putAll(cacheConfigs);
        for (Map.Entry<String, CacheSimpleConfig> entry : this.cacheConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public QueueConfig findQueueConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        QueueConfig config = this.lookupByPattern(this.queueConfigs, baseName);
        if (config != null) {
            return config.getAsReadOnly();
        }
        return this.getQueueConfig("default").getAsReadOnly();
    }

    public QueueConfig getQueueConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        QueueConfig config = this.lookupByPattern(this.queueConfigs, baseName);
        if (config != null) {
            return config;
        }
        QueueConfig defConfig = this.queueConfigs.get("default");
        if (defConfig == null) {
            defConfig = new QueueConfig();
            defConfig.setName("default");
            this.addQueueConfig(defConfig);
        }
        config = new QueueConfig(defConfig);
        config.setName(name);
        this.addQueueConfig(config);
        return config;
    }

    public Config addQueueConfig(QueueConfig queueConfig) {
        this.queueConfigs.put(queueConfig.getName(), queueConfig);
        return this;
    }

    public Map<String, QueueConfig> getQueueConfigs() {
        return this.queueConfigs;
    }

    public Config setQueueConfigs(Map<String, QueueConfig> queueConfigs) {
        this.queueConfigs.clear();
        this.queueConfigs.putAll(queueConfigs);
        for (Map.Entry<String, QueueConfig> entry : queueConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public LockConfig findLockConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        LockConfig config = this.lookupByPattern(this.lockConfigs, baseName);
        if (config != null) {
            return config.getAsReadOnly();
        }
        return this.getLockConfig("default").getAsReadOnly();
    }

    public LockConfig getLockConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        LockConfig config = this.lookupByPattern(this.lockConfigs, baseName);
        if (config != null) {
            return config;
        }
        LockConfig defConfig = this.lockConfigs.get("default");
        if (defConfig == null) {
            defConfig = new LockConfig();
            defConfig.setName("default");
            this.addLockConfig(defConfig);
        }
        config = new LockConfig(defConfig);
        config.setName(name);
        this.addLockConfig(config);
        return config;
    }

    public Config addLockConfig(LockConfig lockConfig) {
        this.lockConfigs.put(lockConfig.getName(), lockConfig);
        return this;
    }

    public Map<String, LockConfig> getLockConfigs() {
        return this.lockConfigs;
    }

    public Config setLockConfigs(Map<String, LockConfig> lockConfigs) {
        this.lockConfigs.clear();
        this.lockConfigs.putAll(lockConfigs);
        for (Map.Entry<String, LockConfig> entry : lockConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public ListConfig findListConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        ListConfig config = this.lookupByPattern(this.listConfigs, baseName);
        if (config != null) {
            return config.getAsReadOnly();
        }
        return this.getListConfig("default").getAsReadOnly();
    }

    public ListConfig getListConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        ListConfig config = this.lookupByPattern(this.listConfigs, baseName);
        if (config != null) {
            return config;
        }
        ListConfig defConfig = this.listConfigs.get("default");
        if (defConfig == null) {
            defConfig = new ListConfig();
            defConfig.setName("default");
            this.addListConfig(defConfig);
        }
        config = new ListConfig(defConfig);
        config.setName(name);
        this.addListConfig(config);
        return config;
    }

    public Config addListConfig(ListConfig listConfig) {
        this.listConfigs.put(listConfig.getName(), listConfig);
        return this;
    }

    public Map<String, ListConfig> getListConfigs() {
        return this.listConfigs;
    }

    public Config setListConfigs(Map<String, ListConfig> listConfigs) {
        this.listConfigs.clear();
        this.listConfigs.putAll(listConfigs);
        for (Map.Entry<String, ListConfig> entry : listConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public SetConfig findSetConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        SetConfig config = this.lookupByPattern(this.setConfigs, baseName);
        if (config != null) {
            return config.getAsReadOnly();
        }
        return this.getSetConfig("default").getAsReadOnly();
    }

    public SetConfig getSetConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        SetConfig config = this.lookupByPattern(this.setConfigs, baseName);
        if (config != null) {
            return config;
        }
        SetConfig defConfig = this.setConfigs.get("default");
        if (defConfig == null) {
            defConfig = new SetConfig();
            defConfig.setName("default");
            this.addSetConfig(defConfig);
        }
        config = new SetConfig(defConfig);
        config.setName(name);
        this.addSetConfig(config);
        return config;
    }

    public Config addSetConfig(SetConfig setConfig) {
        this.setConfigs.put(setConfig.getName(), setConfig);
        return this;
    }

    public Map<String, SetConfig> getSetConfigs() {
        return this.setConfigs;
    }

    public Config setSetConfigs(Map<String, SetConfig> setConfigs) {
        this.setConfigs.clear();
        this.setConfigs.putAll(setConfigs);
        for (Map.Entry<String, SetConfig> entry : setConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public MultiMapConfig findMultiMapConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        MultiMapConfig config = this.lookupByPattern(this.multiMapConfigs, baseName);
        if (config != null) {
            return config.getAsReadOnly();
        }
        return this.getMultiMapConfig("default").getAsReadOnly();
    }

    public MultiMapConfig getMultiMapConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        MultiMapConfig config = this.lookupByPattern(this.multiMapConfigs, baseName);
        if (config != null) {
            return config;
        }
        MultiMapConfig defConfig = this.multiMapConfigs.get("default");
        if (defConfig == null) {
            defConfig = new MultiMapConfig();
            defConfig.setName("default");
            this.addMultiMapConfig(defConfig);
        }
        config = new MultiMapConfig(defConfig);
        config.setName(name);
        this.addMultiMapConfig(config);
        return config;
    }

    public Config addMultiMapConfig(MultiMapConfig multiMapConfig) {
        this.multiMapConfigs.put(multiMapConfig.getName(), multiMapConfig);
        return this;
    }

    public Map<String, MultiMapConfig> getMultiMapConfigs() {
        return this.multiMapConfigs;
    }

    public Config setMultiMapConfigs(Map<String, MultiMapConfig> multiMapConfigs) {
        this.multiMapConfigs.clear();
        this.multiMapConfigs.putAll(multiMapConfigs);
        for (Map.Entry<String, MultiMapConfig> entry : this.multiMapConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public ReplicatedMapConfig findReplicatedMapConfig(String name) {
        ReplicatedMapConfig config = this.lookupByPattern(this.replicatedMapConfigs, name);
        if (config != null) {
            return config.getAsReadOnly();
        }
        return this.getReplicatedMapConfig("default").getAsReadOnly();
    }

    public ReplicatedMapConfig getReplicatedMapConfig(String name) {
        ReplicatedMapConfig config = this.lookupByPattern(this.replicatedMapConfigs, name);
        if (config != null) {
            return config;
        }
        ReplicatedMapConfig defConfig = this.replicatedMapConfigs.get("default");
        if (defConfig == null) {
            defConfig = new ReplicatedMapConfig();
            defConfig.setName("default");
            this.addReplicatedMapConfig(defConfig);
        }
        config = new ReplicatedMapConfig(defConfig);
        config.setName(name);
        this.addReplicatedMapConfig(config);
        return config;
    }

    public Config addReplicatedMapConfig(ReplicatedMapConfig replicatedMapConfig) {
        this.replicatedMapConfigs.put(replicatedMapConfig.getName(), replicatedMapConfig);
        return this;
    }

    public Map<String, ReplicatedMapConfig> getReplicatedMapConfigs() {
        return this.replicatedMapConfigs;
    }

    public Config setReplicatedMapConfigs(Map<String, ReplicatedMapConfig> replicatedMapConfigs) {
        this.replicatedMapConfigs.clear();
        this.replicatedMapConfigs.putAll(replicatedMapConfigs);
        for (Map.Entry<String, ReplicatedMapConfig> entry : this.replicatedMapConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public RingbufferConfig findRingbufferConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        RingbufferConfig config = this.lookupByPattern(this.ringbufferConfigs, baseName);
        if (config != null) {
            return config.getAsReadOnly();
        }
        return this.getRingbufferConfig("default").getAsReadOnly();
    }

    public RingbufferConfig getRingbufferConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        RingbufferConfig config = this.lookupByPattern(this.ringbufferConfigs, baseName);
        if (config != null) {
            return config;
        }
        RingbufferConfig defConfig = this.ringbufferConfigs.get("default");
        if (defConfig == null) {
            defConfig = new RingbufferConfig("default");
            this.addRingBufferConfig(defConfig);
        }
        config = new RingbufferConfig(name, defConfig);
        this.addRingBufferConfig(config);
        return config;
    }

    public Config addRingBufferConfig(RingbufferConfig ringbufferConfig) {
        this.ringbufferConfigs.put(ringbufferConfig.getName(), ringbufferConfig);
        return this;
    }

    public Map<String, RingbufferConfig> getRingbufferConfigs() {
        return this.ringbufferConfigs;
    }

    public Config setRingbufferConfigs(Map<String, RingbufferConfig> ringbufferConfigs) {
        this.ringbufferConfigs.clear();
        this.ringbufferConfigs.putAll(ringbufferConfigs);
        for (Map.Entry<String, RingbufferConfig> entry : ringbufferConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public TopicConfig findTopicConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        TopicConfig config = this.lookupByPattern(this.topicConfigs, baseName);
        if (config != null) {
            return config.getAsReadOnly();
        }
        return this.getTopicConfig("default").getAsReadOnly();
    }

    public TopicConfig getTopicConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        TopicConfig config = this.lookupByPattern(this.topicConfigs, baseName);
        if (config != null) {
            return config;
        }
        TopicConfig defConfig = this.topicConfigs.get("default");
        if (defConfig == null) {
            defConfig = new TopicConfig();
            defConfig.setName("default");
            this.addTopicConfig(defConfig);
        }
        config = new TopicConfig(defConfig);
        config.setName(name);
        this.addTopicConfig(config);
        return config;
    }

    public Config addTopicConfig(TopicConfig topicConfig) {
        this.topicConfigs.put(topicConfig.getName(), topicConfig);
        return this;
    }

    public ReliableTopicConfig findReliableTopicConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        ReliableTopicConfig config = this.lookupByPattern(this.reliableTopicConfigs, baseName);
        if (config != null) {
            return config.getAsReadOnly();
        }
        return this.getReliableTopicConfig("default").getAsReadOnly();
    }

    public ReliableTopicConfig getReliableTopicConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        ReliableTopicConfig config = this.lookupByPattern(this.reliableTopicConfigs, baseName);
        if (config != null) {
            return config;
        }
        ReliableTopicConfig defConfig = this.reliableTopicConfigs.get("default");
        if (defConfig == null) {
            defConfig = new ReliableTopicConfig("default");
            this.addReliableTopicConfig(defConfig);
        }
        config = new ReliableTopicConfig(defConfig, name);
        this.addReliableTopicConfig(config);
        return config;
    }

    public Map<String, ReliableTopicConfig> getReliableTopicConfigs() {
        return this.reliableTopicConfigs;
    }

    public Config addReliableTopicConfig(ReliableTopicConfig topicConfig) {
        this.reliableTopicConfigs.put(topicConfig.getName(), topicConfig);
        return this;
    }

    public Config setReliableTopicConfigs(Map<String, ReliableTopicConfig> reliableTopicConfigs) {
        this.reliableTopicConfigs.clear();
        this.reliableTopicConfigs.putAll(reliableTopicConfigs);
        for (Map.Entry<String, ReliableTopicConfig> entry : reliableTopicConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, TopicConfig> getTopicConfigs() {
        return this.topicConfigs;
    }

    public Config setTopicConfigs(Map<String, TopicConfig> mapTopicConfigs) {
        this.topicConfigs.clear();
        this.topicConfigs.putAll(mapTopicConfigs);
        for (Map.Entry<String, TopicConfig> entry : this.topicConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public ExecutorConfig findExecutorConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        ExecutorConfig config = this.lookupByPattern(this.executorConfigs, baseName);
        if (config != null) {
            return config.getAsReadOnly();
        }
        return this.getExecutorConfig("default").getAsReadOnly();
    }

    public DurableExecutorConfig findDurableExecutorConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        DurableExecutorConfig config = this.lookupByPattern(this.durableExecutorConfigs, baseName);
        if (config != null) {
            return config.getAsReadOnly();
        }
        return this.getDurableExecutorConfig("default").getAsReadOnly();
    }

    public ScheduledExecutorConfig findScheduledExecutorConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        ScheduledExecutorConfig config = this.lookupByPattern(this.scheduledExecutorConfigs, baseName);
        if (config != null) {
            return config.getAsReadOnly();
        }
        return this.getScheduledExecutorConfig("default").getAsReadOnly();
    }

    public ExecutorConfig getExecutorConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        ExecutorConfig config = this.lookupByPattern(this.executorConfigs, baseName);
        if (config != null) {
            return config;
        }
        ExecutorConfig defConfig = this.executorConfigs.get("default");
        if (defConfig == null) {
            defConfig = new ExecutorConfig();
            defConfig.setName("default");
            this.addExecutorConfig(defConfig);
        }
        config = new ExecutorConfig(defConfig);
        config.setName(name);
        this.addExecutorConfig(config);
        return config;
    }

    public DurableExecutorConfig getDurableExecutorConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        DurableExecutorConfig config = this.lookupByPattern(this.durableExecutorConfigs, baseName);
        if (config != null) {
            return config;
        }
        DurableExecutorConfig defConfig = this.durableExecutorConfigs.get("default");
        if (defConfig == null) {
            defConfig = new DurableExecutorConfig();
            defConfig.setName("default");
            this.addDurableExecutorConfig(defConfig);
        }
        config = new DurableExecutorConfig(defConfig);
        config.setName(name);
        this.addDurableExecutorConfig(config);
        return config;
    }

    public ScheduledExecutorConfig getScheduledExecutorConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        ScheduledExecutorConfig config = this.lookupByPattern(this.scheduledExecutorConfigs, baseName);
        if (config != null) {
            return config;
        }
        ScheduledExecutorConfig defConfig = this.scheduledExecutorConfigs.get("default");
        if (defConfig == null) {
            defConfig = new ScheduledExecutorConfig();
            defConfig.setName("default");
            this.addScheduledExecutorConfig(defConfig);
        }
        config = new ScheduledExecutorConfig(defConfig);
        config.setName(name);
        this.addScheduledExecutorConfig(config);
        return config;
    }

    public Config addExecutorConfig(ExecutorConfig executorConfig) {
        this.executorConfigs.put(executorConfig.getName(), executorConfig);
        return this;
    }

    public Config addDurableExecutorConfig(DurableExecutorConfig durableExecutorConfig) {
        this.durableExecutorConfigs.put(durableExecutorConfig.getName(), durableExecutorConfig);
        return this;
    }

    public Config addScheduledExecutorConfig(ScheduledExecutorConfig scheduledExecutorConfig) {
        this.scheduledExecutorConfigs.put(scheduledExecutorConfig.getName(), scheduledExecutorConfig);
        return this;
    }

    public Map<String, ExecutorConfig> getExecutorConfigs() {
        return this.executorConfigs;
    }

    public Config setExecutorConfigs(Map<String, ExecutorConfig> executorConfigs) {
        this.executorConfigs.clear();
        this.executorConfigs.putAll(executorConfigs);
        for (Map.Entry<String, ExecutorConfig> entry : executorConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, DurableExecutorConfig> getDurableExecutorConfigs() {
        return this.durableExecutorConfigs;
    }

    public Config setDurableExecutorConfigs(Map<String, DurableExecutorConfig> durableExecutorConfigs) {
        this.durableExecutorConfigs.clear();
        this.durableExecutorConfigs.putAll(durableExecutorConfigs);
        for (Map.Entry<String, DurableExecutorConfig> entry : durableExecutorConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, ScheduledExecutorConfig> getScheduledExecutorConfigs() {
        return this.scheduledExecutorConfigs;
    }

    public Config setScheduledExecutorConfigs(Map<String, ScheduledExecutorConfig> scheduledExecutorConfigs) {
        this.scheduledExecutorConfigs.clear();
        this.scheduledExecutorConfigs.putAll(scheduledExecutorConfigs);
        for (Map.Entry<String, ScheduledExecutorConfig> entry : scheduledExecutorConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public SemaphoreConfig findSemaphoreConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        SemaphoreConfig config = this.lookupByPattern(this.semaphoreConfigs, baseName);
        if (config != null) {
            return config.getAsReadOnly();
        }
        return this.getSemaphoreConfig("default").getAsReadOnly();
    }

    public SemaphoreConfig getSemaphoreConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        SemaphoreConfig config = this.lookupByPattern(this.semaphoreConfigs, baseName);
        if (config != null) {
            return config;
        }
        SemaphoreConfig defConfig = this.semaphoreConfigs.get("default");
        if (defConfig == null) {
            defConfig = new SemaphoreConfig();
            defConfig.setName("default");
            this.addSemaphoreConfig(defConfig);
        }
        config = new SemaphoreConfig(defConfig);
        config.setName(name);
        this.addSemaphoreConfig(config);
        return config;
    }

    public Config addSemaphoreConfig(SemaphoreConfig semaphoreConfig) {
        this.semaphoreConfigs.put(semaphoreConfig.getName(), semaphoreConfig);
        return this;
    }

    public Collection<SemaphoreConfig> getSemaphoreConfigs() {
        return this.semaphoreConfigs.values();
    }

    public Config setSemaphoreConfigs(Map<String, SemaphoreConfig> semaphoreConfigs) {
        this.semaphoreConfigs.clear();
        this.semaphoreConfigs.putAll(semaphoreConfigs);
        for (Map.Entry<String, SemaphoreConfig> entry : this.semaphoreConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public WanReplicationConfig getWanReplicationConfig(String name) {
        return this.wanReplicationConfigs.get(name);
    }

    public Config addWanReplicationConfig(WanReplicationConfig wanReplicationConfig) {
        this.wanReplicationConfigs.put(wanReplicationConfig.getName(), wanReplicationConfig);
        return this;
    }

    public Map<String, WanReplicationConfig> getWanReplicationConfigs() {
        return this.wanReplicationConfigs;
    }

    public Config setWanReplicationConfigs(Map<String, WanReplicationConfig> wanReplicationConfigs) {
        this.wanReplicationConfigs.clear();
        this.wanReplicationConfigs.putAll(wanReplicationConfigs);
        return this;
    }

    public JobTrackerConfig findJobTrackerConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        JobTrackerConfig config = this.lookupByPattern(this.jobTrackerConfigs, baseName);
        if (config != null) {
            return config.getAsReadOnly();
        }
        return this.getJobTrackerConfig(name);
    }

    public JobTrackerConfig getJobTrackerConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        JobTrackerConfig config = this.lookupByPattern(this.jobTrackerConfigs, baseName);
        if (config != null) {
            return config;
        }
        JobTrackerConfig defConfig = this.jobTrackerConfigs.get("default");
        if (defConfig == null) {
            defConfig = new JobTrackerConfig();
            defConfig.setName("default");
            this.addJobTrackerConfig(defConfig);
        }
        config = new JobTrackerConfig(defConfig);
        config.setName(name);
        this.addJobTrackerConfig(config);
        return config;
    }

    public Config addJobTrackerConfig(JobTrackerConfig jobTrackerConfig) {
        this.jobTrackerConfigs.put(jobTrackerConfig.getName(), jobTrackerConfig);
        return this;
    }

    public Map<String, JobTrackerConfig> getJobTrackerConfigs() {
        return this.jobTrackerConfigs;
    }

    public Config setJobTrackerConfigs(Map<String, JobTrackerConfig> jobTrackerConfigs) {
        this.jobTrackerConfigs.clear();
        this.jobTrackerConfigs.putAll(jobTrackerConfigs);
        for (Map.Entry<String, JobTrackerConfig> entry : this.jobTrackerConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, QuorumConfig> getQuorumConfigs() {
        return this.quorumConfigs;
    }

    public QuorumConfig getQuorumConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        QuorumConfig config = this.lookupByPattern(this.quorumConfigs, baseName);
        if (config != null) {
            return config;
        }
        QuorumConfig defConfig = this.quorumConfigs.get("default");
        if (defConfig == null) {
            defConfig = new QuorumConfig();
            defConfig.setName("default");
            this.addQuorumConfig(defConfig);
        }
        config = new QuorumConfig(defConfig);
        config.setName(name);
        this.addQuorumConfig(config);
        return config;
    }

    public QuorumConfig findQuorumConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        QuorumConfig config = this.lookupByPattern(this.quorumConfigs, baseName);
        if (config != null) {
            return config;
        }
        return this.getQuorumConfig("default");
    }

    public Config setQuorumConfigs(Map<String, QuorumConfig> quorumConfigs) {
        this.quorumConfigs.clear();
        this.quorumConfigs.putAll(quorumConfigs);
        for (Map.Entry<String, QuorumConfig> entry : this.quorumConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Config addQuorumConfig(QuorumConfig quorumConfig) {
        this.quorumConfigs.put(quorumConfig.getName(), quorumConfig);
        return this;
    }

    public ManagementCenterConfig getManagementCenterConfig() {
        return this.managementCenterConfig;
    }

    public Config setManagementCenterConfig(ManagementCenterConfig managementCenterConfig) {
        this.managementCenterConfig = managementCenterConfig;
        return this;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public Config setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
        return this;
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public Config setSecurityConfig(SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
        return this;
    }

    public Config addListenerConfig(ListenerConfig listenerConfig) {
        this.getListenerConfigs().add(listenerConfig);
        return this;
    }

    public List<ListenerConfig> getListenerConfigs() {
        return this.listenerConfigs;
    }

    public Config setListenerConfigs(List<ListenerConfig> listenerConfigs) {
        this.listenerConfigs.clear();
        this.listenerConfigs.addAll(listenerConfigs);
        return this;
    }

    public SerializationConfig getSerializationConfig() {
        return this.serializationConfig;
    }

    public Config setSerializationConfig(SerializationConfig serializationConfig) {
        this.serializationConfig = serializationConfig;
        return this;
    }

    public PartitionGroupConfig getPartitionGroupConfig() {
        return this.partitionGroupConfig;
    }

    public Config setPartitionGroupConfig(PartitionGroupConfig partitionGroupConfig) {
        this.partitionGroupConfig = partitionGroupConfig;
        return this;
    }

    public HotRestartPersistenceConfig getHotRestartPersistenceConfig() {
        return this.hotRestartPersistenceConfig;
    }

    public Config setHotRestartPersistenceConfig(HotRestartPersistenceConfig hrConfig) {
        Preconditions.checkNotNull(hrConfig, "Hot restart config cannot be null!");
        this.hotRestartPersistenceConfig = hrConfig;
        return this;
    }

    public ManagedContext getManagedContext() {
        return this.managedContext;
    }

    public Config setManagedContext(ManagedContext managedContext) {
        this.managedContext = managedContext;
        return this;
    }

    public ConcurrentMap<String, Object> getUserContext() {
        return this.userContext;
    }

    public Config setUserContext(ConcurrentMap<String, Object> userContext) {
        if (userContext == null) {
            throw new IllegalArgumentException("userContext can't be null");
        }
        this.userContext = userContext;
        return this;
    }

    public NativeMemoryConfig getNativeMemoryConfig() {
        return this.nativeMemoryConfig;
    }

    public Config setNativeMemoryConfig(NativeMemoryConfig nativeMemoryConfig) {
        this.nativeMemoryConfig = nativeMemoryConfig;
        return this;
    }

    public URL getConfigurationUrl() {
        return this.configurationUrl;
    }

    public Config setConfigurationUrl(URL configurationUrl) {
        this.configurationUrl = configurationUrl;
        return this;
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public Config setConfigurationFile(File configurationFile) {
        this.configurationFile = configurationFile;
        return this;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public Config setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
        return this;
    }

    public boolean isLiteMember() {
        return this.liteMember;
    }

    public Config setLiteMember(boolean liteMember) {
        this.liteMember = liteMember;
        return this;
    }

    public DistributedClassloadingConfig getDistributedClassloadingConfig() {
        return this.distributedClassloadingConfig;
    }

    public Config setDistributedClassloadingConfig(DistributedClassloadingConfig distributedClassloadingConfig) {
        this.distributedClassloadingConfig = distributedClassloadingConfig;
        return this;
    }

    private <T> T lookupByPattern(Map<String, T> configPatterns, String itemName) {
        T candidate = configPatterns.get(itemName);
        if (candidate != null) {
            return candidate;
        }
        String configPatternKey = this.configPatternMatcher.matches(configPatterns.keySet(), itemName);
        if (configPatternKey != null) {
            return configPatterns.get(configPatternKey);
        }
        if (!"default".equals(itemName) && !itemName.startsWith("hz:")) {
            LOGGER.finest("No configuration found for " + itemName + ", using default config!");
        }
        return null;
    }

    public boolean isCompatible(Config config) {
        if (config == null) {
            throw new IllegalArgumentException("Expected not null config");
        }
        if (!this.groupConfig.getName().equals(config.getGroupConfig().getName())) {
            return false;
        }
        if (!this.groupConfig.getPassword().equals(config.getGroupConfig().getPassword())) {
            throw new HazelcastException("Incompatible group password");
        }
        this.checkMapConfigCompatible(config);
        return true;
    }

    private void checkMapConfigCompatible(Config config) {
        HashSet<String> mapConfigNames = new HashSet<String>(this.mapConfigs.keySet());
        mapConfigNames.addAll(config.mapConfigs.keySet());
        for (String name : mapConfigNames) {
            MapConfig thisMapConfig = this.lookupByPattern(this.mapConfigs, name);
            MapConfig thatMapConfig = this.lookupByPattern(config.mapConfigs, name);
            if (thisMapConfig == null || thatMapConfig == null || thisMapConfig.isCompatible(thatMapConfig)) continue;
            throw new HazelcastException(MessageFormat.format("Incompatible map config this:\n{0}\nanother:\n{1}", thisMapConfig, thatMapConfig));
        }
    }

    public String toString() {
        return "Config{groupConfig=" + this.groupConfig + ", properties=" + this.properties + ", networkConfig=" + this.networkConfig + ", mapConfigs=" + this.mapConfigs + ", topicConfigs=" + this.topicConfigs + ", reliableTopicConfigs=" + this.reliableTopicConfigs + ", queueConfigs=" + this.queueConfigs + ", multiMapConfigs=" + this.multiMapConfigs + ", executorConfigs=" + this.executorConfigs + ", semaphoreConfigs=" + this.semaphoreConfigs + ", ringbufferConfigs=" + this.ringbufferConfigs + ", wanReplicationConfigs=" + this.wanReplicationConfigs + ", listenerConfigs=" + this.listenerConfigs + ", partitionGroupConfig=" + this.partitionGroupConfig + ", managementCenterConfig=" + this.managementCenterConfig + ", securityConfig=" + this.securityConfig + ", liteMember=" + this.liteMember + '}';
    }
}

