/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.CachePartitionLostListenerConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.LockConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapAttributeConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MapPartitionLostListenerConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.RingbufferStoreConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SemaphoreConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.WanPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.StringUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ConfigXmlGenerator {
    private static final ILogger LOGGER = Logger.getLogger(ConfigXmlGenerator.class);
    private static final int INDENT = 5;
    private final boolean formatted;

    public ConfigXmlGenerator() {
        this(true);
    }

    public ConfigXmlGenerator(boolean formatted) {
        this.formatted = formatted;
    }

    public String generate(Config config) {
        Preconditions.isNotNull(config, "Config");
        StringBuilder xml = new StringBuilder();
        xml.append("<hazelcast ").append("xmlns=\"http://www.hazelcast.com/schema/config\"\n").append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n").append("xsi:schemaLocation=\"http://www.hazelcast.com/schema/config ").append("http://www.hazelcast.com/schema/config/hazelcast-config-3.8.xsd\">");
        xml.append("<group>");
        xml.append("<name>").append(config.getGroupConfig().getName()).append("</name>");
        xml.append("<password>").append("****").append("</password>");
        xml.append("</group>");
        if (config.getLicenseKey() != null) {
            xml.append("<license-key>").append(config.getLicenseKey()).append("</license-key>");
        }
        if (config.getManagementCenterConfig() != null) {
            ManagementCenterConfig mcConfig = config.getManagementCenterConfig();
            xml.append("<management-center enabled=\"").append(mcConfig.isEnabled()).append("\" update-interval=\"").append(mcConfig.getUpdateInterval()).append("\">").append(mcConfig.getUrl()).append("</management-center>");
        }
        this.appendProperties(xml, config.getProperties());
        this.wanReplicationXmlGenerator(xml, config);
        this.networkConfigXmlGenerator(xml, config);
        this.mapConfigXmlGenerator(xml, config);
        this.replicatedMapConfigXmlGenerator(xml, config);
        this.cacheConfigXmlGenerator(xml, config);
        this.queueXmlGenerator(xml, config);
        this.multiMapXmlGenerator(xml, config);
        this.topicXmlGenerator(xml, config);
        this.semaphoreXmlGenerator(xml, config);
        this.lockXmlGenerator(xml, config);
        this.ringbufferXmlGenerator(xml, config);
        this.executorXmlGenerator(xml, config);
        this.durableExecutorXmlGenerator(xml, config);
        this.scheduledExecutorXmlGenerator(xml, config);
        this.partitionGroupXmlGenerator(xml, config);
        this.listenerXmlGenerator(xml, config);
        this.reliableTopicXmlGenerator(xml, config);
        this.liteMemberXmlGenerator(xml, config);
        this.hotRestartXmlGenerator(xml, config);
        xml.append("</hazelcast>");
        return this.format(xml.toString(), 5);
    }

    private void replicatedMapConfigXmlGenerator(StringBuilder xml, Config config) {
        Collection<ReplicatedMapConfig> replicatedMapConfigs = config.getReplicatedMapConfigs().values();
        for (ReplicatedMapConfig r : replicatedMapConfigs) {
            xml.append("<replicatedmap name=\"").append(r.getName()).append("\">");
            xml.append("<in-memory-format>").append((Object)r.getInMemoryFormat()).append("</in-memory-format>");
            xml.append("<concurrency-level>").append(r.getConcurrencyLevel()).append("</concurrency-level>");
            xml.append("<replication-delay-millis>").append(r.getReplicationDelayMillis()).append("</replication-delay-millis>");
            xml.append("<async-fillup>").append(r.isAsyncFillup()).append("</async-fillup>");
            xml.append("<statistics-enabled>").append(r.isStatisticsEnabled()).append("</statistics-enabled>");
            if (!r.getListenerConfigs().isEmpty()) {
                xml.append("<entry-listeners>");
                for (ListenerConfig lc : r.getListenerConfigs()) {
                    xml.append("<entry-listener include-value=\"").append(lc.isIncludeValue()).append("\" local=\"").append(lc.isLocal()).append("\">");
                    String clazz = lc.getImplementation() != null ? lc.getImplementation().getClass().getName() : lc.getClassName();
                    xml.append(clazz);
                    xml.append("</entry-listener>");
                }
                xml.append("</entry-listeners>");
            }
            xml.append("</replicatedmap>");
        }
    }

    private void listenerXmlGenerator(StringBuilder xml, Config config) {
        if (!config.getListenerConfigs().isEmpty()) {
            xml.append("<listeners>");
            for (ListenerConfig lc : config.getListenerConfigs()) {
                xml.append("<listener>");
                String clazz = lc.getImplementation() != null ? lc.getImplementation().getClass().getName() : lc.getClassName();
                xml.append(clazz);
                xml.append("</listener>");
            }
            xml.append("</listeners>");
        }
    }

    private void partitionGroupXmlGenerator(StringBuilder xml, Config config) {
        PartitionGroupConfig pg = config.getPartitionGroupConfig();
        if (pg != null) {
            xml.append("<partition-group enabled=\"").append(pg.isEnabled()).append("\" group-type=\"").append((Object)pg.getGroupType()).append("\" />");
        }
    }

    private void executorXmlGenerator(StringBuilder xml, Config config) {
        Collection<ExecutorConfig> exCfgs = config.getExecutorConfigs().values();
        for (ExecutorConfig ex : exCfgs) {
            xml.append("<executor-service name=\"").append(ex.getName()).append("\">");
            xml.append("<pool-size>").append(ex.getPoolSize()).append("</pool-size>");
            xml.append("<queue-capacity>").append(ex.getQueueCapacity()).append("</queue-capacity>");
            xml.append("</executor-service>");
        }
    }

    private void durableExecutorXmlGenerator(StringBuilder xml, Config config) {
        for (DurableExecutorConfig ex : config.getDurableExecutorConfigs().values()) {
            xml.append("<durable-executor-service name=\"").append(ex.getName()).append("\">");
            ConfigXmlGenerator.appendNode(xml, "pool-size", ex.getPoolSize());
            ConfigXmlGenerator.appendNode(xml, "durability", ex.getDurability());
            ConfigXmlGenerator.appendNode(xml, "capacity", ex.getCapacity());
            xml.append("</durable-executor-service>");
        }
    }

    private void scheduledExecutorXmlGenerator(StringBuilder xml, Config config) {
        for (ScheduledExecutorConfig ex : config.getScheduledExecutorConfigs().values()) {
            xml.append("<scheduled-executor-service name=\"").append(ex.getName()).append("\">");
            ConfigXmlGenerator.appendNode(xml, "pool-size", ex.getPoolSize());
            ConfigXmlGenerator.appendNode(xml, "durability", ex.getDurability());
            xml.append("</scheduled-executor-service>");
        }
    }

    private void semaphoreXmlGenerator(StringBuilder xml, Config config) {
        Collection<SemaphoreConfig> semaphoreCfgs = config.getSemaphoreConfigs();
        for (SemaphoreConfig sc : semaphoreCfgs) {
            xml.append("<semaphore name=\"").append(sc.getName()).append("\">");
            xml.append("<initial-permits>").append(sc.getInitialPermits()).append("</initial-permits>");
            xml.append("<backup-count>").append(sc.getBackupCount()).append("</backup-count>");
            xml.append("<async-backup-count>").append(sc.getAsyncBackupCount()).append("</async-backup-count>");
            xml.append("</semaphore>");
        }
    }

    private void topicXmlGenerator(StringBuilder xml, Config config) {
        Collection<TopicConfig> tCfgs = config.getTopicConfigs().values();
        for (TopicConfig t : tCfgs) {
            xml.append("<topic name=\"").append(t.getName()).append("\">");
            xml.append("<global-ordering-enabled>").append(t.isGlobalOrderingEnabled()).append("</global-ordering-enabled>");
            if (!t.getMessageListenerConfigs().isEmpty()) {
                xml.append("<message-listeners>");
                for (ListenerConfig lc : t.getMessageListenerConfigs()) {
                    xml.append("<message-listener>");
                    String clazz = lc.getImplementation() != null ? lc.getImplementation().getClass().getName() : lc.getClassName();
                    xml.append(clazz);
                    xml.append("</message-listener>");
                }
                xml.append("</message-listeners>");
            }
            xml.append("<multi-threading-enabled>").append(t.isMultiThreadingEnabled()).append("</multi-threading-enabled>");
            xml.append("</topic>");
        }
    }

    private void reliableTopicXmlGenerator(StringBuilder xml, Config config) {
        Collection<ReliableTopicConfig> tCfgs = config.getReliableTopicConfigs().values();
        for (ReliableTopicConfig t : tCfgs) {
            xml.append("<reliable-topic name=\"").append(t.getName()).append("\">");
            xml.append("<read-batch-size>").append(t.getReadBatchSize()).append("</read-batch-size>");
            xml.append("<statistics-enabled>").append(t.isStatisticsEnabled()).append("</statistics-enabled>");
            xml.append("<topic-overload-policy>").append(t.getTopicOverloadPolicy().name()).append("</topic-overload-policy>");
            if (!t.getMessageListenerConfigs().isEmpty()) {
                xml.append("<message-listeners>");
                for (ListenerConfig lc : t.getMessageListenerConfigs()) {
                    xml.append("<message-listener>");
                    String clazz = lc.getImplementation() != null ? lc.getImplementation().getClass().getName() : lc.getClassName();
                    xml.append(clazz);
                    xml.append("</message-listener>");
                }
                xml.append("</message-listeners>");
            }
            xml.append("</reliable-topic>");
        }
    }

    private void multiMapXmlGenerator(StringBuilder xml, Config config) {
        Collection<MultiMapConfig> mmCfgs = config.getMultiMapConfigs().values();
        for (MultiMapConfig mm : mmCfgs) {
            xml.append("<multimap name=\"").append(mm.getName()).append("\">");
            xml.append("<value-collection-type>").append((Object)mm.getValueCollectionType()).append("</value-collection-type>");
            if (!mm.getEntryListenerConfigs().isEmpty()) {
                xml.append("<entry-listeners>");
                for (EntryListenerConfig lc : mm.getEntryListenerConfigs()) {
                    xml.append("<entry-listener include-value=\"").append(lc.isIncludeValue()).append("\" local=\"").append(lc.isLocal()).append("\">");
                    String clazz = lc.getImplementation() != null ? lc.getImplementation().getClass().getName() : lc.getClassName();
                    xml.append(clazz);
                    xml.append("</entry-listener>");
                }
                xml.append("</entry-listeners>");
            }
            xml.append("</multimap>");
        }
    }

    private void queueXmlGenerator(StringBuilder xml, Config config) {
        Collection<QueueConfig> qCfgs = config.getQueueConfigs().values();
        for (QueueConfig q : qCfgs) {
            QueueStoreConfig storeConfig;
            xml.append("<queue name=\"").append(q.getName()).append("\">");
            xml.append("<statistics-enabled>").append(q.isStatisticsEnabled()).append("</statistics-enabled>");
            xml.append("<max-size>").append(q.getMaxSize()).append("</max-size>");
            xml.append("<backup-count>").append(q.getBackupCount()).append("</backup-count>");
            xml.append("<async-backup-count>").append(q.getAsyncBackupCount()).append("</async-backup-count>");
            xml.append("<empty-queue-ttl>").append(q.getEmptyQueueTtl()).append("</empty-queue-ttl>");
            if (!q.getItemListenerConfigs().isEmpty()) {
                xml.append("<item-listeners>");
                for (ItemListenerConfig lc : q.getItemListenerConfigs()) {
                    xml.append("<item-listener include-value=\"").append(lc.isIncludeValue()).append("\">");
                    xml.append(lc.getClassName());
                    xml.append("</item-listener>");
                }
                xml.append("</item-listeners>");
            }
            if ((storeConfig = q.getQueueStoreConfig()) != null) {
                xml.append("<queue-store enabled=\"").append(storeConfig.isEnabled()).append("\">");
                if (storeConfig.getClassName() != null) {
                    xml.append("<class-name>").append(storeConfig.getClassName()).append("</class-name>");
                }
                if (storeConfig.getFactoryClassName() != null) {
                    xml.append("<factory-class-name>").append(storeConfig.getFactoryClassName()).append("</factory-class-name>");
                }
                this.appendProperties(xml, storeConfig.getProperties());
                xml.append("</queue-store>");
            }
            if (q.getQuorumName() != null) {
                xml.append("<quorum-ref>").append(q.getQuorumName()).append("</quorum-ref>");
            }
            xml.append("</queue>");
        }
    }

    private void lockXmlGenerator(StringBuilder xml, Config config) {
        Collection<LockConfig> configs = config.getLockConfigs().values();
        for (LockConfig c : configs) {
            xml.append("<lock name=\"").append(c.getName()).append("\">");
            if (c.getQuorumName() != null) {
                xml.append("<quorum-ref>").append(c.getQuorumName()).append("</quorum-ref>");
            }
            xml.append("</lock>");
        }
    }

    private void ringbufferXmlGenerator(StringBuilder xml, Config config) {
        Collection<RingbufferConfig> configs = config.getRingbufferConfigs().values();
        for (RingbufferConfig rbConfig : configs) {
            xml.append("<ringbuffer name=\"").append(rbConfig.getName()).append("\">");
            xml.append("<capacity>").append(rbConfig.getCapacity()).append("</capacity>");
            xml.append("<time-to-live-seconds>").append(rbConfig.getTimeToLiveSeconds()).append("</time-to-live-seconds>");
            xml.append("<backup-count>").append(rbConfig.getBackupCount()).append("</backup-count>");
            xml.append("<async-backup-count>").append(rbConfig.getAsyncBackupCount()).append("</async-backup-count>");
            xml.append("<in-memory-format>").append(rbConfig.getInMemoryFormat().toString()).append("</in-memory-format>");
            RingbufferStoreConfig storeConfig = rbConfig.getRingbufferStoreConfig();
            if (storeConfig != null) {
                xml.append("<ringbuffer-store enabled=\"").append(storeConfig.isEnabled()).append("\">");
                if (storeConfig.getClassName() != null) {
                    xml.append("<class-name>").append(storeConfig.getClassName()).append("</class-name>");
                }
                if (storeConfig.getFactoryClassName() != null) {
                    xml.append("<factory-class-name>").append(storeConfig.getFactoryClassName()).append("</factory-class-name>");
                }
                this.appendProperties(xml, storeConfig.getProperties());
                xml.append("</ringbuffer-store>");
            }
            xml.append("</ringbuffer>");
        }
    }

    private void wanReplicationXmlGenerator(StringBuilder xml, Config config) {
        Collection<WanReplicationConfig> wanRepConfigs = config.getWanReplicationConfigs().values();
        for (WanReplicationConfig wan : wanRepConfigs) {
            xml.append("<wan-replication name=\"").append(wan.getName()).append("\">");
            List<WanPublisherConfig> publisherConfigs = wan.getWanPublisherConfigs();
            for (WanPublisherConfig p : publisherConfigs) {
                xml.append("<wan-publisher group-name=\"").append(p.getGroupName()).append("\">").append("<class-name>").append(p.getClassName()).append("</class-name>").append("<queue-full-behavior>").append((Object)p.getQueueFullBehavior()).append("</queue-full-behavior>").append("<queue-capacity>").append(p.getQueueCapacity()).append("</queue-capacity>");
                Map<String, Comparable> props = p.getProperties();
                if (!props.isEmpty()) {
                    xml.append("<properties>");
                    for (Map.Entry<String, Comparable> prop : props.entrySet()) {
                        xml.append("<property name=\"").append(prop.getKey()).append("\">").append(prop.getValue()).append("</property>");
                    }
                    xml.append("</properties>");
                }
                xml.append("</wan-publisher>");
            }
            xml.append("</wan-replication>");
        }
    }

    private void networkConfigXmlGenerator(StringBuilder xml, Config config) {
        NetworkConfig netCfg = config.getNetworkConfig();
        xml.append("<network>");
        if (netCfg.getPublicAddress() != null) {
            xml.append("<public-address>").append(netCfg.getPublicAddress()).append("</public-address>");
        }
        xml.append("<port port-count=\"").append(netCfg.getPortCount()).append("\" ").append("auto-increment=\"").append(netCfg.isPortAutoIncrement()).append("\">").append(netCfg.getPort()).append("</port>");
        JoinConfig join = netCfg.getJoin();
        xml.append("<join>");
        this.multicastConfigXmlGenerator(xml, join);
        this.tcpConfigXmlGenerator(xml, join);
        this.awsConfigXmlGenerator(xml, join);
        xml.append("</join>");
        this.interfacesConfigXmlGenerator(xml, netCfg);
        this.sslConfigXmlGenerator(xml, netCfg);
        this.socketInterceptorConfigXmlGenerator(xml, netCfg);
        this.symmetricEncInterceptorConfigXmlGenerator(xml, netCfg);
        xml.append("</network>");
    }

    private void mapConfigXmlGenerator(StringBuilder xml, Config config) {
        Collection<MapConfig> mCfgs = config.getMapConfigs().values();
        for (MapConfig m : mCfgs) {
            xml.append("<map name=\"").append(m.getName()).append("\">");
            xml.append("<in-memory-format>").append((Object)m.getInMemoryFormat()).append("</in-memory-format>");
            xml.append("<backup-count>").append(m.getBackupCount()).append("</backup-count>");
            xml.append("<async-backup-count>").append(m.getAsyncBackupCount()).append("</async-backup-count>");
            xml.append("<time-to-live-seconds>").append(m.getTimeToLiveSeconds()).append("</time-to-live-seconds>");
            xml.append("<max-idle-seconds>").append(m.getMaxIdleSeconds()).append("</max-idle-seconds>");
            xml.append("<eviction-policy>").append((Object)m.getEvictionPolicy()).append("</eviction-policy>");
            xml.append("<max-size policy=\"").append((Object)m.getMaxSizeConfig().getMaxSizePolicy()).append("\">").append(m.getMaxSizeConfig().getSize()).append("</max-size>");
            xml.append("<eviction-percentage>").append(m.getEvictionPercentage()).append("</eviction-percentage>");
            xml.append("<min-eviction-check-millis>").append(m.getMinEvictionCheckMillis()).append("</min-eviction-check-millis>");
            xml.append("<merge-policy>").append(m.getMergePolicy()).append("</merge-policy>");
            xml.append("<read-backup-data>").append(m.isReadBackupData()).append("</read-backup-data>");
            this.appendHotRestartConfig(xml, m.getHotRestartConfig());
            xml.append("<statistics-enabled>").append(m.isStatisticsEnabled()).append("</statistics-enabled>");
            this.mapStoreConfigXmlGenerator(xml, m);
            this.mapNearCacheConfigXmlGenerator(xml, m.getNearCacheConfig());
            this.wanReplicationConfigXmlGenerator(xml, m.getWanReplicationRef());
            this.mapIndexConfigXmlGenerator(xml, m);
            this.mapAttributeConfigXmlGenerator(xml, m);
            this.mapEntryListenerConfigXmlGenerator(xml, m);
            this.mapPartitionLostListenerConfigXmlGenerator(xml, m);
            this.mapPartitionStrategyConfigXmlGenerator(xml, m);
            xml.append("</map>");
        }
    }

    private void appendHotRestartConfig(StringBuilder xml, HotRestartConfig m) {
        xml.append("<hot-restart enabled=\"").append(m != null && m.isEnabled()).append("\">").append("<fsync>").append(m != null && m.isFsync()).append("</fsync>").append("</hot-restart>");
    }

    private void cacheConfigXmlGenerator(StringBuilder xml, Config config) {
        for (CacheSimpleConfig c : config.getCacheConfigs().values()) {
            xml.append("<cache name=\"").append(c.getName()).append("\">");
            xml.append("<in-memory-format>").append((Object)c.getInMemoryFormat()).append("</in-memory-format>");
            xml.append("<key-type class-name=\"").append(c.getKeyType()).append("\"/>");
            xml.append("<value-type class-name=\"").append(c.getValueType()).append("\"/>");
            xml.append("<statistics-enabled>").append(c.isStatisticsEnabled()).append("</statistics-enabled>");
            xml.append("<management-enabled>").append(c.isManagementEnabled()).append("</management-enabled>");
            xml.append("<backup-count>").append(c.getBackupCount()).append("</backup-count>");
            xml.append("<async-backup-count>").append(c.getAsyncBackupCount()).append("</async-backup-count>");
            this.appendHotRestartConfig(xml, c.getHotRestartConfig());
            xml.append("<read-through>").append(c.isReadThrough()).append("</read-through>");
            xml.append("<write-through>").append(c.isWriteThrough()).append("</write-through>");
            this.checkAndFillCacheLoaderFactoryConfigXml(xml, c.getCacheLoaderFactory());
            this.checkAndFillCacheWriterFactoryConfigXml(xml, c.getCacheWriterFactory());
            this.cacheExpiryPolicyFactoryConfigXmlGenerator(xml, c.getExpiryPolicyFactoryConfig());
            xml.append("<cache-entry-listeners>");
            for (CacheSimpleEntryListenerConfig el : c.getCacheEntryListeners()) {
                xml.append("<cache-entry-listener").append(" old-value-required=\"").append(el.isOldValueRequired()).append("\"").append(" synchronous=\"").append(el.isSynchronous()).append("\"").append(">");
                xml.append("<cache-entry-listener-factory class-name=\"").append(el.getCacheEntryListenerFactory()).append("\"/>");
                xml.append("<cache-entry-event-filter-factory class-name=\"").append(el.getCacheEntryEventFilterFactory()).append("\"/>");
                xml.append("</cache-entry-listener>");
            }
            xml.append("</cache-entry-listeners>");
            this.wanReplicationConfigXmlGenerator(xml, c.getWanReplicationRef());
            this.cachePartitionLostListenerConfigXmlGenerator(xml, c.getPartitionLostListenerConfigs());
            this.evictionConfigXmlGenerator(xml, c.getEvictionConfig());
            if (c.getQuorumName() != null) {
                xml.append("<quorum-ref>").append(c.getQuorumName()).append("</quorum-ref>");
            }
            if (c.getMergePolicy() != null) {
                xml.append("<merge-policy>").append(c.getMergePolicy()).append("</merge-policy>");
            }
            xml.append("<disable-per-entry-invalidation-events>").append(c.isDisablePerEntryInvalidationEvents()).append("</disable-per-entry-invalidation-events>");
            xml.append("</cache>");
        }
    }

    private void checkAndFillCacheWriterFactoryConfigXml(StringBuilder xml, String cacheWriter) {
        if (!StringUtil.isNullOrEmpty(cacheWriter)) {
            xml.append("<cache-writer-factory class-name=\"").append(cacheWriter).append("\"/>");
        }
    }

    private void checkAndFillCacheLoaderFactoryConfigXml(StringBuilder xml, String cacheLoader) {
        if (!StringUtil.isNullOrEmpty(cacheLoader)) {
            xml.append("<cache-loader-factory class-name=\"").append(cacheLoader).append("\"/>");
        }
    }

    private void cacheExpiryPolicyFactoryConfigXmlGenerator(StringBuilder xml, CacheSimpleConfig.ExpiryPolicyFactoryConfig expiryPolicyFactoryConfig) {
        if (expiryPolicyFactoryConfig != null) {
            if (!StringUtil.isNullOrEmpty(expiryPolicyFactoryConfig.getClassName())) {
                xml.append("<expiry-policy-factory class-name=\"").append(expiryPolicyFactoryConfig.getClassName()).append("\"/>");
            } else {
                CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedExpiryPolicyFactoryConfig = expiryPolicyFactoryConfig.getTimedExpiryPolicyFactoryConfig();
                if (timedExpiryPolicyFactoryConfig != null && timedExpiryPolicyFactoryConfig.getExpiryPolicyType() != null && timedExpiryPolicyFactoryConfig.getDurationConfig() != null) {
                    CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType expiryPolicyType = timedExpiryPolicyFactoryConfig.getExpiryPolicyType();
                    CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig durationConfig = timedExpiryPolicyFactoryConfig.getDurationConfig();
                    xml.append("<expiry-policy-factory>");
                    xml.append("<timed-expiry-policy-factory").append(" expiry-policy-type=\"").append(expiryPolicyType.name()).append("\"").append(" duration-amount=\"").append(durationConfig.getDurationAmount()).append("\"").append(" time-unit=\"").append(durationConfig.getTimeUnit().name()).append("\"/>");
                    xml.append("</expiry-policy-factory>");
                }
            }
        }
    }

    private void cachePartitionLostListenerConfigXmlGenerator(StringBuilder xml, List<CachePartitionLostListenerConfig> configs) {
        if (!configs.isEmpty()) {
            xml.append("<partition-lost-listeners>");
            for (CachePartitionLostListenerConfig c : configs) {
                xml.append("<partition-lost-listener>");
                String clazz = c.getImplementation() != null ? c.getImplementation().getClass().getName() : c.getClassName();
                xml.append(clazz);
                xml.append("</partition-lost-listener>");
            }
            xml.append("</partition-lost-listeners>");
        }
    }

    private void mapPartitionStrategyConfigXmlGenerator(StringBuilder xml, MapConfig m) {
        if (m.getPartitioningStrategyConfig() != null) {
            xml.append("<partition-strategy>");
            PartitioningStrategyConfig psc = m.getPartitioningStrategyConfig();
            if (psc.getPartitioningStrategy() != null) {
                xml.append(psc.getPartitioningStrategy().getClass().getName());
            } else {
                xml.append(psc.getPartitioningStrategyClass());
            }
            xml.append("</partition-strategy>");
        }
    }

    private void mapEntryListenerConfigXmlGenerator(StringBuilder xml, MapConfig m) {
        if (!m.getEntryListenerConfigs().isEmpty()) {
            xml.append("<entry-listeners>");
            for (EntryListenerConfig lc : m.getEntryListenerConfigs()) {
                xml.append("<entry-listener include-value=\"").append(lc.isIncludeValue()).append("\" local=\"").append(lc.isLocal()).append("\">");
                String clazz = lc.getImplementation() != null ? lc.getImplementation().getClass().getName() : lc.getClassName();
                xml.append(clazz);
                xml.append("</entry-listener>");
            }
            xml.append("</entry-listeners>");
        }
    }

    private void mapPartitionLostListenerConfigXmlGenerator(StringBuilder xml, MapConfig m) {
        if (!m.getPartitionLostListenerConfigs().isEmpty()) {
            xml.append("<partition-lost-listeners>");
            for (MapPartitionLostListenerConfig c : m.getPartitionLostListenerConfigs()) {
                xml.append("<partition-lost-listener>");
                String clazz = c.getImplementation() != null ? c.getImplementation().getClass().getName() : c.getClassName();
                xml.append(clazz);
                xml.append("</partition-lost-listener>");
            }
            xml.append("</partition-lost-listeners>");
        }
    }

    private void mapIndexConfigXmlGenerator(StringBuilder xml, MapConfig m) {
        if (!m.getMapIndexConfigs().isEmpty()) {
            xml.append("<indexes>");
            for (MapIndexConfig indexCfg : m.getMapIndexConfigs()) {
                xml.append("<index ordered=\"").append(indexCfg.isOrdered()).append("\">");
                xml.append(indexCfg.getAttribute());
                xml.append("</index>");
            }
            xml.append("</indexes>");
        }
    }

    private void mapAttributeConfigXmlGenerator(StringBuilder xml, MapConfig m) {
        if (!m.getMapAttributeConfigs().isEmpty()) {
            xml.append("<attributes>");
            for (MapAttributeConfig attributeCfg : m.getMapAttributeConfigs()) {
                xml.append("<attribute extractor=\"").append(attributeCfg.getExtractor()).append("\">");
                xml.append(attributeCfg.getName());
                xml.append("</attribute>");
            }
            xml.append("</attributes>");
        }
    }

    private void wanReplicationConfigXmlGenerator(StringBuilder xml, WanReplicationRef wan) {
        if (wan != null) {
            xml.append("<wan-replication-ref name=\"").append(wan.getName()).append("\">");
            xml.append("<merge-policy>").append(wan.getMergePolicy()).append("</merge-policy>");
            xml.append("<republishing-enabled>").append(wan.isRepublishingEnabled()).append("</republishing-enabled>");
            xml.append("</wan-replication-ref>");
        }
    }

    private void mapStoreConfigXmlGenerator(StringBuilder xml, MapConfig m) {
        if (m.getMapStoreConfig() != null) {
            String factoryClass;
            MapStoreConfig s = m.getMapStoreConfig();
            xml.append("<map-store enabled=\"").append(s.isEnabled()).append("\">");
            String clazz = s.getImplementation() != null ? s.getImplementation().getClass().getName() : s.getClassName();
            xml.append("<class-name>").append(clazz).append("</class-name>");
            String string = factoryClass = s.getFactoryImplementation() != null ? s.getFactoryImplementation().getClass().getName() : s.getFactoryClassName();
            if (factoryClass != null) {
                xml.append("<factory-class-name>").append(factoryClass).append("</factory-class-name>");
            }
            xml.append("<write-delay-seconds>").append(s.getWriteDelaySeconds()).append("</write-delay-seconds>");
            xml.append("<write-batch-size>").append(s.getWriteBatchSize()).append("</write-batch-size>");
            this.appendProperties(xml, s.getProperties());
            xml.append("</map-store>");
        }
    }

    private void mapNearCacheConfigXmlGenerator(StringBuilder xml, NearCacheConfig n) {
        if (n != null) {
            xml.append("<near-cache>");
            xml.append("<max-size>").append(n.getMaxSize()).append("</max-size>");
            xml.append("<time-to-live-seconds>").append(n.getTimeToLiveSeconds()).append("</time-to-live-seconds>");
            xml.append("<max-idle-seconds>").append(n.getMaxIdleSeconds()).append("</max-idle-seconds>");
            xml.append("<eviction-policy>").append(n.getEvictionPolicy()).append("</eviction-policy>");
            xml.append("<invalidate-on-change>").append(n.isInvalidateOnChange()).append("</invalidate-on-change>");
            xml.append("<in-memory-format>").append((Object)n.getInMemoryFormat()).append("</in-memory-format>");
            this.evictionConfigXmlGenerator(xml, n.getEvictionConfig());
            xml.append("</near-cache>");
        }
    }

    private void evictionConfigXmlGenerator(StringBuilder xml, EvictionConfig e) {
        if (e != null) {
            xml.append("<eviction").append(" size=\"").append(e.getSize()).append("\"").append(" max-size-policy=\"").append((Object)e.getMaximumSizePolicy()).append("\"").append(" eviction-policy=\"").append((Object)e.getEvictionPolicy()).append("\"");
            if (!StringUtil.isNullOrEmpty(e.getComparatorClassName())) {
                xml.append(" comparator-class-name=\"").append(e.getComparatorClassName()).append("\"");
            }
            xml.append("/>");
        }
    }

    private void multicastConfigXmlGenerator(StringBuilder xml, JoinConfig join) {
        MulticastConfig mcast = join.getMulticastConfig();
        xml.append("<multicast enabled=\"").append(mcast.isEnabled()).append("\" loopbackModeEnabled=\"");
        xml.append(mcast.isLoopbackModeEnabled()).append("\">");
        xml.append("<multicast-group>").append(mcast.getMulticastGroup()).append("</multicast-group>");
        xml.append("<multicast-port>").append(mcast.getMulticastPort()).append("</multicast-port>");
        xml.append("<multicast-timeout-seconds>").append(mcast.getMulticastTimeoutSeconds()).append("</multicast-timeout-seconds>");
        xml.append("<multicast-time-to-live>").append(mcast.getMulticastTimeToLive()).append("</multicast-time-to-live>");
        if (!mcast.getTrustedInterfaces().isEmpty()) {
            xml.append("<trusted-interfaces>");
            for (String trustedInterface : mcast.getTrustedInterfaces()) {
                xml.append("<interface>").append(trustedInterface).append("</interface>");
            }
            xml.append("</trusted-interfaces>");
        }
        xml.append("</multicast>");
    }

    private void tcpConfigXmlGenerator(StringBuilder xml, JoinConfig join) {
        TcpIpConfig tcpCfg = join.getTcpIpConfig();
        xml.append("<tcp-ip enabled=\"").append(tcpCfg.isEnabled()).append("\">");
        List<String> members = tcpCfg.getMembers();
        xml.append("<member-list>");
        for (String m : members) {
            xml.append("<member>").append(m).append("</member>");
        }
        xml.append("</member-list>");
        if (tcpCfg.getRequiredMember() != null) {
            xml.append("<required-member>").append(tcpCfg.getRequiredMember()).append("</required-member>");
        }
        xml.append("</tcp-ip>");
    }

    private void awsConfigXmlGenerator(StringBuilder xml, JoinConfig join) {
        AwsConfig awsConfig = join.getAwsConfig();
        xml.append("<aws enabled=\"").append(awsConfig.isEnabled()).append("\">");
        xml.append("<access-key>").append(awsConfig.getAccessKey()).append("</access-key>");
        xml.append("<secret-key>").append(awsConfig.getSecretKey()).append("</secret-key>");
        xml.append("<region>").append(awsConfig.getRegion()).append("</region>");
        xml.append("<security-group-name>").append(awsConfig.getSecurityGroupName()).append("</security-group-name>");
        xml.append("<tag-key>").append(awsConfig.getTagKey()).append("</tag-key>");
        xml.append("<tag-value>").append(awsConfig.getTagValue()).append("</tag-value>");
        xml.append("</aws>");
    }

    private void interfacesConfigXmlGenerator(StringBuilder xml, NetworkConfig netCfg) {
        InterfacesConfig interfaces = netCfg.getInterfaces();
        xml.append("<interfaces enabled=\"").append(interfaces.isEnabled()).append("\">");
        Collection<String> interfaceList = interfaces.getInterfaces();
        for (String i : interfaceList) {
            xml.append("<interface>").append(i).append("</interface>");
        }
        xml.append("</interfaces>");
    }

    private void sslConfigXmlGenerator(StringBuilder xml, NetworkConfig netCfg) {
        SSLConfig ssl = netCfg.getSSLConfig();
        xml.append("<ssl enabled=\"").append(ssl != null && ssl.isEnabled()).append("\">");
        if (ssl != null) {
            String className = ssl.getFactoryImplementation() != null ? ssl.getFactoryImplementation().getClass().getName() : ssl.getFactoryClassName();
            xml.append("<factory-class-name>").append(className).append("</factory-class-name>");
            this.appendProperties(xml, ssl.getProperties());
        }
        xml.append("</ssl>");
    }

    private void socketInterceptorConfigXmlGenerator(StringBuilder xml, NetworkConfig netCfg) {
        SocketInterceptorConfig socket = netCfg.getSocketInterceptorConfig();
        xml.append("<socket-interceptor enabled=\"").append(socket != null && socket.isEnabled()).append("\">");
        if (socket != null) {
            String className = socket.getImplementation() != null ? socket.getImplementation().getClass().getName() : socket.getClassName();
            xml.append("<class-name>").append(className).append("</class-name>");
            this.appendProperties(xml, socket.getProperties());
        }
        xml.append("</socket-interceptor>");
    }

    private void symmetricEncInterceptorConfigXmlGenerator(StringBuilder xml, NetworkConfig netCfg) {
        SymmetricEncryptionConfig sec = netCfg.getSymmetricEncryptionConfig();
        if (sec != null) {
            xml.append("<symmetric-encryption enabled=\"").append(sec.isEnabled()).append("\">");
            xml.append("<algorithm>").append(sec.getAlgorithm()).append("</algorithm>");
            xml.append("<salt>").append(sec.getSalt()).append("</salt>");
            xml.append("<password>").append(sec.getPassword()).append("</password>");
            xml.append("<iteration-count>").append(sec.getIterationCount()).append("</iteration-count>");
            xml.append("</symmetric-encryption>");
        }
    }

    private void hotRestartXmlGenerator(StringBuilder xml, Config config) {
        HotRestartPersistenceConfig hrCfg = config.getHotRestartPersistenceConfig();
        if (hrCfg == null) {
            xml.append("<hot-restart-persistence enabled=\"false\" />");
            return;
        }
        xml.append("<hot-restart-persistence enabled=\"").append(hrCfg.isEnabled()).append("\">");
        ConfigXmlGenerator.appendNode(xml, "base-dir", hrCfg.getBaseDir().getAbsolutePath());
        if (hrCfg.getBackupDir() != null) {
            ConfigXmlGenerator.appendNode(xml, "backup-dir", hrCfg.getBackupDir().getAbsolutePath());
        }
        ConfigXmlGenerator.appendNode(xml, "parallelism", hrCfg.getParallelism());
        ConfigXmlGenerator.appendNode(xml, "validation-timeout-seconds", hrCfg.getValidationTimeoutSeconds());
        ConfigXmlGenerator.appendNode(xml, "data-load-timeout-seconds", hrCfg.getDataLoadTimeoutSeconds());
        ConfigXmlGenerator.appendNode(xml, "cluster-data-recovery-policy", (Object)hrCfg.getClusterDataRecoveryPolicy());
        xml.append("</hot-restart-persistence>");
    }

    private void liteMemberXmlGenerator(StringBuilder xml, Config config) {
        xml.append("<lite-member enabled=\"").append(config.isLiteMember()).append("\"/>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String format(String input, int indent) {
        if (!this.formatted) {
            return input;
        }
        StreamResult xmlOutput = null;
        try {
            String response;
            Transformer transformer;
            StreamSource xmlInput;
            block12: {
                TransformerFactory transformerFactory;
                block11: {
                    xmlInput = new StreamSource(new StringReader(input));
                    xmlOutput = new StreamResult(new StringWriter());
                    transformerFactory = TransformerFactory.newInstance();
                    try {
                        transformerFactory.setAttribute("indent-number", indent);
                    }
                    catch (IllegalArgumentException e) {
                        if (!LOGGER.isFinestEnabled()) break block11;
                        LOGGER.finest("Failed to set indent-number attribute; cause: " + e.getMessage());
                    }
                }
                transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                try {
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
                }
                catch (IllegalArgumentException e) {
                    if (!LOGGER.isFinestEnabled()) break block12;
                    LOGGER.finest("Failed to set indent-amount property; cause: " + e.getMessage());
                }
            }
            transformer.transform(xmlInput, xmlOutput);
            String string = response = xmlOutput.getWriter().toString();
            return string;
        }
        catch (Exception e) {
            LOGGER.warning(e);
            String string = input;
            return string;
        }
        finally {
            if (xmlOutput != null) {
                IOUtil.closeResource(xmlOutput.getWriter());
            }
        }
    }

    private static void appendNode(StringBuilder xml, String name, Object value) {
        if (value != null) {
            xml.append('<').append(name).append('>').append(value).append("</").append(name).append('>');
        }
    }

    private void appendProperties(StringBuilder xml, Properties props) {
        if (!props.isEmpty()) {
            xml.append("<properties>");
            Set<Object> keys = props.keySet();
            for (Object key : keys) {
                xml.append("<property name=\"").append(key).append("\">").append(props.getProperty(key.toString())).append("</property>");
            }
            xml.append("</properties>");
        }
    }
}

