/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.impl.BinaryInterface;
import com.hazelcast.spi.annotation.Beta;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.io.Serializable;

@Beta
@BinaryInterface
public class NearCachePreloaderConfig
implements DataSerializable,
Serializable {
    public static final int DEFAULT_STORE_INITIAL_DELAY_SECONDS = 600;
    public static final int DEFAULT_STORE_INTERVAL_SECONDS = 600;
    private boolean enabled;
    private String fileName = "";
    private int storeInitialDelaySeconds = 600;
    private int storeIntervalSeconds = 600;
    private NearCachePreloaderConfig readOnly;

    public NearCachePreloaderConfig() {
    }

    public NearCachePreloaderConfig(NearCachePreloaderConfig nearCachePreloaderConfig) {
        this(nearCachePreloaderConfig.enabled, nearCachePreloaderConfig.fileName);
    }

    public NearCachePreloaderConfig(String fileName) {
        this(true, fileName);
    }

    public NearCachePreloaderConfig(boolean enabled, String fileName) {
        this.enabled = enabled;
        this.fileName = Preconditions.checkNotNull(fileName, "fileName cannot be null!");
    }

    NearCachePreloaderConfig getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new NearCachePreloaderConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public NearCachePreloaderConfig setEnabled(boolean isEnabled) {
        this.enabled = isEnabled;
        return this;
    }

    public NearCachePreloaderConfig setFileName(String fileName) {
        this.fileName = Preconditions.checkNotNull(fileName, "fileName cannot be null!");
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getStoreInitialDelaySeconds() {
        return this.storeInitialDelaySeconds;
    }

    public NearCachePreloaderConfig setStoreInitialDelaySeconds(int storeInitialDelaySeconds) {
        this.storeInitialDelaySeconds = Preconditions.checkPositive(storeInitialDelaySeconds, "storeInitialDelaySeconds must be a positive number!");
        return this;
    }

    public int getStoreIntervalSeconds() {
        return this.storeIntervalSeconds;
    }

    public NearCachePreloaderConfig setStoreIntervalSeconds(int storeIntervalSeconds) {
        this.storeIntervalSeconds = Preconditions.checkPositive(storeIntervalSeconds, "storeIntervalSeconds must be a positive number!");
        return this;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeUTF(this.fileName);
        out.writeInt(this.storeInitialDelaySeconds);
        out.writeInt(this.storeIntervalSeconds);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.enabled = in.readBoolean();
        this.fileName = in.readUTF();
        this.storeInitialDelaySeconds = in.readInt();
        this.storeIntervalSeconds = in.readInt();
    }

    public String toString() {
        return "NearCachePreloaderConfig{enabled=" + this.enabled + ", fileName=" + this.fileName + ", storeInitialDelaySeconds=" + this.storeInitialDelaySeconds + ", storeIntervalSeconds=" + this.storeIntervalSeconds + '}';
    }

    @Beta
    @PrivateApi
    @BinaryInterface
    private static class NearCachePreloaderConfigReadOnly
    extends NearCachePreloaderConfig {
        NearCachePreloaderConfigReadOnly(NearCachePreloaderConfig nearCachePreloaderConfig) {
            super(nearCachePreloaderConfig);
        }

        @Override
        public NearCachePreloaderConfig setEnabled(boolean isEnabled) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NearCachePreloaderConfig setFileName(String fileName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NearCachePreloaderConfig setStoreInitialDelaySeconds(int storeInitialDelaySeconds) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NearCachePreloaderConfig setStoreIntervalSeconds(int storeIntervalSeconds) {
            throw new UnsupportedOperationException();
        }
    }
}

