/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfigReadOnly;
import com.hazelcast.util.Preconditions;
import java.util.ArrayList;
import java.util.List;

public class QueryCacheConfig {
    public static final int DEFAULT_BATCH_SIZE = 1;
    public static final int DEFAULT_BUFFER_SIZE = 16;
    public static final int DEFAULT_DELAY_SECONDS = 0;
    public static final boolean DEFAULT_INCLUDE_VALUE = true;
    public static final boolean DEFAULT_POPULATE = true;
    public static final boolean DEFAULT_COALESCE = false;
    public static final InMemoryFormat DEFAULT_IN_MEMORY_FORMAT = InMemoryFormat.BINARY;
    private int batchSize = 1;
    private int bufferSize = 16;
    private int delaySeconds = 0;
    private boolean includeValue = true;
    private boolean populate = true;
    private boolean coalesce = false;
    private InMemoryFormat inMemoryFormat = DEFAULT_IN_MEMORY_FORMAT;
    private String name;
    private PredicateConfig predicateConfig = new PredicateConfig();
    private EvictionConfig evictionConfig = new EvictionConfig();
    private List<EntryListenerConfig> entryListenerConfigs;
    private List<MapIndexConfig> indexConfigs;
    private QueryCacheConfigReadOnly readOnly;

    public QueryCacheConfig() {
    }

    public QueryCacheConfig(String name) {
        this.setName(name);
    }

    public QueryCacheConfig(QueryCacheConfig other) {
        this.batchSize = other.batchSize;
        this.bufferSize = other.bufferSize;
        this.delaySeconds = other.delaySeconds;
        this.includeValue = other.includeValue;
        this.populate = other.populate;
        this.coalesce = other.coalesce;
        this.inMemoryFormat = other.inMemoryFormat;
        this.name = other.name;
        this.predicateConfig = other.predicateConfig;
        this.evictionConfig = other.evictionConfig;
        this.entryListenerConfigs = other.entryListenerConfigs;
        this.indexConfigs = other.indexConfigs;
    }

    public QueryCacheConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new QueryCacheConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public String getName() {
        return this.name;
    }

    public QueryCacheConfig setName(String name) {
        Preconditions.checkHasText(name, "name");
        this.name = name;
        return this;
    }

    public PredicateConfig getPredicateConfig() {
        return this.predicateConfig;
    }

    public QueryCacheConfig setPredicateConfig(PredicateConfig predicateConfig) {
        this.predicateConfig = Preconditions.checkNotNull(predicateConfig, "predicateConfig can not be null");
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public QueryCacheConfig setBatchSize(int batchSize) {
        Preconditions.checkPositive(batchSize, "batchSize");
        this.batchSize = batchSize;
        return this;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public QueryCacheConfig setBufferSize(int bufferSize) {
        Preconditions.checkPositive(bufferSize, "bufferSize");
        this.bufferSize = bufferSize;
        return this;
    }

    public int getDelaySeconds() {
        return this.delaySeconds;
    }

    public QueryCacheConfig setDelaySeconds(int delaySeconds) {
        Preconditions.checkNotNegative(delaySeconds, "delaySeconds");
        this.delaySeconds = delaySeconds;
        return this;
    }

    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    public QueryCacheConfig setInMemoryFormat(InMemoryFormat inMemoryFormat) {
        Preconditions.checkNotNull(inMemoryFormat, "inMemoryFormat cannot be null");
        Preconditions.checkFalse(inMemoryFormat == InMemoryFormat.NATIVE, "InMemoryFormat." + (Object)((Object)inMemoryFormat) + " is not supported.");
        this.inMemoryFormat = inMemoryFormat;
        return this;
    }

    public boolean isIncludeValue() {
        return this.includeValue;
    }

    public QueryCacheConfig setIncludeValue(boolean includeValue) {
        this.includeValue = includeValue;
        return this;
    }

    public boolean isPopulate() {
        return this.populate;
    }

    public QueryCacheConfig setPopulate(boolean populate) {
        this.populate = populate;
        return this;
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public void setCoalesce(boolean coalesce) {
        this.coalesce = coalesce;
    }

    public EvictionConfig getEvictionConfig() {
        return this.evictionConfig;
    }

    public QueryCacheConfig setEvictionConfig(EvictionConfig evictionConfig) {
        Preconditions.checkNotNull(evictionConfig, "evictionConfig cannot be null");
        this.evictionConfig = evictionConfig;
        return this;
    }

    public QueryCacheConfig addEntryListenerConfig(EntryListenerConfig listenerConfig) {
        Preconditions.checkNotNull(listenerConfig, "listenerConfig cannot be null");
        this.getEntryListenerConfigs().add(listenerConfig);
        return this;
    }

    public List<EntryListenerConfig> getEntryListenerConfigs() {
        if (this.entryListenerConfigs == null) {
            this.entryListenerConfigs = new ArrayList<EntryListenerConfig>();
        }
        return this.entryListenerConfigs;
    }

    public QueryCacheConfig setEntryListenerConfigs(List<EntryListenerConfig> listenerConfigs) {
        Preconditions.checkNotNull(listenerConfigs, "listenerConfig cannot be null");
        this.entryListenerConfigs = listenerConfigs;
        return this;
    }

    public QueryCacheConfig addIndexConfig(MapIndexConfig mapIndexConfig) {
        this.getIndexConfigs().add(mapIndexConfig);
        return this;
    }

    public List<MapIndexConfig> getIndexConfigs() {
        if (this.indexConfigs == null) {
            this.indexConfigs = new ArrayList<MapIndexConfig>();
        }
        return this.indexConfigs;
    }

    public QueryCacheConfig setIndexConfigs(List<MapIndexConfig> indexConfigs) {
        this.indexConfigs = indexConfigs;
        return this;
    }

    public String toString() {
        return "QueryCacheConfig{batchSize=" + this.batchSize + ", bufferSize=" + this.bufferSize + ", delaySeconds=" + this.delaySeconds + ", includeValue=" + this.includeValue + ", populate=" + this.populate + ", coalesce=" + this.coalesce + ", inMemoryFormat=" + (Object)((Object)this.inMemoryFormat) + ", name='" + this.name + '\'' + ", predicateConfig=" + this.predicateConfig + ", evictionConfig=" + this.evictionConfig + ", entryListenerConfigs=" + this.entryListenerConfigs + ", indexConfigs=" + this.indexConfigs + '}';
    }
}

