/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.util.Preconditions;

public class ScheduledExecutorConfig {
    private static final int DEFAULT_POOL_SIZE = 16;
    private static final int DEFAULT_DURABILITY = 1;
    private String name = "default";
    private int durability = 1;
    private int poolSize = 16;
    private ScheduledExecutorConfigReadOnly readOnly;

    public ScheduledExecutorConfig() {
    }

    public ScheduledExecutorConfig(String name) {
        this.name = name;
    }

    public ScheduledExecutorConfig(String name, int durability, int poolSize) {
        this.name = name;
        this.durability = durability;
        this.poolSize = poolSize;
    }

    public ScheduledExecutorConfig(ScheduledExecutorConfig config) {
        this(config.getName(), config.getDurability(), config.getPoolSize());
    }

    public ScheduledExecutorConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new ScheduledExecutorConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public String getName() {
        return this.name;
    }

    public ScheduledExecutorConfig setName(String name) {
        this.name = name;
        return this;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public ScheduledExecutorConfig setPoolSize(int poolSize) {
        Preconditions.checkPositive(poolSize, "Pool size should be greater than 0");
        this.poolSize = poolSize;
        return this;
    }

    public int getDurability() {
        return this.durability;
    }

    public ScheduledExecutorConfig setDurability(int durability) {
        Preconditions.checkNotNegative(durability, "durability can't be smaller than 0");
        this.durability = durability;
        return this;
    }

    public String toString() {
        return "ScheduledExecutorConfig{name='" + this.name + '\'' + ", durability=" + this.durability + ", poolSize-" + this.poolSize + '}';
    }

    private static class ScheduledExecutorConfigReadOnly
    extends ScheduledExecutorConfig {
        public ScheduledExecutorConfigReadOnly(ScheduledExecutorConfig config) {
            super(config);
        }

        @Override
        public ScheduledExecutorConfig setName(String name) {
            throw new UnsupportedOperationException("This config is read-only scheduled executor: " + this.getName());
        }

        @Override
        public ScheduledExecutorConfig setDurability(int durability) {
            throw new UnsupportedOperationException("This config is read-only scheduled executor: " + this.getName());
        }

        @Override
        public ScheduledExecutorConfig setPoolSize(int poolSize) {
            throw new UnsupportedOperationException("This config is read-only scheduled executor: " + this.getName());
        }
    }
}

