/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.config.WanPublisherConfig;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WanReplicationConfig
implements DataSerializable {
    private String name;
    private WanConsumerConfig wanConsumerConfig;
    private List<WanPublisherConfig> wanPublisherConfigs = new ArrayList<WanPublisherConfig>(2);

    public String getName() {
        return this.name;
    }

    public WanReplicationConfig setName(String name) {
        this.name = name;
        return this;
    }

    public WanConsumerConfig getWanConsumerConfig() {
        return this.wanConsumerConfig;
    }

    public WanReplicationConfig setWanConsumerConfig(WanConsumerConfig wanConsumerConfig) {
        this.wanConsumerConfig = wanConsumerConfig;
        return this;
    }

    public void setWanPublisherConfigs(List<WanPublisherConfig> wanPublisherConfigs) {
        if (wanPublisherConfigs != null && !wanPublisherConfigs.isEmpty()) {
            this.wanPublisherConfigs = wanPublisherConfigs;
        }
    }

    public List<WanPublisherConfig> getWanPublisherConfigs() {
        return this.wanPublisherConfigs;
    }

    public WanReplicationConfig addWanPublisherConfig(WanPublisherConfig wanPublisherConfig) {
        this.wanPublisherConfigs.add(wanPublisherConfig);
        return this;
    }

    public String toString() {
        return "WanReplicationConfig{name='" + this.name + '\'' + ", wanPublisherConfigs=" + this.wanPublisherConfigs + '}';
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        if (this.wanConsumerConfig != null) {
            out.writeBoolean(true);
            this.wanConsumerConfig.writeData(out);
        } else {
            out.writeBoolean(false);
        }
        int publisherCount = this.wanPublisherConfigs.size();
        out.writeInt(publisherCount);
        for (WanPublisherConfig wanPublisherConfig : this.wanPublisherConfigs) {
            wanPublisherConfig.writeData(out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        boolean consumerConfigExists = in.readBoolean();
        if (consumerConfigExists) {
            WanConsumerConfig consumerConfig = new WanConsumerConfig();
            consumerConfig.readData(in);
            this.wanConsumerConfig = consumerConfig;
        }
        int publisherCount = in.readInt();
        for (int i = 0; i < publisherCount; ++i) {
            WanPublisherConfig publisherConfig = new WanPublisherConfig();
            publisherConfig.readData(in);
            this.wanPublisherConfigs.add(publisherConfig);
        }
    }
}

