/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.instance.BuildInfo;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.EmptyStatement;
import java.io.InputStream;
import java.util.Properties;

public final class BuildInfoProvider {
    public static final BuildInfo BUILD_INFO;
    private static final ILogger LOGGER;

    private BuildInfoProvider() {
    }

    public static BuildInfo getBuildInfo() {
        InputStream inRuntimeProperties = BuildInfoProvider.class.getClassLoader().getResourceAsStream("hazelcast-runtime.properties");
        Properties runtimeProperties = new Properties();
        try {
            if (inRuntimeProperties != null) {
                runtimeProperties.load(inRuntimeProperties);
            }
        }
        catch (Exception ignored) {
            EmptyStatement.ignore(ignored);
        }
        finally {
            IOUtil.closeResource(inRuntimeProperties);
        }
        String version = runtimeProperties.getProperty("hazelcast.version");
        String distribution = runtimeProperties.getProperty("hazelcast.distribution");
        String revision = runtimeProperties.getProperty("hazelcast.git.revision", "");
        if (!revision.isEmpty() && revision.equals("${git.commit.id.abbrev}")) {
            revision = "";
        }
        boolean enterprise = !"Hazelcast".equals(distribution);
        Integer hazelcastBuild = Integer.getInteger("hazelcast.build", -1);
        String build = hazelcastBuild == -1 ? runtimeProperties.getProperty("hazelcast.build") : String.valueOf(hazelcastBuild);
        int buildNumber = Integer.parseInt(build);
        String overridingVersion = System.getProperty("hazelcast.internal.override.version");
        if (overridingVersion != null) {
            LOGGER.info("Overriding hazelcast version with system property value " + overridingVersion);
            version = overridingVersion;
        }
        String sv = runtimeProperties.getProperty("hazelcast.serialization.version");
        byte serialVersion = Byte.parseByte(sv);
        return new BuildInfo(version, build, revision, buildNumber, enterprise, serialVersion);
    }

    static {
        LOGGER = Logger.getLogger(BuildInfoProvider.class);
        BUILD_INFO = BuildInfoProvider.getBuildInfo();
    }
}

