/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Joiner;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.Config;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeExtension;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.cluster.impl.ClusterJoinManager;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.SplitBrainJoinMessage;
import com.hazelcast.internal.cluster.impl.operations.MemberRemoveOperation;
import com.hazelcast.internal.cluster.impl.operations.MergeClustersOperation;
import com.hazelcast.internal.cluster.impl.operations.SplitBrainMergeValidationOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.OperationResponseHandlerFactory;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.FutureUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public abstract class AbstractJoiner
implements Joiner {
    private static final int JOIN_TRY_COUNT = 5;
    private static final long MIN_WAIT_SECONDS_BEFORE_JOIN = 10L;
    private static final long SPLIT_BRAIN_CONN_TIMEOUT = 5000L;
    private static final long SPLIT_BRAIN_SLEEP_TIME = 10L;
    private static final int SPLIT_BRAIN_JOIN_CHECK_TIMEOUT_SECONDS = 10;
    private static final int SPLIT_BRAIN_MERGE_TIMEOUT_SECONDS = 30;
    protected final Config config;
    protected final Node node;
    protected final ClusterServiceImpl clusterService;
    protected final ILogger logger;
    protected final ConcurrentMap<Address, Boolean> blacklistedAddresses = new ConcurrentHashMap<Address, Boolean>();
    protected final ClusterJoinManager clusterJoinManager;
    private final AtomicLong joinStartTime = new AtomicLong(Clock.currentTimeMillis());
    private final AtomicInteger tryCount = new AtomicInteger(0);
    private final long mergeNextRunDelayMs;
    private volatile Address targetAddress;
    private final FutureUtil.ExceptionHandler splitBrainMergeExceptionHandler = new FutureUtil.ExceptionHandler(){

        @Override
        public void handleException(Throwable throwable) {
            if (throwable instanceof MemberLeftException) {
                return;
            }
            AbstractJoiner.this.logger.warning("Problem while waiting for merge operation result", throwable);
        }
    };

    public AbstractJoiner(Node node) {
        this.node = node;
        this.logger = node.loggingService.getLogger(this.getClass());
        this.config = node.config;
        this.clusterService = node.getClusterService();
        this.clusterJoinManager = this.clusterService.getClusterJoinManager();
        this.mergeNextRunDelayMs = node.getProperties().getMillis(GroupProperty.MERGE_NEXT_RUN_DELAY_SECONDS);
    }

    @Override
    public final long getStartTime() {
        return this.joinStartTime.get();
    }

    @Override
    public void setTargetAddress(Address targetAddress) {
        this.targetAddress = targetAddress;
    }

    @Override
    public void blacklist(Address address, boolean permanent) {
        this.logger.info(address + " is added to the blacklist.");
        this.blacklistedAddresses.putIfAbsent(address, permanent);
    }

    @Override
    public boolean unblacklist(Address address) {
        if (this.blacklistedAddresses.remove(address, Boolean.FALSE)) {
            this.logger.info(address + " is removed from the blacklist.");
            return true;
        }
        return false;
    }

    @Override
    public boolean isBlacklisted(Address address) {
        return this.blacklistedAddresses.containsKey(address);
    }

    public abstract void doJoin();

    @Override
    public final void join() {
        this.blacklistedAddresses.clear();
        this.doJoin();
        if (!this.node.joined() && this.shouldResetHotRestartData()) {
            this.logger.warning("Could not join to the cluster because hot restart data must be reset.");
            NodeExtension nodeExtension = this.node.getNodeExtension();
            nodeExtension.resetHotRestartData();
            this.reset();
            this.doJoin();
        }
        this.postJoin();
    }

    protected final boolean shouldRetry() {
        return this.node.isRunning() && !this.node.joined() && !this.shouldResetHotRestartData();
    }

    private boolean shouldResetHotRestartData() {
        NodeExtension nodeExtension = this.node.getNodeExtension();
        return !nodeExtension.isStartCompleted() && nodeExtension.isMemberExcluded(this.node.getThisAddress(), this.node.getThisUuid());
    }

    private void postJoin() {
        this.blacklistedAddresses.clear();
        if (this.logger.isFineEnabled()) {
            this.logger.fine("PostJoin master: " + this.node.getMasterAddress() + ", isMaster: " + this.node.isMaster());
        }
        if (!this.node.isRunning()) {
            return;
        }
        if (this.tryCount.incrementAndGet() == 5) {
            this.logger.warning("Join try count exceed limit, setting this node as master!");
            this.node.setAsMaster();
        }
        if (this.node.joined()) {
            if (!this.node.isMaster()) {
                this.ensureConnectionToAllMembers();
            }
            if (this.clusterService.getSize() == 1) {
                this.logger.info('\n' + this.node.clusterService.membersString());
            }
        }
    }

    private void ensureConnectionToAllMembers() {
        boolean allConnected = false;
        if (this.node.joined()) {
            this.logger.fine("Waiting for all connections");
            int connectAllWaitSeconds = this.node.getProperties().getSeconds(GroupProperty.CONNECT_ALL_WAIT_SECONDS);
            int checkCount = 0;
            while (checkCount++ < connectAllWaitSeconds && !allConnected) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException ignored) {
                    EmptyStatement.ignore(ignored);
                }
                allConnected = true;
                Set<Member> members = this.clusterService.getMembers();
                for (Member member : members) {
                    if (member.localMember() || this.node.connectionManager.getOrConnect(member.getAddress()) != null) continue;
                    allConnected = false;
                    if (!this.logger.isFineEnabled()) continue;
                    this.logger.fine("Not-connected to " + member.getAddress());
                }
            }
        }
    }

    protected final long getMaxJoinMillis() {
        return this.node.getProperties().getMillis(GroupProperty.MAX_JOIN_SECONDS);
    }

    protected final long getMaxJoinTimeToMasterNode() {
        return TimeUnit.SECONDS.toMillis(10L) + this.node.getProperties().getMillis(GroupProperty.MAX_WAIT_SECONDS_BEFORE_JOIN);
    }

    protected boolean shouldMerge(SplitBrainJoinMessage joinMessage) {
        int currentDataMemberCount;
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Should merge to: " + joinMessage);
        }
        if (joinMessage == null) {
            return false;
        }
        if (!this.checkValidSplitBrainJoinMessage(joinMessage)) {
            return false;
        }
        if (!this.checkCompatibleSplitBrainJoinMessage(joinMessage)) {
            return false;
        }
        if (!this.checkMergeTargetIsNotMember(joinMessage)) {
            return false;
        }
        if (!this.checkClusterStateActiveBeforeMerge(joinMessage)) {
            return false;
        }
        if (!this.checkMembershipIntersectionSetEmpty(joinMessage)) {
            return false;
        }
        int targetDataMemberCount = joinMessage.getDataMemberCount();
        if (targetDataMemberCount > (currentDataMemberCount = this.clusterService.getSize(MemberSelectors.DATA_MEMBER_SELECTOR))) {
            this.logger.info("We are merging to " + joinMessage.getAddress() + ", because their data member count is bigger than ours [" + targetDataMemberCount + " > " + currentDataMemberCount + ']');
            return true;
        }
        if (targetDataMemberCount < currentDataMemberCount) {
            this.logger.info(joinMessage.getAddress() + " should merge to us " + ", because our data member count is bigger than theirs [" + currentDataMemberCount + " > " + targetDataMemberCount + ']');
            return false;
        }
        if (AbstractJoiner.shouldMergeTo(this.node.getThisAddress(), joinMessage.getAddress())) {
            this.logger.info("We are merging to " + joinMessage.getAddress() + ", both have the same data member count: " + currentDataMemberCount);
            return true;
        }
        this.logger.info(joinMessage.getAddress() + " should merge to us " + ", both have the same data member count: " + currentDataMemberCount);
        return false;
    }

    private boolean checkValidSplitBrainJoinMessage(SplitBrainJoinMessage joinMessage) {
        try {
            if (!this.clusterJoinManager.validateJoinMessage(joinMessage)) {
                this.logger.fine("Cannot process split brain merge message from " + joinMessage.getAddress() + ", since join-message could not be validated.");
                return false;
            }
        }
        catch (Exception e) {
            this.logger.log(Level.FINE, "failure during validating join message", e);
            return false;
        }
        return true;
    }

    private boolean checkCompatibleSplitBrainJoinMessage(SplitBrainJoinMessage joinMessage) {
        if (!this.clusterService.getClusterVersion().equals(joinMessage.getClusterVersion())) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Should not merge to " + joinMessage.getAddress() + " because other cluster version is " + joinMessage.getClusterVersion() + " while this cluster version is " + this.clusterService.getClusterVersion());
            }
            return false;
        }
        return true;
    }

    private boolean checkMergeTargetIsNotMember(SplitBrainJoinMessage joinMessage) {
        if (this.clusterService.getMember(joinMessage.getAddress()) != null) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Should not merge to " + joinMessage.getAddress() + ", because it is already member of this cluster.");
            }
            return false;
        }
        return true;
    }

    private boolean checkClusterStateActiveBeforeMerge(SplitBrainJoinMessage joinMessage) {
        ClusterState clusterState = this.clusterService.getClusterState();
        if (clusterState != ClusterState.ACTIVE) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Should not merge to " + joinMessage.getAddress() + ", because this cluster is in " + (Object)((Object)clusterState) + " state.");
            }
            return false;
        }
        return true;
    }

    private boolean checkMembershipIntersectionSetEmpty(SplitBrainJoinMessage joinMessage) {
        Collection<Address> targetMemberAddresses = joinMessage.getMemberAddresses();
        if (targetMemberAddresses.contains(this.node.getThisAddress())) {
            this.node.nodeEngine.getOperationService().send(new MemberRemoveOperation(this.node.getThisAddress()), joinMessage.getAddress());
            this.logger.info(this.node.getThisAddress() + " CANNOT merge to " + joinMessage.getAddress() + ", because it thinks this-node as its member.");
            return false;
        }
        Collection<Address> thisMemberAddresses = this.clusterService.getMemberAddresses();
        for (Address address : thisMemberAddresses) {
            if (!targetMemberAddresses.contains(address)) continue;
            this.logger.info(this.node.getThisAddress() + " CANNOT merge to " + joinMessage.getAddress() + ", because it thinks " + address + " as its member. " + "But " + address + " is member of this cluster.");
            return false;
        }
        return true;
    }

    private static boolean shouldMergeTo(Address thisAddress, Address targetAddress) {
        String targetAddressStr;
        String thisAddressStr = "[" + thisAddress.getHost() + "]:" + thisAddress.getPort();
        if (thisAddressStr.equals(targetAddressStr = "[" + targetAddress.getHost() + "]:" + targetAddress.getPort())) {
            throw new IllegalArgumentException("Addresses should be different! This: " + thisAddress + ", Target: " + targetAddress);
        }
        int result = thisAddressStr.compareTo(targetAddressStr);
        return result > 0;
    }

    protected SplitBrainJoinMessage sendSplitBrainJoinMessage(Address target) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Sending SplitBrainJoinMessage to " + target);
        }
        Connection conn = this.node.connectionManager.getOrConnect(target, true);
        long timeout = 5000L;
        while (conn == null) {
            if ((timeout -= 10L) < 0L) {
                return null;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                EmptyStatement.ignore(e);
                return null;
            }
            conn = this.node.connectionManager.getConnection(target);
        }
        NodeEngineImpl nodeEngine = this.node.nodeEngine;
        InternalCompletableFuture future = nodeEngine.getOperationService().createInvocationBuilder("hz:core:clusterService", (Operation)new SplitBrainMergeValidationOperation(this.node.createSplitBrainJoinMessage()), target).setTryCount(1).invoke();
        try {
            return (SplitBrainJoinMessage)future.get(10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            this.logger.log(Level.FINE, "Timeout during join check!", e);
        }
        catch (Exception e) {
            this.logger.warning("Error during join check!", e);
        }
        return null;
    }

    @Override
    public void reset() {
        this.joinStartTime.set(Clock.currentTimeMillis());
        this.tryCount.set(0);
    }

    protected void startClusterMerge(Address targetAddress) {
        ClusterServiceImpl clusterService = this.node.clusterService;
        if (!this.prepareClusterState(clusterService)) {
            return;
        }
        InternalOperationService operationService = this.node.nodeEngine.getOperationService();
        Set<Member> memberList = clusterService.getMembers();
        ArrayList<Future> futures = new ArrayList<Future>(memberList.size());
        for (Member member : memberList) {
            if (member.localMember()) continue;
            MergeClustersOperation op = new MergeClustersOperation(targetAddress);
            InternalCompletableFuture future = operationService.invokeOnTarget("hz:core:clusterService", op, member.getAddress());
            futures.add(future);
        }
        FutureUtil.waitWithDeadline(futures, 30L, TimeUnit.SECONDS, this.splitBrainMergeExceptionHandler);
        MergeClustersOperation mergeClustersOperation = new MergeClustersOperation(targetAddress);
        mergeClustersOperation.setNodeEngine(this.node.nodeEngine).setService(clusterService).setOperationResponseHandler(OperationResponseHandlerFactory.createEmptyResponseHandler());
        operationService.run(mergeClustersOperation);
    }

    private boolean prepareClusterState(ClusterServiceImpl clusterService) {
        if (!this.preCheckClusterState(clusterService)) {
            return false;
        }
        long until = Clock.currentTimeMillis() + this.mergeNextRunDelayMs;
        while (clusterService.getClusterState() == ClusterState.ACTIVE) {
            try {
                clusterService.changeClusterState(ClusterState.FROZEN);
                return true;
            }
            catch (Exception e) {
                String error = e.getClass().getName() + ": " + e.getMessage();
                this.logger.warning("While freezing cluster state! " + error);
                if (Clock.currentTimeMillis() >= until) {
                    this.logger.warning("Could not change cluster state to FROZEN in time. Postponing merge process until next attempt.");
                    return false;
                }
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e2) {
                    this.logger.warning("Interrupted while preparing cluster for merge!");
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
        }
        return false;
    }

    private boolean preCheckClusterState(ClusterService clusterService) {
        ClusterState initialState = clusterService.getClusterState();
        if (initialState != ClusterState.ACTIVE) {
            this.logger.warning("Could not prepare cluster state since it has been changed to " + (Object)((Object)initialState));
            return false;
        }
        return true;
    }

    protected Address getTargetAddress() {
        Address target = this.targetAddress;
        this.targetAddress = null;
        return target;
    }
}

