/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.hotrestart.HotRestartService;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.LifecycleServiceImpl;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.cluster.impl.ClusterClockImpl;
import com.hazelcast.internal.cluster.impl.ClusterHeartbeatManager;
import com.hazelcast.internal.cluster.impl.ClusterJoinManager;
import com.hazelcast.internal.cluster.impl.ClusterMergeTask;
import com.hazelcast.internal.cluster.impl.ClusterStateChange;
import com.hazelcast.internal.cluster.impl.ClusterStateManager;
import com.hazelcast.internal.cluster.impl.MemberMap;
import com.hazelcast.internal.cluster.impl.MemberSelectingCollection;
import com.hazelcast.internal.cluster.impl.SplitBrainHandler;
import com.hazelcast.internal.cluster.impl.operations.MemberInfoUpdateOperation;
import com.hazelcast.internal.cluster.impl.operations.MemberRemoveOperation;
import com.hazelcast.internal.cluster.impl.operations.ShutdownNodeOperation;
import com.hazelcast.internal.cluster.impl.operations.TriggerMemberListPublishOperation;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MemberAttributeServiceEvent;
import com.hazelcast.spi.MembershipAwareService;
import com.hazelcast.spi.MembershipServiceEvent;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.TransactionalService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.eventservice.InternalEventService;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.executor.ExecutorType;
import com.hazelcast.version.ClusterVersion;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ClusterServiceImpl
implements ClusterService,
ConnectionListener,
ManagedService,
EventPublishingService<MembershipEvent, MembershipListener>,
TransactionalService {
    public static final String SERVICE_NAME = "hz:core:clusterService";
    static final String EXECUTOR_NAME = "hz:cluster";
    private static final int DEFAULT_MERGE_RUN_DELAY_MILLIS = 100;
    private static final int CLUSTER_EXECUTOR_QUEUE_CAPACITY = 1000;
    private static final long CLUSTER_SHUTDOWN_SLEEP_DURATION_IN_MILLIS = 1000L;
    private static final String MEMBERSHIP_EVENT_EXECUTOR_NAME = "hz:cluster:event";
    private final Address thisAddress;
    private final Lock lock = new ReentrantLock();
    private final AtomicReference<MemberMap> memberMapRef = new AtomicReference<MemberMap>(MemberMap.empty());
    private final AtomicReference<MemberMap> membersRemovedInNotActiveStateRef = new AtomicReference<MemberMap>(MemberMap.empty());
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final ClusterClockImpl clusterClock;
    private final ClusterStateManager clusterStateManager;
    private final ClusterJoinManager clusterJoinManager;
    private final ClusterHeartbeatManager clusterHeartbeatManager;
    private String clusterId;

    public ClusterServiceImpl(Node node) {
        this.node = node;
        this.nodeEngine = node.nodeEngine;
        this.logger = node.getLogger(ClusterService.class.getName());
        this.clusterClock = new ClusterClockImpl(this.logger);
        this.thisAddress = node.getThisAddress();
        this.clusterStateManager = new ClusterStateManager(node, this.lock);
        this.clusterJoinManager = new ClusterJoinManager(node, this, this.lock);
        this.clusterHeartbeatManager = new ClusterHeartbeatManager(node, this);
        this.registerThisMember();
        node.connectionManager.addConnectionListener(this);
        this.nodeEngine.getExecutionService().register(MEMBERSHIP_EVENT_EXECUTOR_NAME, 1, Integer.MAX_VALUE, ExecutorType.CACHED);
        this.registerMetrics();
    }

    private void registerThisMember() {
        MemberImpl thisMember = this.node.getLocalMember();
        this.setMembers(thisMember);
        this.sendMembershipEvents(Collections.<MemberImpl>emptySet(), Collections.singleton(thisMember));
    }

    private void registerMetrics() {
        MetricsRegistry metricsRegistry = this.node.nodeEngine.getMetricsRegistry();
        metricsRegistry.scanAndRegister(this.clusterClock, "cluster.clock");
        metricsRegistry.scanAndRegister(this.clusterHeartbeatManager, "cluster.heartbeat");
        metricsRegistry.scanAndRegister(this, "cluster");
    }

    @Override
    public ClusterClockImpl getClusterClock() {
        return this.clusterClock;
    }

    @Override
    public long getClusterTime() {
        return this.clusterClock.getClusterTime();
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        if (this.clusterId == null) {
            this.clusterId = clusterId;
        }
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        long mergeFirstRunDelayMs = this.node.getProperties().getMillis(GroupProperty.MERGE_FIRST_RUN_DELAY_SECONDS);
        mergeFirstRunDelayMs = mergeFirstRunDelayMs > 0L ? mergeFirstRunDelayMs : 100L;
        ExecutionService executionService = nodeEngine.getExecutionService();
        executionService.register(EXECUTOR_NAME, 2, 1000, ExecutorType.CACHED);
        long mergeNextRunDelayMs = this.node.getProperties().getMillis(GroupProperty.MERGE_NEXT_RUN_DELAY_SECONDS);
        mergeNextRunDelayMs = mergeNextRunDelayMs > 0L ? mergeNextRunDelayMs : 100L;
        executionService.scheduleWithRepetition(EXECUTOR_NAME, new SplitBrainHandler(this.node), mergeFirstRunDelayMs, mergeNextRunDelayMs, TimeUnit.MILLISECONDS);
        this.clusterHeartbeatManager.init();
    }

    public void sendMemberListToMember(Address target) {
        if (!this.isMaster()) {
            return;
        }
        if (this.thisAddress.equals(target)) {
            return;
        }
        MemberImpl member = this.getMember(target);
        String memberUuid = member != null ? member.getUuid() : null;
        Collection<MemberImpl> members = this.getMemberImpls();
        MemberInfoUpdateOperation op = new MemberInfoUpdateOperation(memberUuid, ClusterServiceImpl.createMemberInfoList(members), this.clusterClock.getClusterTime(), null, false);
        this.nodeEngine.getOperationService().send(op, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAddress(Address deadAddress, String uuid, String reason) {
        this.lock.lock();
        try {
            MemberImpl member = this.getMember(deadAddress);
            if (member == null || !uuid.equals(member.getUuid())) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Cannot remove " + deadAddress + ", either member is not present " + "or uuid is not matching. Uuid: " + uuid + ", member: " + member);
                }
                return;
            }
            this.doRemoveAddress(deadAddress, reason, true);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeAddress(Address deadAddress, String reason) {
        this.doRemoveAddress(deadAddress, reason, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRemoveAddress(Address deadAddress, String reason, boolean destroyConnection) {
        if (!this.ensureMemberIsRemovable(deadAddress)) {
            return;
        }
        this.lock.lock();
        try {
            MemberImpl deadMember;
            if (deadAddress.equals(this.node.getMasterAddress())) {
                this.assignNewMaster();
            }
            if (this.node.isMaster()) {
                this.clusterJoinManager.removeJoin(deadAddress);
            }
            Connection conn = this.node.connectionManager.getConnection(deadAddress);
            if (destroyConnection && conn != null) {
                conn.close(reason, null);
            }
            if ((deadMember = this.getMember(deadAddress)) != null) {
                this.removeMember(deadMember);
                this.logger.info(this.membersString());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean ensureMemberIsRemovable(Address deadAddress) {
        if (!this.node.joined()) {
            return false;
        }
        return !deadAddress.equals(this.thisAddress);
    }

    private void assignNewMaster() {
        Address oldMasterAddress = this.node.getMasterAddress();
        if (this.node.joined()) {
            Set<Member> members = this.getMembers();
            Member newMaster = null;
            int size = members.size();
            if (size > 1) {
                Iterator iterator = members.iterator();
                Member member = (Member)iterator.next();
                if (member.getAddress().equals(oldMasterAddress)) {
                    newMaster = (Member)iterator.next();
                } else {
                    this.logger.severe(String.format("Old master %s is dead, but the first of member list is a different member %s!", oldMasterAddress, member));
                    newMaster = member;
                }
            } else {
                this.logger.warning(String.format("Old master %s is dead and this node is not master, but member list contains only %d members: %s", oldMasterAddress, size, members));
            }
            this.logger.info(String.format("Old master %s left the cluster, assigning new master %s", oldMasterAddress, newMaster));
            if (newMaster != null) {
                this.node.setMasterAddress(newMaster.getAddress());
            } else {
                this.node.setMasterAddress(null);
            }
        } else {
            this.node.setMasterAddress(null);
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine(String.format("Old master: %s, new master: %s ", oldMasterAddress, this.node.getMasterAddress()));
        }
        if (this.node.isMaster()) {
            this.clusterHeartbeatManager.resetMemberMasterConfirmations();
        } else {
            this.clusterHeartbeatManager.sendMasterConfirmation();
        }
    }

    public void merge(Address newTargetAddress) {
        this.node.getJoiner().setTargetAddress(newTargetAddress);
        LifecycleServiceImpl lifecycleService = this.node.hazelcastInstance.getLifecycleService();
        lifecycleService.runUnderLifecycleLock(new ClusterMergeTask(this.node));
    }

    @Override
    public void reset() {
        this.lock.lock();
        try {
            this.memberMapRef.set(MemberMap.singleton(this.node.getLocalMember()));
            this.clusterHeartbeatManager.reset();
            this.clusterStateManager.reset();
            this.clusterJoinManager.reset();
            this.membersRemovedInNotActiveStateRef.set(MemberMap.empty());
        }
        finally {
            this.lock.unlock();
        }
    }

    static List<MemberInfo> createMemberInfoList(Collection<MemberImpl> members) {
        LinkedList<MemberInfo> memberInfos = new LinkedList<MemberInfo>();
        for (MemberImpl member : members) {
            memberInfos.add(new MemberInfo(member));
        }
        return memberInfos;
    }

    static Set<MemberInfo> createMemberInfoSet(Collection<MemberImpl> members) {
        HashSet<MemberInfo> memberInfos = new HashSet<MemberInfo>();
        for (MemberImpl member : members) {
            memberInfos.add(new MemberInfo(member));
        }
        return memberInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMembers(Collection<MemberInfo> members) {
        this.lock.lock();
        try {
            MemberMap currentMemberMap = this.memberMapRef.get();
            if (!this.shouldProcessMemberUpdate(currentMemberMap, members)) {
                return;
            }
            String scopeId = this.thisAddress.getScopeId();
            LinkedList<MemberImpl> newMembers = new LinkedList<MemberImpl>();
            MemberImpl[] updatedMembers = new MemberImpl[members.size()];
            int memberIndex = 0;
            for (MemberInfo memberInfo : members) {
                Address address = memberInfo.getAddress();
                MemberImpl member = currentMemberMap.getMember(address);
                if (member == null) {
                    member = this.createMember(memberInfo, scopeId);
                    newMembers.add(member);
                    long now = this.clusterClock.getClusterTime();
                    this.clusterHeartbeatManager.onHeartbeat(member, now);
                    this.clusterHeartbeatManager.acceptMasterConfirmation(member, now);
                    this.repairPartitionTableIfReturningMember(member);
                }
                updatedMembers[memberIndex++] = member;
            }
            this.setMembers(updatedMembers);
            this.sendMembershipEvents(currentMemberMap.getMembers(), newMembers);
            MemberMap membersRemovedInNotActiveState = this.membersRemovedInNotActiveStateRef.get();
            this.membersRemovedInNotActiveStateRef.set(MemberMap.cloneExcluding(membersRemovedInNotActiveState, updatedMembers));
            this.node.setJoined();
            this.clusterHeartbeatManager.heartbeat();
            this.logger.info(this.membersString());
        }
        finally {
            this.lock.unlock();
        }
    }

    private void repairPartitionTableIfReturningMember(MemberImpl member) {
        Address oldAddress;
        if (!this.isMaster()) {
            return;
        }
        if (this.getClusterState() == ClusterState.ACTIVE) {
            return;
        }
        if (!this.node.getNodeExtension().isStartCompleted()) {
            return;
        }
        Address address = member.getAddress();
        MemberImpl memberRemovedWhileClusterIsNotActive = this.getMemberRemovedWhileClusterIsNotActive(member.getUuid());
        if (memberRemovedWhileClusterIsNotActive != null && !(oldAddress = memberRemovedWhileClusterIsNotActive.getAddress()).equals(address)) {
            assert (!this.isMemberRemovedWhileClusterIsNotActive(address));
            this.logger.warning(member + " is returning with a new address. Old one was: " + oldAddress + ". Will update partition table with the new address.");
            InternalPartitionServiceImpl partitionService = this.node.partitionService;
            partitionService.replaceAddress(oldAddress, address);
        }
    }

    private boolean shouldProcessMemberUpdate(MemberMap currentMembers, Collection<MemberInfo> newMemberInfos) {
        int newMembersSize;
        int currentMembersSize = currentMembers.size();
        if (currentMembersSize > (newMembersSize = newMemberInfos.size())) {
            this.logger.warning("Received an older member update, no need to process...");
            this.nodeEngine.getOperationService().send(new TriggerMemberListPublishOperation(), this.getMasterAddress());
            return false;
        }
        if (currentMembersSize == newMembersSize) {
            Set<MemberInfo> currentMemberInfos = ClusterServiceImpl.createMemberInfoSet(currentMembers.getMembers());
            if (currentMemberInfos.containsAll(newMemberInfos)) {
                this.logger.fine("Received a periodic member update, no need to process...");
            } else {
                this.logger.warning("Received an inconsistent member update which contains new members and removes some of the current members! Ignoring and requesting a new member update...");
                this.nodeEngine.getOperationService().send(new TriggerMemberListPublishOperation(), this.getMasterAddress());
            }
            return false;
        }
        Set<MemberInfo> currentMemberInfos = ClusterServiceImpl.createMemberInfoSet(currentMembers.getMembers());
        currentMemberInfos.removeAll(newMemberInfos);
        if (currentMemberInfos.isEmpty()) {
            return true;
        }
        this.logger.warning("Received an inconsistent member update. It has more members but also removes some of the current members! Ignoring and requesting a new member update...");
        this.nodeEngine.getOperationService().send(new TriggerMemberListPublishOperation(), this.getMasterAddress());
        return false;
    }

    private void sendMembershipEvents(Collection<MemberImpl> currentMembers, Collection<MemberImpl> newMembers) {
        LinkedHashSet<MemberImpl> eventMembers = new LinkedHashSet<MemberImpl>(currentMembers);
        if (!newMembers.isEmpty()) {
            if (newMembers.size() == 1) {
                MemberImpl newMember = newMembers.iterator().next();
                this.node.getPartitionService().memberAdded(newMember);
                eventMembers.add(newMember);
                this.sendMembershipEventNotifications(newMember, Collections.unmodifiableSet(eventMembers), true);
            } else {
                for (MemberImpl newMember : newMembers) {
                    this.node.getPartitionService().memberAdded(newMember);
                    eventMembers.add(newMember);
                    this.sendMembershipEventNotifications(newMember, Collections.unmodifiableSet(new LinkedHashSet<MemberImpl>(eventMembers)), true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMemberAttribute(String uuid, MemberAttributeOperationType operationType, String key, Object value) {
        this.lock.lock();
        try {
            MemberMap memberMap = this.memberMapRef.get();
            for (MemberImpl member : memberMap.getMembers()) {
                if (!member.getUuid().equals(uuid)) continue;
                if (!member.equals(this.getLocalMember())) {
                    member.updateAttribute(operationType, key, value);
                }
                this.sendMemberAttributeEvent(member, operationType, key, value);
                break;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void connectionAdded(Connection connection) {
    }

    @Override
    public void connectionRemoved(Connection connection) {
        Address masterAddress;
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Removed connection " + connection.getEndPoint());
        }
        if (!this.node.joined() && (masterAddress = this.node.getMasterAddress()) != null && masterAddress.equals(connection.getEndPoint())) {
            this.node.setMasterAddress(null);
        }
    }

    public NodeEngineImpl getNodeEngine() {
        return this.nodeEngine;
    }

    private void setMembers(MemberImpl ... members) {
        if (members == null || members.length == 0) {
            return;
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Updating members " + Arrays.toString(members));
        }
        this.lock.lock();
        try {
            this.memberMapRef.set(MemberMap.createNew(members));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMember(MemberImpl deadMember) {
        this.logger.info("Removing " + deadMember);
        this.lock.lock();
        try {
            MemberMap currentMembers = this.memberMapRef.get();
            Address deadAddress = deadMember.getAddress();
            if (currentMembers.contains(deadAddress)) {
                ClusterState clusterState;
                this.clusterHeartbeatManager.removeMember(deadMember);
                MemberMap newMembers = MemberMap.cloneExcluding(currentMembers, deadMember);
                this.memberMapRef.set(newMembers);
                if (this.node.isMaster()) {
                    if (this.logger.isFineEnabled()) {
                        this.logger.fine(deadMember + " is dead, sending remove to all other members...");
                    }
                    this.sendMemberRemoveOperation(deadMember);
                }
                if ((clusterState = this.clusterStateManager.getState()) != ClusterState.ACTIVE) {
                    if (this.logger.isFineEnabled()) {
                        this.logger.fine(deadMember + " is dead, added to members left while cluster is " + (Object)((Object)clusterState) + " state");
                    }
                    if (!this.node.getNodeExtension().isMemberExcluded(deadAddress, deadMember.getUuid())) {
                        MemberMap membersRemovedInNotActiveState = this.membersRemovedInNotActiveStateRef.get();
                        this.membersRemovedInNotActiveStateRef.set(MemberMap.cloneAdding(membersRemovedInNotActiveState, deadMember));
                    }
                    InternalPartitionServiceImpl partitionService = this.node.partitionService;
                    partitionService.cancelReplicaSyncRequestsTo(deadAddress);
                } else {
                    this.onMemberRemove(deadMember, newMembers);
                }
                this.sendMembershipEventNotifications(deadMember, Collections.unmodifiableSet(new LinkedHashSet<MemberImpl>(newMembers.getMembers())), false);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void onMemberRemove(MemberImpl deadMember, MemberMap newMembers) {
        this.node.getPartitionService().memberRemoved(deadMember);
        this.nodeEngine.onMemberLeft(deadMember);
    }

    public boolean isMemberRemovedWhileClusterIsNotActive(Address target) {
        MemberMap membersRemovedInNotActiveState = this.membersRemovedInNotActiveStateRef.get();
        return membersRemovedInNotActiveState.contains(target);
    }

    boolean isMemberRemovedWhileClusterIsNotActive(String uuid) {
        MemberMap membersRemovedInNotActiveState = this.membersRemovedInNotActiveStateRef.get();
        return membersRemovedInNotActiveState.contains(uuid);
    }

    MemberImpl getMemberRemovedWhileClusterIsNotActive(String uuid) {
        MemberMap membersRemovedInNotActiveState = this.membersRemovedInNotActiveStateRef.get();
        return membersRemovedInNotActiveState.getMember(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Member> getCurrentMembersAndMembersRemovedWhileClusterIsNotActive() {
        this.lock.lock();
        try {
            MemberMap membersRemovedInNotActiveState = this.membersRemovedInNotActiveStateRef.get();
            if (membersRemovedInNotActiveState.size() == 0) {
                Set<Member> set = this.getMembers();
                return set;
            }
            Set<MemberImpl> removedMembers = membersRemovedInNotActiveState.getMembers();
            Set<MemberImpl> members = this.memberMapRef.get().getMembers();
            ArrayList<Member> allMembers = new ArrayList<Member>(members.size() + removedMembers.size());
            allMembers.addAll(members);
            allMembers.addAll(removedMembers);
            ArrayList<Member> arrayList = allMembers;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMembersDeadWhileClusterIsNotActive() {
        this.lock.lock();
        try {
            MemberMap memberMap = this.memberMapRef.get();
            MemberMap membersRemovedInNotActiveState = this.membersRemovedInNotActiveStateRef.get();
            Set<MemberImpl> members = membersRemovedInNotActiveState.getMembers();
            this.membersRemovedInNotActiveStateRef.set(MemberMap.empty());
            for (MemberImpl member : members) {
                this.onMemberRemove(member, memberMap);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void notifyForRemovedMember(MemberImpl member) {
        this.lock.lock();
        try {
            MemberMap memberMap = this.memberMapRef.get();
            this.onMemberRemove(member, memberMap);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shrinkMembersRemovedWhileClusterIsNotActiveState(Collection<String> memberUuidsToRemove) {
        this.lock.lock();
        try {
            LinkedHashSet<MemberImpl> membersRemovedInNotActiveState = new LinkedHashSet<MemberImpl>(this.membersRemovedInNotActiveStateRef.get().getMembers());
            Iterator it = membersRemovedInNotActiveState.iterator();
            while (it.hasNext()) {
                MemberImpl member = (MemberImpl)it.next();
                if (!memberUuidsToRemove.contains(member.getUuid())) continue;
                this.logger.fine("Removing " + member + " from members removed while in cluster not active state");
                it.remove();
            }
            this.membersRemovedInNotActiveStateRef.set(MemberMap.createNew(membersRemovedInNotActiveState.toArray(new MemberImpl[0])));
        }
        finally {
            this.lock.unlock();
        }
    }

    private void sendMemberRemoveOperation(Member deadMember) {
        for (Member member : this.getMembers()) {
            Address address = member.getAddress();
            if (this.thisAddress.equals(address) || address.equals(deadMember.getAddress())) continue;
            MemberRemoveOperation op = new MemberRemoveOperation(deadMember.getAddress(), deadMember.getUuid());
            this.nodeEngine.getOperationService().send(op, address);
        }
    }

    public void sendShutdownMessage() {
        this.sendMemberRemoveOperation(this.getLocalMember());
    }

    private void sendMembershipEventNotifications(MemberImpl member, Set<Member> members, final boolean added) {
        int eventType = added ? 1 : 2;
        MembershipEvent membershipEvent = new MembershipEvent(this, member, eventType, members);
        Collection<MembershipAwareService> membershipAwareServices = this.nodeEngine.getServices(MembershipAwareService.class);
        if (membershipAwareServices != null && !membershipAwareServices.isEmpty()) {
            final MembershipServiceEvent event = new MembershipServiceEvent(membershipEvent);
            for (final MembershipAwareService service : membershipAwareServices) {
                this.nodeEngine.getExecutionService().execute(MEMBERSHIP_EVENT_EXECUTOR_NAME, new Runnable(){

                    @Override
                    public void run() {
                        if (added) {
                            service.memberAdded(event);
                        } else {
                            service.memberRemoved(event);
                        }
                    }
                });
            }
        }
        InternalEventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations(SERVICE_NAME, SERVICE_NAME);
        for (EventRegistration reg : registrations) {
            eventService.publishEvent(SERVICE_NAME, reg, (Object)membershipEvent, reg.getId().hashCode());
        }
    }

    private void sendMemberAttributeEvent(MemberImpl member, MemberAttributeOperationType operationType, String key, Object value) {
        final MemberAttributeServiceEvent event = new MemberAttributeServiceEvent((Cluster)this, member, operationType, key, value);
        MemberAttributeEvent attributeEvent = new MemberAttributeEvent(this, member, operationType, key, value);
        Collection<MembershipAwareService> membershipAwareServices = this.nodeEngine.getServices(MembershipAwareService.class);
        if (membershipAwareServices != null && !membershipAwareServices.isEmpty()) {
            for (final MembershipAwareService service : membershipAwareServices) {
                this.nodeEngine.getExecutionService().execute("hz:system", new Runnable(){

                    @Override
                    public void run() {
                        service.memberAttributeChanged(event);
                    }
                });
            }
        }
        InternalEventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations(SERVICE_NAME, SERVICE_NAME);
        for (EventRegistration reg : registrations) {
            eventService.publishEvent(SERVICE_NAME, reg, (Object)attributeEvent, reg.getId().hashCode());
        }
    }

    private MemberImpl createMember(MemberInfo memberInfo, String ipV6ScopeId) {
        Address address = memberInfo.getAddress();
        address.setScopeId(ipV6ScopeId);
        return new MemberImpl(address, memberInfo.getVersion(), this.thisAddress.equals(address), memberInfo.getUuid(), (HazelcastInstanceImpl)this.nodeEngine.getHazelcastInstance(), memberInfo.getAttributes(), memberInfo.isLiteMember());
    }

    @Override
    public MemberImpl getMember(Address address) {
        if (address == null) {
            return null;
        }
        MemberMap memberMap = this.memberMapRef.get();
        return memberMap.getMember(address);
    }

    @Override
    public MemberImpl getMember(String uuid) {
        if (uuid == null) {
            return null;
        }
        MemberMap memberMap = this.memberMapRef.get();
        return memberMap.getMember(uuid);
    }

    @Override
    public Collection<MemberImpl> getMemberImpls() {
        return this.memberMapRef.get().getMembers();
    }

    public Collection<Address> getMemberAddresses() {
        return this.memberMapRef.get().getAddresses();
    }

    @Override
    public Set<Member> getMembers() {
        return this.memberMapRef.get().getMembers();
    }

    @Override
    public Collection<Member> getMembers(MemberSelector selector) {
        return new MemberSelectingCollection<Member>(this.memberMapRef.get().getMembers(), selector);
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    @Override
    public Address getMasterAddress() {
        return this.node.getMasterAddress();
    }

    @Override
    public boolean isMaster() {
        return this.node.isMaster();
    }

    @Override
    public Address getThisAddress() {
        return this.thisAddress;
    }

    @Override
    public Member getLocalMember() {
        return this.node.getLocalMember();
    }

    @Override
    @Probe(name="size")
    public int getSize() {
        return this.getMembers().size();
    }

    @Override
    public int getSize(MemberSelector selector) {
        int size = 0;
        for (MemberImpl member : this.memberMapRef.get().getMembers()) {
            if (!selector.select(member)) continue;
            ++size;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addMembershipListener(MembershipListener listener) {
        EventRegistration registration;
        Preconditions.checkNotNull(listener, "listener cannot be null");
        InternalEventService eventService = this.nodeEngine.getEventService();
        if (listener instanceof InitialMembershipListener) {
            this.lock.lock();
            try {
                ((InitialMembershipListener)listener).init(new InitialMembershipEvent(this, this.getMembers()));
                registration = eventService.registerLocalListener(SERVICE_NAME, SERVICE_NAME, listener);
            }
            finally {
                this.lock.unlock();
            }
        } else {
            registration = eventService.registerLocalListener(SERVICE_NAME, SERVICE_NAME, listener);
        }
        return registration.getId();
    }

    @Override
    public boolean removeMembershipListener(String registrationId) {
        Preconditions.checkNotNull(registrationId, "registrationId cannot be null");
        InternalEventService eventService = this.nodeEngine.getEventService();
        return eventService.deregisterListener(SERVICE_NAME, SERVICE_NAME, registrationId);
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void dispatchEvent(MembershipEvent event, MembershipListener listener) {
        switch (event.getEventType()) {
            case 1: {
                listener.memberAdded(event);
                break;
            }
            case 2: {
                listener.memberRemoved(event);
                break;
            }
            case 5: {
                MemberAttributeEvent memberAttributeEvent = (MemberAttributeEvent)event;
                listener.memberAttributeChanged(memberAttributeEvent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled event: " + event);
            }
        }
    }

    public String membersString() {
        StringBuilder sb = new StringBuilder("\n\nMembers [");
        Collection<MemberImpl> members = this.getMemberImpls();
        sb.append(members != null ? members.size() : 0);
        sb.append("] {");
        if (members != null) {
            for (Member member : members) {
                sb.append("\n\t").append(member);
            }
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    @Override
    public ClusterState getClusterState() {
        return this.clusterStateManager.getState();
    }

    @Override
    public <T extends TransactionalObject> T createTransactionalObject(String name, Transaction transaction) {
        throw new UnsupportedOperationException("hz:core:clusterService does not support TransactionalObjects!");
    }

    @Override
    public void rollbackTransaction(String transactionId) {
        this.logger.info("Rolling back cluster state. Transaction: " + transactionId);
        this.clusterStateManager.rollbackClusterState(transactionId);
    }

    @Override
    public void changeClusterState(ClusterState newState) {
        this.changeClusterState(newState, false);
    }

    private void changeClusterState(ClusterState newState, boolean isTransient) {
        int partitionStateVersion = this.node.getPartitionService().getPartitionStateVersion();
        this.clusterStateManager.changeClusterState(ClusterStateChange.from(newState), this.getMembers(), partitionStateVersion, isTransient);
    }

    @Override
    public void changeClusterState(ClusterState newState, TransactionOptions options) {
        this.changeClusterState(newState, options, false);
    }

    private void changeClusterState(ClusterState newState, TransactionOptions options, boolean isTransient) {
        int partitionStateVersion = this.node.getPartitionService().getPartitionStateVersion();
        this.clusterStateManager.changeClusterState(ClusterStateChange.from(newState), this.getMembers(), options, partitionStateVersion, isTransient);
    }

    @Override
    public ClusterVersion getClusterVersion() {
        return this.clusterStateManager.getClusterVersion();
    }

    @Override
    public HotRestartService getHotRestartService() {
        return this.node.getNodeExtension().getHotRestartBackupService();
    }

    @Override
    public void changeClusterVersion(ClusterVersion version) {
        int partitionStateVersion = this.node.getPartitionService().getPartitionStateVersion();
        this.clusterStateManager.changeClusterState(ClusterStateChange.from(version), this.getMembers(), partitionStateVersion, false);
    }

    @Override
    public void changeClusterVersion(ClusterVersion version, TransactionOptions options) {
        int partitionStateVersion = this.node.getPartitionService().getPartitionStateVersion();
        this.clusterStateManager.changeClusterState(ClusterStateChange.from(version), this.getMembers(), options, partitionStateVersion, false);
    }

    void addMembersRemovedInNotActiveState(Collection<MemberImpl> members) {
        this.lock.lock();
        try {
            members.remove(this.node.getLocalMember());
            MemberMap membersRemovedInNotActiveState = this.membersRemovedInNotActiveStateRef.get();
            this.membersRemovedInNotActiveStateRef.set(MemberMap.cloneAdding(membersRemovedInNotActiveState, members.toArray(new MemberImpl[0])));
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.changeClusterState(ClusterState.PASSIVE, true);
        this.shutdownNodes();
    }

    @Override
    public void shutdown(TransactionOptions options) {
        this.changeClusterState(ClusterState.PASSIVE, options, true);
        this.shutdownNodes();
    }

    private void shutdownNodes() {
        ShutdownNodeOperation op = new ShutdownNodeOperation();
        this.logger.info("Sending shutting down operations to all members...");
        Collection<Member> members = this.getMembers(MemberSelectors.NON_LOCAL_MEMBER_SELECTOR);
        long timeout = this.node.getProperties().getNanos(GroupProperty.CLUSTER_SHUTDOWN_TIMEOUT_SECONDS);
        long startTime = System.nanoTime();
        while (System.nanoTime() - startTime < timeout && !members.isEmpty()) {
            for (Member member : members) {
                this.nodeEngine.getOperationService().send(op, member.getAddress());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.warning("Shutdown sleep interrupted. ", e);
                break;
            }
            members = this.getMembers(MemberSelectors.NON_LOCAL_MEMBER_SELECTOR);
        }
        this.logger.info("Number of other nodes remaining: " + this.getSize(MemberSelectors.NON_LOCAL_MEMBER_SELECTOR) + ". Shutting down itself.");
        HazelcastInstanceImpl hazelcastInstance = this.node.hazelcastInstance;
        hazelcastInstance.getLifecycleService().shutdown();
    }

    public void initialClusterState(ClusterState clusterState, ClusterVersion version) {
        if (this.node.joined()) {
            throw new IllegalStateException("Cannot set initial state after node joined! -> " + (Object)((Object)clusterState));
        }
        this.clusterStateManager.initialClusterState(clusterState, version);
    }

    public ClusterStateManager getClusterStateManager() {
        return this.clusterStateManager;
    }

    public ClusterJoinManager getClusterJoinManager() {
        return this.clusterJoinManager;
    }

    public ClusterHeartbeatManager getClusterHeartbeatManager() {
        return this.clusterHeartbeatManager;
    }

    public String toString() {
        return "ClusterService{address=" + this.thisAddress + '}';
    }
}

