/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.Address;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

final class MemberMap {
    private final Map<Address, MemberImpl> addressToMemberMap;
    private final Map<String, MemberImpl> uuidToMemberMap;
    private final Set<MemberImpl> members;

    private MemberMap(Map<Address, MemberImpl> addressMap, Map<String, MemberImpl> uuidMap) {
        assert (new HashSet<MemberImpl>(addressMap.values()).equals(new HashSet<MemberImpl>(uuidMap.values()))) : "Maps are different! AddressMap: " + addressMap + ", UuidMap: " + uuidMap;
        this.addressToMemberMap = addressMap;
        this.uuidToMemberMap = uuidMap;
        this.members = Collections.unmodifiableSet(new LinkedHashSet<MemberImpl>(this.addressToMemberMap.values()));
    }

    static MemberMap empty() {
        return new MemberMap(Collections.<Address, MemberImpl>emptyMap(), Collections.<String, MemberImpl>emptyMap());
    }

    static MemberMap singleton(MemberImpl member) {
        return new MemberMap(Collections.singletonMap(member.getAddress(), member), Collections.singletonMap(member.getUuid(), member));
    }

    static MemberMap createNew(MemberImpl ... members) {
        LinkedHashMap<Address, MemberImpl> addressMap = new LinkedHashMap<Address, MemberImpl>();
        LinkedHashMap<String, MemberImpl> uuidMap = new LinkedHashMap<String, MemberImpl>();
        for (MemberImpl member : members) {
            MemberMap.putMember(addressMap, uuidMap, member);
        }
        return new MemberMap(addressMap, uuidMap);
    }

    static MemberMap cloneExcluding(MemberMap source, MemberImpl ... excludeMembers) {
        if (source.size() == 0) {
            return source;
        }
        LinkedHashMap<Address, MemberImpl> addressMap = new LinkedHashMap<Address, MemberImpl>(source.addressToMemberMap);
        LinkedHashMap<String, MemberImpl> uuidMap = new LinkedHashMap<String, MemberImpl>(source.uuidToMemberMap);
        for (MemberImpl member : excludeMembers) {
            MemberImpl removed = (MemberImpl)addressMap.remove(member.getAddress());
            if (removed != null) {
                uuidMap.remove(removed.getUuid());
            }
            if ((removed = (MemberImpl)uuidMap.remove(member.getUuid())) == null) continue;
            addressMap.remove(removed.getAddress());
        }
        return new MemberMap(addressMap, uuidMap);
    }

    static MemberMap cloneAdding(MemberMap source, MemberImpl ... newMembers) {
        LinkedHashMap<Address, MemberImpl> addressMap = new LinkedHashMap<Address, MemberImpl>(source.addressToMemberMap);
        LinkedHashMap<String, MemberImpl> uuidMap = new LinkedHashMap<String, MemberImpl>(source.uuidToMemberMap);
        for (MemberImpl member : newMembers) {
            MemberMap.putMember(addressMap, uuidMap, member);
        }
        return new MemberMap(addressMap, uuidMap);
    }

    private static void putMember(Map<Address, MemberImpl> addressMap, Map<String, MemberImpl> uuidMap, MemberImpl member) {
        MemberImpl current = addressMap.put(member.getAddress(), member);
        if (current != null) {
            throw new IllegalArgumentException("Replacing existing member with address: " + member);
        }
        current = uuidMap.put(member.getUuid(), member);
        if (current != null) {
            throw new IllegalArgumentException("Replacing existing member with uuid: " + member);
        }
    }

    MemberImpl getMember(Address address) {
        return this.addressToMemberMap.get(address);
    }

    MemberImpl getMember(String uuid) {
        return this.uuidToMemberMap.get(uuid);
    }

    boolean contains(Address address) {
        return this.addressToMemberMap.containsKey(address);
    }

    boolean contains(String uuid) {
        return this.uuidToMemberMap.containsKey(uuid);
    }

    Set<MemberImpl> getMembers() {
        return this.members;
    }

    Collection<Address> getAddresses() {
        return Collections.unmodifiableCollection(this.addressToMemberMap.keySet());
    }

    int size() {
        return this.members.size();
    }
}

