/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl.operations;

import com.hazelcast.instance.Node;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.internal.cluster.impl.operations.JoinOperation;
import com.hazelcast.internal.partition.PartitionRuntimeState;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class MemberInfoUpdateOperation
extends AbstractClusterOperation
implements JoinOperation,
IdentifiedDataSerializable {
    protected String targetUuid;
    protected Collection<MemberInfo> memberInfos;
    protected long masterTime = Clock.currentTimeMillis();
    protected PartitionRuntimeState partitionRuntimeState;
    protected boolean sendResponse;

    public MemberInfoUpdateOperation() {
        this.memberInfos = new ArrayList<MemberInfo>();
    }

    public MemberInfoUpdateOperation(String targetUuid, Collection<MemberInfo> memberInfos, long masterTime, PartitionRuntimeState partitionRuntimeState, boolean sendResponse) {
        this.targetUuid = targetUuid;
        this.masterTime = masterTime;
        this.memberInfos = memberInfos;
        this.sendResponse = sendResponse;
        this.partitionRuntimeState = partitionRuntimeState;
    }

    @Override
    public void run() throws Exception {
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        NodeEngineImpl nodeEngine = clusterService.getNodeEngine();
        Node node = nodeEngine.getNode();
        if (!node.joined()) {
            ILogger logger = this.getLogger();
            if (logger.isFineEnabled()) {
                logger.fine("Ignoring member info update since not joined yet...");
            }
            return;
        }
        if (!node.getThisUuid().equals(this.targetUuid)) {
            String msg = "targetUuid: " + this.targetUuid + " is different than this node's uuid: " + node.getThisUuid();
            throw new IllegalStateException(msg);
        }
        this.processMemberUpdate();
        this.processPartitionState();
    }

    final void processMemberUpdate() {
        if (this.isValid()) {
            ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
            clusterService.updateMembers(this.memberInfos);
        }
    }

    final void processPartitionState() {
        if (this.partitionRuntimeState == null) {
            return;
        }
        this.partitionRuntimeState.setEndpoint(this.getCallerAddress());
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        Node node = clusterService.getNodeEngine().getNode();
        node.partitionService.processPartitionRuntimeState(this.partitionRuntimeState);
    }

    protected final boolean isValid() {
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        Connection conn = this.getConnection();
        Address masterAddress = conn != null ? conn.getEndPoint() : null;
        boolean isLocal = conn == null;
        return isLocal || masterAddress != null && masterAddress.equals(clusterService.getMasterAddress());
    }

    @Override
    public final boolean returnsResponse() {
        return this.sendResponse;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.targetUuid = in.readUTF();
        this.masterTime = in.readLong();
        int size = in.readInt();
        this.memberInfos = new ArrayList<MemberInfo>(size);
        while (size-- > 0) {
            MemberInfo memberInfo = new MemberInfo();
            memberInfo.readData(in);
            this.memberInfos.add(memberInfo);
        }
        this.partitionRuntimeState = (PartitionRuntimeState)in.readObject();
        this.sendResponse = in.readBoolean();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.targetUuid);
        out.writeLong(this.masterTime);
        out.writeInt(this.memberInfos.size());
        for (MemberInfo memberInfo : this.memberInfos) {
            memberInfo.writeData(out);
        }
        out.writeObject(this.partitionRuntimeState);
        out.writeBoolean(this.sendResponse);
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", targetUuid=").append(this.targetUuid);
        sb.append(", members=");
        for (MemberInfo address : this.memberInfos) {
            sb.append(address).append(' ');
        }
    }

    @Override
    public int getId() {
        return 6;
    }
}

