/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl.operations;

import com.hazelcast.instance.NodeExtension;
import com.hazelcast.internal.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SendExcludedMemberUuidsOperation
extends AbstractClusterOperation {
    private Set<String> excludedMemberUuids;

    public SendExcludedMemberUuidsOperation() {
    }

    public SendExcludedMemberUuidsOperation(Set<String> excludedMemberUuids) {
        this.excludedMemberUuids = excludedMemberUuids != null ? excludedMemberUuids : Collections.emptySet();
    }

    @Override
    public void run() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        NodeExtension nodeExtension = nodeEngine.getNode().getNodeExtension();
        nodeExtension.handleExcludedMemberUuids(this.getCallerAddress(), this.excludedMemberUuids);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.excludedMemberUuids.size());
        for (String uuid : this.excludedMemberUuids) {
            out.writeUTF(uuid);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        HashSet<String> excludedMemberUuids = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            excludedMemberUuids.add(in.readUTF());
        }
        this.excludedMemberUuids = Collections.unmodifiableSet(excludedMemberUuids);
    }

    @Override
    public int getId() {
        return 35;
    }
}

