/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public abstract class DiagnosticsLogWriter {
    private static final int CHARS_LENGTH = 32;
    protected int sectionLevel = -1;
    private PrintWriter printWriter;
    private final Calendar calendar = new GregorianCalendar(TimeZone.getDefault());
    private final Date date = new Date();
    private char[] chars = new char[32];
    private StringBuilder stringBuilder = new StringBuilder();

    public abstract void startSection(String var1);

    public abstract void endSection();

    public abstract void writeEntry(String var1);

    public abstract void writeKeyValueEntry(String var1, String var2);

    public abstract void writeKeyValueEntry(String var1, double var2);

    public abstract void writeKeyValueEntry(String var1, long var2);

    public abstract void writeKeyValueEntry(String var1, boolean var2);

    protected void init(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    protected DiagnosticsLogWriter write(char c) {
        this.printWriter.write(c);
        return this;
    }

    protected DiagnosticsLogWriter write(int i) {
        this.stringBuilder.append(i);
        this.flushSb();
        return this;
    }

    protected DiagnosticsLogWriter write(double i) {
        this.stringBuilder.append(i);
        this.flushSb();
        return this;
    }

    protected DiagnosticsLogWriter write(long i) {
        this.stringBuilder.append(i);
        this.flushSb();
        return this;
    }

    private void flushSb() {
        int length = this.stringBuilder.length();
        this.stringBuilder.getChars(0, length, this.chars, 0);
        this.printWriter.write(this.chars, 0, length);
        this.stringBuilder.setLength(0);
    }

    protected DiagnosticsLogWriter write(boolean b) {
        this.write(b ? "true" : "false");
        return this;
    }

    protected DiagnosticsLogWriter write(String s) {
        this.printWriter.write(s == null ? "null" : s);
        return this;
    }

    protected void appendDateTime() {
        this.date.setTime(System.currentTimeMillis());
        this.calendar.setTime(this.date);
        this.appendDate();
        this.write(' ');
        this.appendTime();
    }

    private void appendDate() {
        this.write(this.calendar.get(5));
        this.write('-');
        this.write(this.calendar.get(2));
        this.write('-');
        this.write(this.calendar.get(1));
    }

    private void appendTime() {
        int hour = this.calendar.get(11);
        if (hour < 10) {
            this.write('0');
        }
        this.write(hour);
        this.write(':');
        int minute = this.calendar.get(12);
        if (minute < 10) {
            this.write('0');
        }
        this.write(minute);
        this.write(':');
        int second = this.calendar.get(13);
        if (second < 10) {
            this.write('0');
        }
        this.write(second);
    }
}

