/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.distributedclassloading;

import com.hazelcast.internal.distributedclassloading.DistributedClassloadingService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;

public class DistributedClassLoader
extends ClassLoader {
    private static final ILogger LOG = Logger.getLogger(DistributedClassLoader.class);
    private DistributedClassloadingService distributedClassloadingService;

    public DistributedClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void setDistributedClassloadingService(DistributedClassloadingService service) {
        this.distributedClassloadingService = service;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (this.distributedClassloadingService != null) {
            clazz = this.distributedClassloadingService.findLoadedClass(name);
        }
        if (clazz == null) {
            try {
                return super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException e) {
                if (this.distributedClassloadingService == null) {
                    LOG.finest("Distributed classloader is not initialized yet. ");
                    throw e;
                }
                clazz = this.distributedClassloadingService.handleClassNotFoundException(name);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        return clazz;
    }
}

